/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.ExtractableSubstringInfoKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRange;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a%\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f\u001a\u00b6\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192B\u0010\u001b\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001d0\u001c2<\u0010\"\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00120\u001c\u001a\u00b6\u0001\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192B\u0010\u001b\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001d0\u001c2<\u0010\"\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00120\u001c\u001a&\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014\u001a&\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014\u001a\u0018\u0010+\u001a\u00020\f*\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-\u001a\u0018\u0010.\u001a\u00020\u0001*\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-\u001a\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d*\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-\u001a\n\u00100\u001a\u000201*\u000202\u001a\n\u00103\u001a\u00020\u000f*\u00020\u0001\u001a\u0012\u00104\u001a\u00020\u0001*\u0002052\u0006\u00106\u001a\u00020\u0001\u00a8\u00067"}, d2={"findExpressionOrStringFragment", "Lorg/jetbrains/kotlin/psi/KtExpression;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "insertDeclaration", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "targetSibling", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isObjectOrNonInnerClass", "", "e", "selectElementsWithTargetParent", "", "operationName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "title", "elementKinds", "", "Lorg/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils$ElementKind;", "getContainers", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "elements", "commonParent", "continuation", "targetParent", "selectElementsWithTargetSibling", "showErrorHint", "project", "Lcom/intellij/openapi/project/Project;", "message", "showErrorHintByKey", "messageKey", "findElementByCopyableDataAndClearIt", "key", "Lcom/intellij/openapi/util/Key;", "findExpressionByCopyableDataAndClearIt", "findExpressionsByCopyableDataAndClearIt", "getPhysicalTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "mustBeParenthesizedInInitializerPosition", "replaceWith", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/ExtractableSubstringInfo;", "replacement", "idea"})
public final class IntroduceUtilKt {
    public static final void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message2, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        CodeInsightUtils.showErrorHint(project, editor, message2, title, null);
    }

    public static final void showErrorHintByKey(@NotNull Project project, @NotNull Editor editor, @NotNull String messageKey, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)messageKey, (String)"messageKey");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        String string = KotlinRefactoringBundle.message(messageKey, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinRefactoringBundle.message(messageKey)");
        IntroduceUtilKt.showErrorHint(project, editor, string, title);
    }

    public static final void selectElementsWithTargetSibling(@NotNull String operationName, @NotNull Editor editor, @NotNull KtFile file2, @NotNull String title, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function2<? super List<? extends PsiElement>, ? super PsiElement, ? extends List<? extends PsiElement>> getContainers, @NotNull Function2<? super List<? extends PsiElement>, ? super PsiElement, Unit> continuation) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(getContainers, (String)"getContainers");
        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
        Function2<List<? extends PsiElement>, PsiElement, Unit> onSelectionComplete$ = new Function2<List<? extends PsiElement>, PsiElement, Unit>(continuation, file2, editor, operationName){
            final /* synthetic */ Function2 $continuation;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $operationName;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<? extends PsiElement> elements2, @NotNull PsiElement targetContainer) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
                Intrinsics.checkParameterIsNotNull((Object)targetContainer, (String)"targetContainer");
                Iterable iterable = $receiver$iv = (Iterable)elements2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PsiElement psiElement2 = (PsiElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    PsiElement psiElement3 = ExtractableSubstringInfoKt.getSubstringContextOrThis((PsiElement)it);
                    collection.add(psiElement3);
                }
                List physicalElements = (List)destination$iv$iv;
                PsiElement psiElement4 = PsiTreeUtil.findCommonParent((List)physicalElements);
                if (psiElement4 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Should have at least one parent: " + CollectionsKt.joinToString$default((Iterable)physicalElements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))));
                }
                PsiElement parent2 = psiElement4;
                if (Intrinsics.areEqual((Object)parent2, (Object)targetContainer)) {
                    this.$continuation.invoke(elements2, CollectionsKt.first((List)physicalElements));
                    return;
                }
                PsiElement psiElement5 = parent2;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent");
                PsiElement outermostParent = PsiUtilsKt.getOutermostParentContainedIn(psiElement5, targetContainer);
                if (outermostParent == null) {
                    Project project = this.$file.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                    IntroduceUtilKt.showErrorHintByKey(project, this.$editor, "cannot.refactor.no.container", this.$operationName);
                    return;
                }
                this.$continuation.invoke(elements2, (Object)outermostParent);
            }
            {
                this.$continuation = function2;
                this.$file = ktFile;
                this.$editor = editor;
                this.$operationName = string;
                super(2);
            }
        };
        IntroduceUtilKt.selectElementsWithTargetParent(operationName, editor, file2, title, elementKinds, getContainers, (Function2<? super List<? extends PsiElement>, ? super PsiElement, Unit>)((Function2)new Function2<List<? extends PsiElement>, PsiElement, Unit>(onSelectionComplete$){
            final /* synthetic */ selectElementsWithTargetSibling.1 $onSelectionComplete$1;

            public final void invoke(@NotNull List<? extends PsiElement> p1, @NotNull PsiElement p2) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                this.$onSelectionComplete$1.invoke(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "onSelectionComplete";
            }

            public final String getSignature() {
                return "invoke(Ljava/util/List;Lcom/intellij/psi/PsiElement;)V";
            }
            {
                this.$onSelectionComplete$1 = var1_1;
                super(2);
            }
        }));
    }

    public static final void selectElementsWithTargetParent(@NotNull String operationName, @NotNull Editor editor, @NotNull KtFile file2, @NotNull String title, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function2<? super List<? extends PsiElement>, ? super PsiElement, ? extends List<? extends PsiElement>> getContainers, @NotNull Function2<? super List<? extends PsiElement>, ? super PsiElement, Unit> continuation) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(getContainers, (String)"getContainers");
        Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
        Function1<String, Unit> showErrorHintByKey$ = new Function1<String, Unit>(file2, editor, operationName){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $operationName;

            public final void invoke(@NotNull String key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Project project = this.$file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                IntroduceUtilKt.showErrorHintByKey(project, this.$editor, key, this.$operationName);
            }
            {
                this.$file = ktFile;
                this.$editor = editor;
                this.$operationName = string;
                super(1);
            }
        };
        Function1<List<? extends PsiElement>, Unit> selectTargetContainer$ = new Function1<List<? extends PsiElement>, Unit>(getContainers, showErrorHintByKey$, editor, title, continuation){
            final /* synthetic */ Function2 $getContainers;
            final /* synthetic */ selectElementsWithTargetParent.1 $showErrorHintByKey$1;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $title;
            final /* synthetic */ Function2 $continuation;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<? extends PsiElement> elements2) {
                PsiElement parent2;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
                Iterable iterable = $receiver$iv = (Iterable)elements2;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PsiElement psiElement2 = (PsiElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    PsiElement psiElement3 = ExtractableSubstringInfoKt.getSubstringContextOrThis((PsiElement)it);
                    collection.add(psiElement3);
                }
                List physicalElements = (List)destination$iv$iv;
                PsiElement psiElement4 = PsiTreeUtil.findCommonParent((List)physicalElements);
                if (psiElement4 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Should have at least one parent: " + CollectionsKt.joinToString$default((Iterable)physicalElements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))));
                }
                PsiElement psiElement5 = parent2 = psiElement4;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent");
                List containers = (List)this.$getContainers.invoke((Object)physicalElements, (Object)psiElement5);
                if (containers.isEmpty()) {
                    this.$showErrorHintByKey$1.invoke("cannot.refactor.no.container");
                    return;
                }
                KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, this.$editor, this.$title, true, selectElementsWithTargetParent.1.INSTANCE, (Function1)new Function1<PsiElement, Unit>(this, elements2){
                    final /* synthetic */ selectElementsWithTargetParent.2 this$0;
                    final /* synthetic */ List $elements;

                    public final void invoke(@NotNull PsiElement it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.this$0.$continuation.invoke((Object)this.$elements, (Object)it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$elements = list2;
                        super(1);
                    }
                });
            }
            {
                this.$getContainers = function2;
                this.$showErrorHintByKey$1 = var2_2;
                this.$editor = editor;
                this.$title = string;
                this.$continuation = function22;
                super(1);
            }
        };
        Function0<Unit> selectMultipleElements$ = new Function0<Unit>(editor, elementKinds, file2, showErrorHintByKey$, title, selectTargetContainer$){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Collection $elementKinds;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ selectElementsWithTargetParent.1 $showErrorHintByKey$1;
            final /* synthetic */ String $title;
            final /* synthetic */ selectElementsWithTargetParent.2 $selectTargetContainer$2;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final void invoke() {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                SelectionModel selectionModel = this.$editor.getSelectionModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel, (String)"editor.selectionModel");
                int startOffset = selectionModel.getSelectionStart();
                SelectionModel selectionModel2 = this.$editor.getSelectionModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)selectionModel2, (String)"editor.selectionModel");
                int endOffset = selectionModel2.getSelectionEnd();
                Iterable iterable = $receiver$iv = (Iterable)this.$elementKinds;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    CodeInsightUtils.ElementKind it = (CodeInsightUtils.ElementKind)((Object)element$iv$iv);
                    Object[] objectArray = CodeInsightUtils.findElements((PsiFile)this.$file, startOffset, endOffset, it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"CodeInsightUtils.findEle\u2026artOffset, endOffset, it)");
                    Iterable list$iv$iv = ArraysKt.toList((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List elements2 = (List)destination$iv$iv;
                if (!elements2.isEmpty()) {
                    this.$selectTargetContainer$2.invoke(elements2);
                    return;
                }
                CodeInsightUtils.ElementKind elementKind = (CodeInsightUtils.ElementKind)((Object)CollectionsKt.singleOrNull((Iterable)this.$elementKinds));
                if (elementKind != null) {
                    switch (IntroduceUtilKt$WhenMappings.$EnumSwitchMapping$0[elementKind.ordinal()]) {
                        case 1: {
                            this.$showErrorHintByKey$1.invoke("cannot.refactor.no.expression");
                            return;
                        }
                        case 2: {
                            this.$showErrorHintByKey$1.invoke("cannot.refactor.no.type");
                            return;
                        }
                    }
                }
                Project project = this.$file.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                IntroduceUtilKt.showErrorHint(project, this.$editor, "Refactoring can't be performed on the selected code element", this.$title);
            }
            {
                this.$editor = editor;
                this.$elementKinds = collection;
                this.$file = ktFile;
                this.$showErrorHintByKey$1 = var4_4;
                this.$title = string;
                this.$selectTargetContainer$2 = var6_6;
                super(0);
            }
        };
        Function0<Unit> selectSingleElement$ = new Function0<Unit>(editor, file2, elementKinds, selectTargetContainer$, selectMultipleElements$){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Collection $elementKinds;
            final /* synthetic */ selectElementsWithTargetParent.2 $selectTargetContainer$2;
            final /* synthetic */ selectElementsWithTargetParent.3 $selectMultipleElements$3;

            public final void invoke() {
                ElementSelectionUtilsKt.selectElement(this.$editor, this.$file, false, this.$elementKinds, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>(this){
                    final /* synthetic */ selectElementsWithTargetParent.4 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@Nullable PsiElement expr2) {
                        if (expr2 != null) {
                            this.this$0.$selectTargetContainer$2.invoke(CollectionsKt.listOf((Object)expr2));
                        } else {
                            if (!this.this$0.$editor.getSelectionModel().hasSelection()) {
                                if ((CodeInsightUtils.ElementKind)((Object)CollectionsKt.singleOrNull((Iterable)this.this$0.$elementKinds)) == CodeInsightUtils.ElementKind.EXPRESSION) {
                                    KtFile ktFile = this.this$0.$file;
                                    CaretModel caretModel = this.this$0.$editor.getCaretModel();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                                    PsiElement elementAtCaret = ktFile.findElementAt(caretModel.getOffset());
                                    PsiElement psiElement2 = elementAtCaret;
                                    if (psiElement2 != null) {
                                        void $receiver$iv;
                                        PsiElement psiElement3 = psiElement2;
                                        Function1 branch$iv = selectElementsWithTargetParent.1.INSTANCE;
                                        boolean strict$iv = false;
                                        void $receiver$iv$iv = $receiver$iv;
                                        PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtProperty.class, (boolean)strict$iv);
                                        psiElement2 = (KtProperty)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, (PsiElement)$receiver$iv, branch$iv) : null);
                                        if (psiElement2 != null) {
                                            PsiElement it = psiElement3 = psiElement2;
                                            this.this$0.$selectTargetContainer$2.invoke(CollectionsKt.listOf((Object)it));
                                            return;
                                        }
                                    }
                                }
                                this.this$0.$editor.getSelectionModel().selectLineAtCaret();
                            }
                            this.this$0.$selectMultipleElements$3.invoke();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$editor = editor;
                this.$file = ktFile;
                this.$elementKinds = collection;
                this.$selectTargetContainer$2 = var4_4;
                this.$selectMultipleElements$3 = var5_5;
                super(0);
            }
        };
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        selectSingleElement$.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression findExpressionByCopyableDataAndClearIt(@NotNull PsiElement $receiver, @NotNull Key<Boolean> key) {
        void result$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PsiElement psiElement2 = $receiver;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(key){
            final /* synthetic */ Key $key;

            public final boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getCopyableUserData(this.$key) != null;
            }
            {
                this.$key = key;
                super(1);
            }
        };
        void $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3 instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                super.visitElement(element3);
            }
        });
        PsiElement psiElement3 = (PsiElement)result$iv$iv.element;
        if (psiElement3 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression result2 = (KtExpression)psiElement3;
        result2.putCopyableUserData(key, null);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiElement findElementByCopyableDataAndClearIt(@NotNull PsiElement $receiver, @NotNull Key<Boolean> key) {
        void result$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PsiElement psiElement2 = $receiver;
        Function1 predicate$iv = (Function1)new Function1<PsiElement, Boolean>(key){
            final /* synthetic */ Key $key;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getCopyableUserData(this.$key) != null;
            }
            {
                this.$key = key;
                super(1);
            }
        };
        void $receiver$iv$iv = $receiver$iv;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                super.visitElement(element3);
            }
        });
        PsiElement psiElement3 = (PsiElement)result$iv$iv.element;
        if (psiElement3 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement result2 = psiElement3;
        result2.putCopyableUserData(key, null);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtExpression> findExpressionsByCopyableDataAndClearIt(@NotNull PsiElement $receiver, @NotNull Key<Boolean> key) {
        void $receiver$iv$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PsiElement psiElement2 = $receiver;
        Function1 predicate$iv = (Function1)new Function1<KtExpression, Boolean>(key){
            final /* synthetic */ Key $key;

            public final boolean invoke(@NotNull KtExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getCopyableUserData(this.$key) != null;
            }
            {
                this.$key = key;
                super(1);
            }
        };
        void $receiver$iv$iv = $receiver$iv;
        ArrayList result$iv$iv = new ArrayList();
        void var7_6 = $receiver$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtExpression, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement it = element3;
                super.visitElement(element3);
                if (element3 instanceof KtExpression) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        List results2 = result$iv$iv;
        $receiver$iv = results2;
        for (Object element$iv : $receiver$iv) {
            KtExpression it = (KtExpression)element$iv;
            it.putCopyableUserData(key, null);
        }
        return results2;
    }

    @Nullable
    public static final KtExpression findExpressionOrStringFragment(@NotNull KtFile file2, int startOffset, int endOffset) {
        String string;
        PsiElement $receiver$iv;
        PsiElement $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object object = file2.findElementAt(startOffset);
        if (object == null || (object = (KtStringTemplateEntry)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv2 = object), KtStringTemplateEntry.class, (boolean)false)) == null) {
            return null;
        }
        Object entry1 = object;
        Object object2 = file2.findElementAt(endOffset - 1);
        if (object2 == null || (object2 = (KtStringTemplateEntry)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = object2), KtStringTemplateEntry.class, (boolean)false)) == null) {
            return null;
        }
        Object entry2 = object2;
        if (Intrinsics.areEqual((Object)entry1, (Object)entry2) && entry1 instanceof KtStringTemplateEntryWithExpression) {
            return ((KtStringTemplateEntryWithExpression)entry1).getExpression();
        }
        PsiElement psiElement2 = ((KtElementImpl)entry1).getParent();
        if (!(psiElement2 instanceof KtStringTemplateExpression)) {
            psiElement2 = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)psiElement2;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        if (Intrinsics.areEqual((Object)((KtElementImpl)entry2).getParent(), (Object)stringTemplate) ^ true) {
            return null;
        }
        int templateOffset = PsiUtilsKt.getStartOffset((PsiElement)stringTemplate);
        if (KtPsiUtilKt.getContentRange(stringTemplate).equalsToRange(startOffset - templateOffset, endOffset - templateOffset)) {
            return stringTemplate;
        }
        int prefixOffset = startOffset - PsiUtilsKt.getStartOffset((PsiElement)entry1);
        if (!(entry1 instanceof KtLiteralStringTemplateEntry) && prefixOffset > 0) {
            return null;
        }
        int suffixOffset = endOffset - PsiUtilsKt.getStartOffset((PsiElement)entry2);
        if (!(entry2 instanceof KtLiteralStringTemplateEntry) && suffixOffset < entry2.getTextLength()) {
            return null;
        }
        String string2 = entry1.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry1.text");
        String string3 = string2;
        int n = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, prefixOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String prefix = string5;
        String string6 = entry2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"entry2.text");
        String string7 = string = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(suffixOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        String suffix = string8;
        return new ExtractableSubstringInfo((KtStringTemplateEntry)entry1, (KtStringTemplateEntry)entry2, prefix, suffix, null, 16, null).createExpression();
    }

    @NotNull
    public static final TextRange getPhysicalTextRange(@NotNull KotlinPsiRange $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object2 = CollectionsKt.singleOrNull($receiver.getElements());
        if (!(object2 instanceof KtExpression)) {
            object2 = null;
        }
        if ((object = (KtExpression)object2) == null || (object = ExtractableSubstringInfoKt.getExtractableSubstringInfo((KtExpression)object)) == null || (object = ((ExtractableSubstringInfo)object).getContentRange()) == null) {
            object = $receiver.getTextRange();
        }
        return object;
    }

    @NotNull
    public static final KtExpression replaceWith(@NotNull ExtractableSubstringInfo $receiver, @NotNull KtExpression replacement2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)replacement2, (String)"replacement");
        ExtractableSubstringInfo $receiver2 = $receiver;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)replacement2, false, 2, null);
        PsiElement parent2 = $receiver2.getStartEntry().getParent();
        Object[] objectArray = psiFactory.createStringTemplate($receiver2.getPrefix()).getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"psiFactory.createStringTemplate(prefix).entries");
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])objectArray);
        if (ktStringTemplateEntry != null) {
            KtStringTemplateEntry ktStringTemplateEntry2;
            KtStringTemplateEntry it = ktStringTemplateEntry2 = ktStringTemplateEntry;
            parent2.addBefore((PsiElement)it, (PsiElement)$receiver2.getStartEntry());
        }
        KtStringTemplateEntryWithExpression refEntry = psiFactory.createBlockStringTemplateEntry(replacement2);
        PsiElement psiElement2 = parent2.addBefore((PsiElement)refEntry, (PsiElement)$receiver2.getStartEntry());
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression");
        }
        KtStringTemplateEntryWithExpression addedRefEntry = (KtStringTemplateEntryWithExpression)psiElement2;
        Object[] objectArray2 = psiFactory.createStringTemplate($receiver2.getSuffix()).getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"psiFactory.createStringTemplate(suffix).entries");
        KtStringTemplateEntry ktStringTemplateEntry3 = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])objectArray2);
        if (ktStringTemplateEntry3 != null) {
            KtStringTemplateEntry ktStringTemplateEntry4;
            KtStringTemplateEntry it = ktStringTemplateEntry4 = ktStringTemplateEntry3;
            parent2.addAfter((PsiElement)it, (PsiElement)$receiver2.getEndEntry());
        }
        parent2.deleteChildRange((PsiElement)$receiver2.getStartEntry(), (PsiElement)$receiver2.getEndEntry());
        KtExpression ktExpression = addedRefEntry.getExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"with(this) {\n        val\u2026fEntry.expression!!\n    }");
        return ktExpression;
    }

    public static final boolean mustBeParenthesizedInInitializerPosition(@NotNull KtExpression $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (!($receiver instanceof KtBinaryExpression)) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)$receiver).getLeft();
            if (ktExpression != null ? IntroduceUtilKt.mustBeParenthesizedInInitializerPosition(ktExpression) : false) {
                return true;
            }
            Sequence $receiver$iv = new PsiChildRange((PsiElement)((KtBinaryExpression)$receiver).getLeft(), (PsiElement)((KtBinaryExpression)$receiver).getOperationReference());
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isObjectOrNonInnerClass(@NotNull PsiElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return e instanceof KtObjectDeclaration || e instanceof KtClass && !((KtClass)e).isInner();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends KtDeclaration> T insertDeclaration(@NotNull T declaration2, @NotNull PsiElement targetSibling) {
        Object element$iv;
        Object object;
        block10: {
            Object v0;
            Sequence<PsiElement> $receiver$iv;
            Iterator iterator$iv;
            Intrinsics.checkParameterIsNotNull(declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)targetSibling, (String)"targetSibling");
            PsiElement targetParent = targetSibling.getParent();
            SmartList<PsiElement> anchorCandidates = new SmartList<PsiElement>();
            anchorCandidates.add(targetSibling);
            if (targetSibling instanceof KtEnumEntry) {
                void $receiver$iv2;
                Sequence sequence2 = PsiUtilsKt.siblings$default(targetSibling, false, false, 3, null);
                SmartList<PsiElement> smartList = anchorCandidates;
                Object last$iv = null;
                boolean found$iv = false;
                for (Object element$iv2 : $receiver$iv2) {
                    PsiElement it = (PsiElement)element$iv2;
                    if (!(it instanceof KtEnumEntry)) continue;
                    last$iv = element$iv2;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                Object e = last$iv;
                smartList.add((PsiElement)e);
            }
            if (!(iterator$iv = ($receiver$iv = (Sequence<PsiElement>)anchorCandidates).iterator()).hasNext()) {
                v0 = null;
            } else {
                PsiElement it;
                Object minElem$iv = iterator$iv.next();
                PsiElement psiElement2 = it = (PsiElement)minElem$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
                int minValue$iv = PsiUtilsKt.getStartOffset(psiElement2);
                while (iterator$iv.hasNext()) {
                    PsiElement it2;
                    Object e$iv = iterator$iv.next();
                    PsiElement psiElement3 = it2 = (PsiElement)e$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it");
                    int v$iv = PsiUtilsKt.getStartOffset(psiElement3);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                }
                v0 = minElem$iv;
            }
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = PsiUtilsKt.getParentsWithSelf(v0);
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                PsiElement it = (PsiElement)element$iv;
                if (!Intrinsics.areEqual((Object)it.getParent(), (Object)targetParent)) continue;
                break block10;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        PsiElement anchor2 = (PsiElement)element$iv;
        PsiElement psiElement4 = anchor2.getParent();
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement targetContainer = psiElement4;
        PsiElement psiElement5 = targetContainer.addBefore((PsiElement)declaration2, anchor2);
        if (psiElement5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        Object $receiver = object = (KtDeclaration)psiElement5;
        targetContainer.addBefore(KtPsiFactoryKt.KtPsiFactory$default(declaration2, false, 2, null).createWhiteSpace("\n\n"), anchor2);
        return (T)object;
    }
}

