/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.idea.core.TemplatesKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u001a,\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"generateClassOrObjectByExpectedClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "project", "Lcom/intellij/openapi/project/Project;", "expectedClass", "actualNeeded", "", "existingDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "generateFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "expectedFunction", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "expectedProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "replaceExpectModifier", "", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "idea"})
public final class CreateActualFixKt {
    private static final void replaceExpectModifier(@NotNull KtModifierListOwner $receiver, boolean actualNeeded) {
        if (actualNeeded) {
            $receiver.addModifier(KtTokens.ACTUAL_KEYWORD);
        } else {
            $receiver.removeModifier(KtTokens.HEADER_KEYWORD);
            $receiver.removeModifier(KtTokens.EXPECT_KEYWORD);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtClassOrObject generateClassOrObjectByExpectedClass(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtClassOrObject expectedClass, boolean actualNeeded, @NotNull List<? extends KtDeclaration> existingDeclarations) {
        void $receiver$iv$iv;
        Object expectedEntry;
        Object $actualEntry_expectedEntry;
        KtClassOrObject ktClassOrObject;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)expectedClass, (String)"expectedClass");
        Intrinsics.checkParameterIsNotNull(existingDeclarations, (String)"existingDeclarations");
        Function1<KtDeclaration, Boolean> exists$ = new Function1<KtDeclaration, Boolean>(existingDeclarations){
            final /* synthetic */ List $existingDeclarations;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull KtDeclaration $receiver) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver$iv = this.$existingDeclarations;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator2 = $receiver$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    T element$iv = iterator2.next();
                    KtDeclaration it = (KtDeclaration)element$iv;
                    if (Intrinsics.areEqual((Object)$receiver.getName(), (Object)it.getName()) && Intrinsics.areEqual($receiver.getClass(), it.getClass())) {
                        KtDeclaration ktDeclaration = $receiver;
                        if (ktDeclaration instanceof KtClassOrObject || ktDeclaration instanceof KtProperty || ktDeclaration instanceof KtEnumEntry) {
                            return true;
                        }
                        if (!(ktDeclaration instanceof KtFunction)) return true;
                        KtDeclaration ktDeclaration2 = it;
                        if (ktDeclaration2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
                        }
                        KtFunction cfr_ignored_0 = (KtFunction)ktDeclaration2;
                        if (((KtFunction)$receiver).getValueParameters().size() == ((KtFunction)it).getValueParameters().size()) {
                            boolean bl2;
                            List<KtParameter> list2 = ((KtFunction)$receiver).getValueParameters();
                            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueParameters");
                            Iterable iterable = list2;
                            List<KtParameter> list3 = ((KtFunction)it).getValueParameters();
                            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"it.valueParameters");
                            Iterable $receiver$iv2 = CollectionsKt.zip((Iterable)iterable, (Iterable)list3);
                            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                                return true;
                            }
                            Iterator<T> iterator3 = $receiver$iv2.iterator();
                            do {
                                if (!iterator3.hasNext()) return true;
                                T element$iv2 = iterator3.next();
                                Pair $parameter_existingParameter = (Pair)element$iv2;
                                KtParameter parameter = (KtParameter)$parameter_existingParameter.component1();
                                KtParameter existingParameter = (KtParameter)$parameter_existingParameter.component2();
                                KtParameter ktParameter = parameter;
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                                String string = ktParameter.getName();
                                KtParameter ktParameter2 = existingParameter;
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"existingParameter");
                                if (Intrinsics.areEqual((Object)string, (Object)ktParameter2.getName())) {
                                    KtTypeReference ktTypeReference = parameter.getTypeReference();
                                    KtTypeReference ktTypeReference2 = existingParameter.getTypeReference();
                                    if (Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)(ktTypeReference2 != null ? ktTypeReference2.getText() : null))) {
                                        bl2 = true;
                                        continue;
                                    }
                                }
                                bl2 = false;
                            } while (bl2);
                            boolean bl3 = false;
                            if (bl3) {
                                return true;
                            }
                        }
                        boolean bl4 = false;
                        if (bl4) {
                            return true;
                        }
                    }
                    bl = false;
                } while (!bl);
                return true;
            }
            {
                this.$existingDeclarations = list2;
                super(1);
            }
        };
        String expectedText = expectedClass.getText();
        if (expectedClass instanceof KtObjectDeclaration) {
            KtObjectDeclaration ktObjectDeclaration;
            if (((KtObjectDeclaration)expectedClass).isCompanion()) {
                String string = expectedText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedText");
                ktObjectDeclaration = $receiver.createCompanionObject(string);
            } else {
                String string = expectedText;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedText");
                ktObjectDeclaration = $receiver.createObject(string);
            }
            ktClassOrObject = ktObjectDeclaration;
        } else {
            String string = expectedText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expectedText");
            ktClassOrObject = $receiver.createClass(string);
        }
        KtClassOrObject actualClass = ktClassOrObject;
        boolean isInterface = expectedClass instanceof KtClass && ((KtClass)expectedClass).isInterface();
        Iterable $receiver$iv = actualClass.getDeclarations();
        Object object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            KtDeclaration it = (KtDeclaration)element$iv;
            if (exists$.invoke(it)) {
                it.delete();
                continue;
            }
            KtDeclaration ktDeclaration = it;
            if (ktDeclaration instanceof KtEnumEntry) continue;
            if (ktDeclaration instanceof KtClassOrObject) {
                it.delete();
                continue;
            }
            if (!(ktDeclaration instanceof KtCallableDeclaration)) continue;
            if (!isInterface && !it.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                it.delete();
                continue;
            }
            it.addModifier(KtTokens.ACTUAL_KEYWORD);
        }
        BindingContext context = ResolutionUtils.analyze$default(expectedClass, null, 1, null);
        Iterable $receiver$iv2 = CollectionsKt.zip((Iterable)actualClass.getSuperTypeListEntries(), (Iterable)expectedClass.getSuperTypeListEntries());
        for (Object element$iv : $receiver$iv2) {
            ClassDescriptor superClassDescriptor;
            ClassifierDescriptor classifierDescriptor;
            $actualEntry_expectedEntry = (Pair)element$iv;
            KtSuperTypeListEntry actualEntry = (KtSuperTypeListEntry)$actualEntry_expectedEntry.component1();
            expectedEntry = (KtSuperTypeListEntry)$actualEntry_expectedEntry.component2();
            if (!(actualEntry instanceof KtSuperTypeEntry)) continue;
            KotlinType superType = (KotlinType)context.get(BindingContext.TYPE, ((KtSuperTypeListEntry)expectedEntry).getTypeReference());
            Object object2 = superType;
            if (!((object2 != null && (object2 = ((KotlinType)object2).getConstructor()) != null ? object2.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            if (superClassDescriptor.getKind() != ClassKind.CLASS && superClassDescriptor.getKind() != ClassKind.ENUM_CLASS) continue;
            StringBuilder stringBuilder = new StringBuilder();
            KtTypeReference ktTypeReference = ((KtSuperTypeEntry)actualEntry).getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"actualEntry.typeReference!!");
            actualEntry.replace((PsiElement)$receiver.createSuperTypeCallEntry(stringBuilder.append(ktTypeReference.getText()).append("()").toString()));
        }
        Iterable $receiver$iv3 = expectedClass.getDeclarations();
        $actualEntry_expectedEntry = $receiver$iv3;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtDeclaration it = (KtDeclaration)element$iv$iv;
            if (!(!exists$.invoke(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (KtDeclaration expectedDeclaration : (List)destination$iv$iv) {
            KtDeclaration ktDeclaration;
            if (PsiModificationUtilsKt.toDescriptor(expectedDeclaration) == null) {
                continue;
            }
            destination$iv$iv = expectedDeclaration;
            if (destination$iv$iv instanceof KtClassOrObject) {
                if (expectedDeclaration instanceof KtEnumEntry) continue;
                ktDeclaration = CreateActualFixKt.generateClassOrObjectByExpectedClass$default($receiver, project, (KtClassOrObject)expectedDeclaration, true, null, 8, null);
            } else {
                KtCallableDeclaration ktCallableDeclaration;
                Object descriptor2;
                if (!(destination$iv$iv instanceof KtCallableDeclaration) || isInterface || expectedDeclaration.hasModifier(KtTokens.ABSTRACT_KEYWORD)) continue;
                expectedEntry = expectedDeclaration;
                if (expectedEntry instanceof KtFunction) {
                    Object object3 = descriptor2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    ktCallableDeclaration = CreateActualFixKt.generateFunction($receiver, project, (KtFunction)expectedDeclaration, (FunctionDescriptor)object3, true);
                } else {
                    if (!(expectedEntry instanceof KtProperty)) continue;
                    Object object4 = descriptor2;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                    }
                    ktCallableDeclaration = CreateActualFixKt.generateProperty($receiver, project, (KtProperty)expectedDeclaration, (PropertyDescriptor)object4, true);
                }
                ktDeclaration = ktCallableDeclaration;
            }
            KtDeclaration actualDeclaration = ktDeclaration;
            KtClassOrObject this_$iv = actualClass;
            KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody(this_$iv);
            PsiElement psiElement2 = body$iv.getRBrace();
            if (psiElement2 == null && (psiElement2 = body$iv.getLastChild()) == null) {
                Intrinsics.throwNpe();
            }
            PsiElement anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])new Class[]{PsiWhiteSpace.class});
            PsiElement psiElement3 = body$iv.addAfter(actualDeclaration, anchor$iv);
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
            }
            KtDeclaration cfr_ignored_0 = (KtDeclaration)psiElement3;
        }
        KtPrimaryConstructor ktPrimaryConstructor = actualClass.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            Object it = object = ktPrimaryConstructor;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ACTUAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.ACTUAL_KEYWORD");
            ((KtPrimaryConstructor)it).addModifier(ktModifierKeywordToken);
            for (KtParameter parameter : ((KtConstructor)it).getValueParameters()) {
                if (!parameter.hasValOrVar()) continue;
                parameter.addModifier(KtTokens.ACTUAL_KEYWORD);
            }
        }
        Object $receiver2 = object = actualClass;
        CreateActualFixKt.replaceExpectModifier((KtModifierListOwner)$receiver2, actualNeeded);
        return object;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtClassOrObject generateClassOrObjectByExpectedClass$default(KtPsiFactory ktPsiFactory, Project project, KtClassOrObject ktClassOrObject, boolean bl, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return CreateActualFixKt.generateClassOrObjectByExpectedClass(ktPsiFactory, project, ktClassOrObject, bl, list2);
    }

    private static final KtFunction generateFunction(@NotNull KtPsiFactory $receiver, Project project, KtFunction expectedFunction, FunctionDescriptor descriptor2, boolean actualNeeded) {
        String string;
        Object object;
        KotlinType returnType2 = descriptor2.getReturnType();
        Object $receiver2 = object = $receiver;
        if (returnType2 != null && !KotlinBuiltIns.isUnit(returnType2)) {
            String delegation = TemplatesKt.getFunctionBodyTextFromTemplate$default(project, TemplateKind.FUNCTION, descriptor2.getName().asString(), IdeDescriptorRenderers.SOURCE_CODE.renderType(returnType2), null, 16, null);
            string = '{' + delegation + "\n}";
        } else {
            string = "{}";
        }
        String body2 = string;
        KtDeclaration ktDeclaration = expectedFunction instanceof KtSecondaryConstructor ? (KtDeclaration)$receiver.createSecondaryConstructor(((KtSecondaryConstructor)expectedFunction).getText() + " " + body2) : (KtDeclaration)$receiver.createFunction(expectedFunction.getText() + " " + body2);
        if (ktDeclaration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        $receiver2 = object = (KtFunction)ktDeclaration;
        CreateActualFixKt.replaceExpectModifier((KtModifierListOwner)$receiver2, actualNeeded);
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2)) {
            $receiver2.setTypeReference((KtTypeReference)null);
        }
        return object;
    }

    private static final KtProperty generateProperty(@NotNull KtPsiFactory $receiver, Project project, KtProperty expectedProperty, PropertyDescriptor descriptor2, boolean actualNeeded) {
        Object object;
        String string;
        TemplateKind templateKind;
        Project project2;
        StringBuilder stringBuilder;
        Object $receiver2;
        Object object2;
        block5: {
            block4: {
                KotlinType it;
                $receiver2 = object2 = new StringBuilder();
                ((StringBuilder)$receiver2).append("\nget()");
                ((StringBuilder)$receiver2).append(" = ");
                stringBuilder = $receiver2;
                project2 = project;
                templateKind = TemplateKind.FUNCTION;
                string = descriptor2.getName().asString();
                object = descriptor2.getReturnType();
                if (object == null) break block4;
                KotlinType kotlinType = object;
                String string2 = string;
                TemplateKind templateKind2 = templateKind;
                Project project3 = project2;
                StringBuilder stringBuilder2 = stringBuilder;
                KotlinType kotlinType2 = it = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it");
                String string3 = IdeDescriptorRenderers.SOURCE_CODE.renderType(kotlinType2);
                stringBuilder = stringBuilder2;
                project2 = project3;
                templateKind = templateKind2;
                string = string2;
                object = string3;
                if (object != null) break block5;
            }
            object = "";
        }
        stringBuilder.append(TemplatesKt.getFunctionBodyTextFromTemplate$default(project2, templateKind, string, (String)object, null, 16, null));
        if (descriptor2.isVar()) {
            ((StringBuilder)$receiver2).append("\nset(value) {}");
        }
        String string4 = ((StringBuilder)object2).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String body2 = string4;
        $receiver2 = object2 = $receiver.createProperty(expectedProperty.getText() + " " + body2);
        CreateActualFixKt.replaceExpectModifier((KtModifierListOwner)$receiver2, actualNeeded);
        return object2;
    }

    @NotNull
    public static final /* synthetic */ KtProperty access$generateProperty(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtProperty expectedProperty, @NotNull PropertyDescriptor descriptor2, boolean actualNeeded) {
        return CreateActualFixKt.generateProperty($receiver, project, expectedProperty, descriptor2, actualNeeded);
    }

    @NotNull
    public static final /* synthetic */ KtFunction access$generateFunction(@NotNull KtPsiFactory $receiver, @NotNull Project project, @NotNull KtFunction expectedFunction, @NotNull FunctionDescriptor descriptor2, boolean actualNeeded) {
        return CreateActualFixKt.generateFunction($receiver, project, expectedFunction, descriptor2, actualNeeded);
    }
}

