/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFixKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "constValue", "", "expectedTypeIsDouble", "", "expectedTypeIsFloat", "fixedExpression", "", "typeName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "idea"})
public final class WrongPrimitiveLiteralFix
extends KotlinQuickFixAction<KtExpression> {
    private final FqNameUnsafe typeName;
    private final boolean expectedTypeIsFloat;
    private final boolean expectedTypeIsDouble;
    private final Number constValue;
    private final String fixedExpression;

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (this.constValue == null) {
            return false;
        }
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            return true;
        }
        if (this.constValue instanceof Float || this.constValue instanceof Double) {
            double value2 = this.constValue.doubleValue();
            if (value2 != Math.floor(value2)) {
                return false;
            }
            double d = Long.MIN_VALUE;
            double d2 = Long.MAX_VALUE;
            double d3 = value2;
            if (!(d3 >= d) || !(d3 <= d2)) {
                return false;
            }
        }
        LongRange longRange = (LongRange)WrongPrimitiveLiteralFixKt.access$getValueRanges$p().get(this.typeName);
        if (longRange == null) {
            return false;
        }
        return longRange.contains(this.constValue.longValue());
    }

    @NotNull
    public String getFamilyName() {
        return "Change to correct primitive type";
    }

    @NotNull
    public String getText() {
        return "Change to '" + this.fixedExpression + '\'';
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block5: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtExpression expressionToInsert = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file2, false, 2, null).createExpression(this.fixedExpression);
            PsiElement $receiver$iv = (PsiElement)element3;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)expressionToInsert);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            KtExpression newExpression2 = (KtExpression)object;
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block5;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)newExpression2));
        }
    }

    public WrongPrimitiveLiteralFix(@NotNull KtConstantExpression element3, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element3);
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        this.typeName = DescriptorUtils.getFqName(classifierDescriptor);
        this.expectedTypeIsFloat = KotlinBuiltIns.isFloat(type2);
        this.expectedTypeIsDouble = KotlinBuiltIns.isDouble(type2);
        Object object = this;
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = this;
        Object $receiver = object;
        boolean shouldInlineCosntVals = PlatformKt.getLanguageVersionSettings(element3).supportsFeature(LanguageFeature.InlineConstVals);
        ConstantValue<?> constantValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(element3, ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL), shouldInlineCosntVals);
        Object object2 = constantValue != null ? constantValue.getValue() : null;
        if (!(object2 instanceof Number)) {
            object2 = null;
        }
        Object object3 = (Number)object2;
        wrongPrimitiveLiteralFix.constValue = object3;
        wrongPrimitiveLiteralFix = this;
        $receiver = object = new StringBuilder();
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            ((StringBuilder)$receiver).append(this.constValue);
            if (this.expectedTypeIsFloat) {
                ((StringBuilder)$receiver).append('F');
            } else if (!StringsKt.contains$default((CharSequence)((CharSequence)$receiver), (char)'.', (boolean)false, (int)2, null)) {
                ((StringBuilder)$receiver).append(".0");
            }
        } else {
            if (this.constValue instanceof Float || this.constValue instanceof Double) {
                ((StringBuilder)$receiver).append(this.constValue.longValue());
            } else {
                String string = element3.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
                ((StringBuilder)$receiver).append(StringsKt.trimEnd((String)string, (char[])new char[]{'l', 'L'}));
            }
            if (KotlinBuiltIns.isLong(type2)) {
                ((StringBuilder)$receiver).append('L');
            }
        }
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        wrongPrimitiveLiteralFix.fixedExpression = object3 = string;
    }
}

