/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SmartCastImpossibleExclExclFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
public final class SmartCastImpossibleExclExclFixFactory
extends KotlinSingleIntentionActionFactory {
    public static final SmartCastImpossibleExclExclFixFactory INSTANCE;

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        KotlinType nullableExpectedType;
        DiagnosticWithParameters3 diagnosticWithParameters;
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        if (diagnostic.getFactory() != Errors.SMARTCAST_IMPOSSIBLE) {
            return null;
        }
        PsiElement psiElement2 = diagnostic.getPsiElement();
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return null;
        }
        KtExpression element3 = ktExpression;
        BindingContext analyze2 = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
        KotlinType type2 = analyze2.getType(element3);
        if (type2 == null || !TypeUtils.isNullableType(type2)) {
            return null;
        }
        DiagnosticWithParameters3 diagnosticWithParameters3 = diagnosticWithParameters = (DiagnosticWithParameters3)Errors.SMARTCAST_IMPOSSIBLE.cast(diagnostic);
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticWithParameters3, (String)"diagnosticWithParameters");
        KotlinType expectedType = (KotlinType)diagnosticWithParameters3.getA();
        if (TypeUtils.isNullableType(expectedType)) {
            return null;
        }
        KotlinType kotlinType = nullableExpectedType = TypeUtils.makeNullable(expectedType);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"nullableExpectedType");
        if (!TypeUtilsKt.isSubtypeOf(type2, kotlinType)) {
            return null;
        }
        return new AddExclExclCallFix((PsiElement)element3, false);
    }

    private SmartCastImpossibleExclExclFixFactory() {
    }

    static {
        SmartCastImpossibleExclExclFixFactory smartCastImpossibleExclExclFixFactory;
        INSTANCE = smartCastImpossibleExclExclFixFactory = new SmartCastImpossibleExclExclFixFactory();
    }
}

