/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "element", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Companion", "idea"})
public final class RemoveFunctionBodyFix
extends KotlinQuickFixAction<KtFunction> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Remove function body";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtFunction ktFunction = (KtFunction)this.getElement();
        if (ktFunction == null) {
            return false;
        }
        KtFunction element3 = ktFunction;
        return element3.hasBody();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtFunction ktFunction = (KtFunction)this.getElement();
        if (ktFunction == null) {
            return;
        }
        KtFunction element3 = ktFunction;
        KtExpression ktExpression = element3.getBodyExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression bodyExpression = ktExpression;
        PsiElement equalsToken = element3.getEqualsToken();
        if (equalsToken != null) {
            PsiElement psiElement2 = equalsToken.getNextSibling();
            KtExpression ktExpression2 = bodyExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"bodyExpression");
            CommentSaver commentSaver = new CommentSaver(new PsiChildRange(psiElement2, ktExpression2.getPrevSibling()), true);
            element3.deleteChildRange(equalsToken, (PsiElement)bodyExpression);
            CommentSaver.restore$default(commentSaver, element3, false, 2, null);
        } else {
            bodyExpression.delete();
        }
    }

    public RemoveFunctionBodyFix(@NotNull KtFunction element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtFunction> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunction.class, (boolean)false);
            if (ktFunction == null) {
                return null;
            }
            KtFunction function2 = ktFunction;
            return new RemoveFunctionBodyFix(function2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

