/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsImpl;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddArrayOfTypeFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddToStringFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeToUseSpreadOperatorFix;
import org.jetbrains.kotlin.idea.quickfix.ConvertCollectionFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.LetImplementInterfaceFix;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.idea.quickfix.QuickFixFactoryForTypeMismatchError;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFix;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "dropParameterNameAnnotations", "Lorg/jetbrains/kotlin/types/KotlinType;", "reflectToRegularFunctionType", "Companion", "idea"})
public final class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final KotlinType dropParameterNameAnnotations(@NotNull KotlinType $receiver) {
        Collection<TypeProjectionImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        Iterable iterable = $receiver.getArguments();
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        Annotations annotations2 = $receiver.getAnnotations();
        void var3_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KotlinType kotlinType;
            List list2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            Variance variance = it.getProjectionKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getType(), (String)"it.type");
            Iterable iterable2 = it.getType().getAnnotations();
            Variance variance2 = variance;
            void var15_15 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                AnnotationDescriptor it2 = (AnnotationDescriptor)element$iv$iv;
                if (!(!(it2 instanceof BuiltInAnnotationDescriptor))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list3 = list2 = (List)destination$iv$iv2;
            KotlinType kotlinType2 = TypeUtilsKt.replaceAnnotations(kotlinType, new AnnotationsImpl(list3));
            Variance variance3 = variance2;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(variance3, kotlinType2);
            collection.add(typeProjectionImpl);
        }
        collection = (List)destination$iv$iv;
        return KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor, (List<? extends TypeProjection>)collection);
    }

    private final KotlinType reflectToRegularFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        boolean isTypeAnnotatedWithExtensionFunctionType = annotations2.findAnnotation(fqName2) != null;
        int parameterCount = isTypeAnnotatedWithExtensionFunctionType ? $receiver.getArguments().size() - 2 : $receiver.getArguments().size() - 1;
        Annotations annotations3 = $receiver.getAnnotations();
        ClassDescriptor classDescriptor = TypeUtilsKt.getBuiltIns($receiver).getFunction(parameterCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"builtIns.getFunction(parameterCount)");
        return KotlinTypeFactory.simpleNotNullType(annotations3, classDescriptor, $receiver.getArguments());
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        PsiElement it;
        KotlinType expressionType;
        KotlinType expectedType;
        PsiElement diagnosticElement;
        BindingContext context;
        LinkedList<KotlinQuickFixAction> actions;
        block43: {
            block45: {
                block44: {
                    KtAnnotationEntry annotationEntry2;
                    KtFunction declaration2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    PsiElement expressionParent;
                    KtCallableDeclaration function2;
                    KotlinType nullableExpected;
                    Object expressionTypeDeclaration;
                    Object diagnosticWithParameters;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    actions = new LinkedList<KotlinQuickFixAction>();
                    PsiFile psiFile = diagnostic.getPsiFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    KtDeclarationContainer $receiver$iv = (KtFile)psiFile;
                    context = ResolutionUtils.getResolutionFacade((KtElement)((Object)$receiver$iv)).analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)$receiver$iv)).getBindingContext();
                    diagnosticElement = diagnostic.getPsiElement();
                    if (!(diagnosticElement instanceof KtExpression)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Unexpected element: ");
                        PsiElement psiElement2 = diagnosticElement;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnosticElement");
                        LOG.error(stringBuilder.append(psiElement2.getText()).toString());
                        return CollectionsKt.emptyList();
                    }
                    DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                    if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast(diagnostic);
                        DiagnosticWithParameters2 diagnosticWithParameters2 = diagnosticWithParameters;
                        Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticWithParameters2, (String)"diagnosticWithParameters");
                        Object a = diagnosticWithParameters2.getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE)) {
                        diagnosticWithParameters = (DiagnosticWithParameters1)Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
                        AbstractDiagnostic abstractDiagnostic = diagnosticWithParameters;
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractDiagnostic, (String)"diagnosticWithParameters");
                        Object a = ((DiagnosticWithParameters1)abstractDiagnostic).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = TypeUtilsKt.makeNullable(expectedType);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        AbstractDiagnostic abstractDiagnostic = diagnosticWithParameters;
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractDiagnostic, (String)"diagnosticWithParameters");
                        Object a = ((DiagnosticWithParameters2)abstractDiagnostic).getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)((DiagnosticWithParameters2)diagnosticWithParameters).getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
                        diagnosticWithParameters = (DiagnosticWithParameters2)Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        AbstractDiagnostic abstractDiagnostic = diagnosticWithParameters;
                        Intrinsics.checkExpressionValueIsNotNull((Object)abstractDiagnostic, (String)"diagnosticWithParameters");
                        Object b = ((DiagnosticWithParameters2)abstractDiagnostic).getB();
                        Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                        expectedType = (KotlinType)b;
                        expressionType = context.getType((KtExpression)diagnosticElement);
                        if (expressionType == null) {
                            LOG.error("No type inferred: " + ((KtExpression)diagnosticElement).getText());
                            return CollectionsKt.emptyList();
                        }
                    } else {
                        LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                        return CollectionsKt.emptyList();
                    }
                    if (TypeUtilsKt.isPrimitiveNumberType(expressionType) && TypeUtilsKt.isPrimitiveNumberType(expectedType)) {
                        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = null;
                        if (diagnosticElement instanceof KtConstantExpression && !KotlinBuiltIns.isChar(expectedType)) {
                            wrongPrimitiveLiteralFix = new WrongPrimitiveLiteralFix((KtConstantExpression)diagnosticElement, expectedType);
                            actions.add(wrongPrimitiveLiteralFix);
                        }
                        actions.add(new NumberConversionFix((KtExpression)diagnosticElement, expectedType, wrongPrimitiveLiteralFix));
                    }
                    if (KotlinBuiltIns.isCharSequenceOrNullableCharSequence(expectedType) || KotlinBuiltIns.isStringOrNullableString(expectedType)) {
                        actions.add(new AddToStringFix((KtExpression)diagnosticElement, false));
                        if (expectedType.isMarkedNullable() && expressionType.isMarkedNullable()) {
                            actions.add(new AddToStringFix((KtExpression)diagnosticElement, true));
                        }
                    }
                    if (TypeUtilsKt.isInterface(expectedType)) {
                        PsiElement psiElement3;
                        PsiElement psiElement4;
                        Object it2;
                        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor != null) {
                            Object object = it2 = (diagnosticWithParameters = classifierDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                            psiElement4 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)object);
                        } else {
                            psiElement4 = psiElement3 = null;
                        }
                        if (!(psiElement4 instanceof KtClassOrObject)) {
                            psiElement3 = null;
                        }
                        Object object = expressionTypeDeclaration = (KtClassOrObject)psiElement3;
                        if (object != null) {
                            it2 = diagnosticWithParameters = object;
                            actions.add(new LetImplementInterfaceFix((KtClassOrObject)it2, expectedType, expressionType));
                        }
                    }
                    ConvertCollectionFix.CollectionType collectionType = ConvertCollectionFix.Companion.getConversionTypeOrNull(expressionType, expectedType);
                    if (collectionType != null) {
                        ConvertCollectionFix.CollectionType it3 = expressionTypeDeclaration = collectionType;
                        actions.add(new ConvertCollectionFix((KtExpression)diagnosticElement, it3));
                    }
                    doCreateActions.3 getTopMostQualifiedForSelectorIfAny$ = doCreateActions.3.INSTANCE;
                    if (!(diagnosticElement instanceof KtBinaryExpressionWithTypeRHS) && !(((KtExpression)diagnosticElement).getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
                        actions.add(new CastExpressionFix(getTopMostQualifiedForSelectorIfAny$.invoke((KtExpression)diagnosticElement), expectedType));
                    }
                    if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, nullableExpected = TypeUtilsKt.makeNullable(expectedType))) {
                        actions.add(new AddExclExclCallFix((PsiElement)getTopMostQualifiedForSelectorIfAny$.invoke((KtExpression)diagnosticElement)));
                    }
                    Function3 addChangeTypeFix$ = new Function3<D, KotlinType, Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>>, Unit>(this, context, actions){
                        final /* synthetic */ QuickFixFactoryForTypeMismatchError this$0;
                        final /* synthetic */ BindingContext $context;
                        final /* synthetic */ LinkedList $actions;

                        public final <D extends KtCallableDeclaration> void invoke(@NotNull D callable2, @NotNull KotlinType expressionType, @NotNull Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>> createFix) {
                            Intrinsics.checkParameterIsNotNull(callable2, (String)"callable");
                            Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
                            Intrinsics.checkParameterIsNotNull(createFix, (String)"createFix");
                            LexicalScope scope2 = ScopeUtils.getResolutionScope(callable2, this.$context, ResolutionUtils.getResolutionFacade(callable2));
                            KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                            ClassifierDescriptor classifierDescriptor = typeToInsert.getConstructor().getDeclarationDescriptor();
                            if ((classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.KFunction) {
                                KotlinType reflectType = QuickFixFactoryForTypeMismatchError.access$dropParameterNameAnnotations(this.this$0, typeToInsert);
                                this.$actions.add(createFix.invoke(callable2, (Object)QuickFixFactoryForTypeMismatchError.access$reflectToRegularFunctionType(this.this$0, reflectType)));
                                this.$actions.add(createFix.invoke(callable2, (Object)reflectType));
                            } else {
                                this.$actions.add(createFix.invoke(callable2, (Object)typeToInsert));
                            }
                        }
                        {
                            this.this$0 = quickFixFactoryForTypeMismatchError;
                            this.$context = bindingContext2;
                            this.$actions = linkedList;
                            super(3);
                        }
                    };
                    KtProperty property2 = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtProperty.class);
                    if (property2 != null) {
                        KtPropertyAccessor getter = property2.getGetter();
                        KtExpression initializer2 = property2.getInitializer();
                        if (QuickFixUtil.canEvaluateTo(initializer2, (KtExpression)diagnosticElement) || getter != null && QuickFixUtil.canFunctionOrGetterReturnExpression(getter, (KtExpression)diagnosticElement)) {
                            addChangeTypeFix$.invoke((KtCallableDeclaration)property2, expressionType, doCreateActions.5.INSTANCE);
                        }
                    }
                    KtCallableDeclaration ktCallableDeclaration = function2 = (expressionParent = ((KtExpression)diagnosticElement).getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expressionParent, context) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtFunction.class, (boolean)true);
                    if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, (KtExpression)diagnosticElement)) {
                        addChangeTypeFix$.invoke(function2, expressionType, doCreateActions.6.INSTANCE);
                    }
                    if (diagnosticElement instanceof KtOperationExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if (diagnosticElement instanceof KtCallExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if ((annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtAnnotationEntry.class)) == null) break block43;
                    if (!KotlinBuiltIns.isArray(expectedType)) break block44;
                    KotlinType kotlinType = expectedType.getArguments().get(0).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expectedType.arguments[0].type");
                    if (TypeUtilsKt.isSubtypeOf(expressionType, kotlinType)) break block45;
                }
                if (!KotlinBuiltIns.isPrimitiveArray(expectedType)) break block43;
            }
            actions.add(new AddArrayOfTypeFix((KtExpression)diagnosticElement, expectedType));
        }
        PsiElement $receiver$iv = diagnosticElement;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtParameter.class, (boolean)true);
        if (ktParameter != null && Intrinsics.areEqual((Object)(it = ($receiver$iv = ktParameter)).getDefaultValue(), (Object)diagnosticElement)) {
            actions.add(new ChangeParameterTypeFix((KtParameter)it, expressionType));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getParentResolvedCall((KtElement)diagnosticElement, context, true);
        if (resolvedCall3 != null) {
            KtIfExpression parentIf;
            KtIfExpression ktIfExpression = parentIf = QuickFixUtil.getParentIfForBranch((KtExpression)diagnosticElement);
            KtExpression argumentExpression2 = ktIfExpression != null ? (KtExpression)ktIfExpression : (KtExpression)diagnosticElement;
            Call call2 = resolvedCall3.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
            ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call2, argumentExpression2);
            if (valueArgument != null) {
                KotlinType valueArgumentType;
                KotlinType kotlinType;
                ValueParameterDescriptor correspondingParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall3, valueArgument);
                PsiElement psiElement5 = QuickFixUtil.safeGetDeclaration(correspondingParameterDescriptor);
                if (!(psiElement5 instanceof KtParameter)) {
                    psiElement5 = null;
                }
                KtParameter correspondingParameter = (KtParameter)psiElement5;
                KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
                if (diagnostic.getFactory() == Errors.NULL_FOR_NONNULL_TYPE) {
                    kotlinType = expressionType;
                } else {
                    KtExpression ktExpression = expressionFromArgument;
                    if (ktExpression != null) {
                        KtExpression ktExpression2;
                        KtExpression it4 = ktExpression2 = ktExpression;
                        kotlinType = context.getType(it4);
                    } else {
                        kotlinType = valueArgumentType = null;
                    }
                }
                if (valueArgumentType != null) {
                    Collection collection;
                    KotlinType parameterVarargType;
                    if (correspondingParameter != null) {
                        KtCallableDeclaration callable2;
                        KtCallableDeclaration ktCallableDeclaration = callable2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
                        LexicalScope scope2 = ktCallableDeclaration != null ? ScopeUtils.getResolutionScope(ktCallableDeclaration, context, ResolutionUtils.getResolutionFacade(callable2)) : null;
                        KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(valueArgumentType, scope2, true);
                        actions.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert));
                    }
                    ValueParameterDescriptor valueParameterDescriptor = correspondingParameterDescriptor;
                    KotlinType kotlinType2 = parameterVarargType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
                    if ((parameterVarargType != null || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()), (Object)new FqName("kotlin.collections.mapOf"))) && KotlinBuiltIns.isArray(valueArgumentType) && !(collection = (Collection)expressionType.getArguments()).isEmpty() && Intrinsics.areEqual((Object)expressionType.getArguments().get(0).getType().getConstructor(), (Object)expectedType.getConstructor())) {
                        actions.add(new ChangeToUseSpreadOperatorFix((KtExpression)diagnosticElement));
                    }
                }
            }
        }
        return actions;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$dropParameterNameAnnotations(QuickFixFactoryForTypeMismatchError $this, @NotNull KotlinType $receiver) {
        return $this.dropParameterNameAnnotations($receiver);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$reflectToRegularFunctionType(QuickFixFactoryForTypeMismatchError $this, @NotNull KotlinType $receiver) {
        return $this.reflectToRegularFunctionType($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "idea"})
    public static final class Companion {
        private final KtFunction getFunctionDeclaration(ResolvedCall<?> resolvedCall2) {
            PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall2.getResultingDescriptor());
            if (result2 instanceof KtFunction) {
                return (KtFunction)result2;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

