/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.CaretBox;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionActionKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J#\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000bH\u0096\u0002J\"\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u001a\u0010%\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020$H\u0002J\u001e\u0010'\u001a\u00020\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001e\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinSuppressIntentionAction;", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "suppressAt", "Lorg/jetbrains/kotlin/psi/KtExpression;", "suppressKey", "", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "addArgumentToSuppressAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "id", "findSuppressAnnotation", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "annotationEntries", "", "getFamilyName", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "suppressAnnotationText", "withAt", "suppressAtAnnotatedExpression", "Lorg/jetbrains/kotlin/idea/quickfix/CaretBox;", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "suppressAtExpression", "caretBox", "suppressAtFile", "ktFile", "idea-core"})
public final class KotlinSuppressIntentionAction
extends SuppressIntentionAction {
    private final PsiElement suppressAt;
    private final String suppressKey;
    private final AnnotationHostKind kind;

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("suppress.warnings.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("suppress.warning.for", this.suppressKey, this.kind.getKind(), this.kind.getName());
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3.isValid();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element3)) {
            return;
        }
        String id = '\"' + this.suppressKey + '\"';
        PsiElement psiElement2 = this.suppressAt;
        if (psiElement2 instanceof KtModifierListOwner) {
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.suppressAt;
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.suppress;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.suppress");
            ModifierListModifactorKt.addAnnotation(ktModifierListOwner, fqName2, id, this.kind.getNewLineNeeded() ? "\n" : " ", (Function1<? super KtAnnotationEntry, Boolean>)((Function1)new Function1<KtAnnotationEntry, Boolean>(this, id){
                final /* synthetic */ KotlinSuppressIntentionAction this$0;
                final /* synthetic */ String $id;

                public final boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                    KotlinSuppressIntentionAction.access$addArgumentToSuppressAnnotation(this.this$0, entry, this.$id);
                    return true;
                }
                {
                    this.this$0 = kotlinSuppressIntentionAction;
                    this.$id = string;
                    super(1);
                }
            }));
        } else if (psiElement2 instanceof KtAnnotatedExpression) {
            this.suppressAtAnnotatedExpression(new CaretBox<KtExpression>((KtExpression)this.suppressAt, editor), id);
        } else if (psiElement2 instanceof KtExpression) {
            this.suppressAtExpression(new CaretBox<KtExpression>((KtExpression)this.suppressAt, editor), id);
        } else if (psiElement2 instanceof KtFile) {
            this.suppressAtFile((KtFile)this.suppressAt, id);
        }
    }

    private final void suppressAtFile(KtFile ktFile, String id) {
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(this.suppressAt, false, 2, null);
        KtFileAnnotationList fileAnnotationList = ktFile.getFileAnnotationList();
        if (fileAnnotationList == null) {
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(this.suppressAnnotationText(id, false));
            KtFileAnnotationList createAnnotationList = PsiUtilsKt.replaceFileAnnotationList(ktFile, newAnnotationList);
            ktFile.addAfter(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind), (PsiElement)createAnnotationList);
            return;
        }
        KtAnnotationEntry suppressAnnotation = this.findSuppressAnnotation(fileAnnotationList);
        if (suppressAnnotation == null) {
            KtAnnotationEntry newSuppressAnnotation = psiFactory.createFileAnnotation(this.suppressAnnotationText(id, false));
            fileAnnotationList.add(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind));
            PsiElement psiElement2 = fileAnnotationList.add((PsiElement)newSuppressAnnotation);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            KtAnnotationEntry cfr_ignored_0 = (KtAnnotationEntry)psiElement2;
            return;
        }
        this.addArgumentToSuppressAnnotation(suppressAnnotation, id);
    }

    private final void suppressAtAnnotatedExpression(CaretBox<? extends KtAnnotatedExpression> suppressAt, String id) {
        KtAnnotationEntry entry = this.findSuppressAnnotation(suppressAt.getExpression());
        if (entry != null) {
            this.addArgumentToSuppressAnnotation(entry, id);
        } else {
            this.suppressAtExpression(suppressAt, id);
        }
    }

    private final void suppressAtExpression(CaretBox<? extends KtExpression> caretBox, String id) {
        PsiElement toReplace;
        boolean bl;
        KtExpression suppressAt = caretBox.getExpression();
        boolean bl2 = bl = !(suppressAt instanceof KtDeclaration);
        if (_Assertions.ENABLED && !bl) {
            String string = "Declarations should have been checked for above";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String placeholderText = "PLACEHOLDER_ID";
        KtExpression annotatedExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)suppressAt, false, 2, null).createExpression(KotlinSuppressIntentionAction.suppressAnnotationText$default(this, id, false, 2, null) + "\n" + placeholderText);
        PsiElement psiElement2 = suppressAt.copy();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement copy = psiElement2;
        PsiElement psiElement3 = suppressAt.replace((PsiElement)annotatedExpression);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotatedExpression");
        }
        KtAnnotatedExpression afterReplace = (KtAnnotatedExpression)psiElement3;
        PsiElement psiElement4 = afterReplace.findElementAt(afterReplace.getTextLength() - 2);
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement5 = toReplace = psiElement4;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"toReplace");
        boolean bl3 = Intrinsics.areEqual((Object)psiElement5.getText(), (Object)placeholderText);
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PsiElement psiElement6 = toReplace.replace(copy);
        if (psiElement6 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement result2 = psiElement6;
        caretBox.positionCaretInCopy(result2);
    }

    private final void addArgumentToSuppressAnnotation(KtAnnotationEntry entry, String id) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)entry, false, 2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments('(' + id + ')');
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            args.addArgument(newArgList.getArguments().get(0));
        }
    }

    private final String suppressAnnotationText(String id, boolean withAt) {
        return (withAt ? "@" : "") + KotlinBuiltIns.FQ_NAMES.suppress.shortName() + '(' + id + ')';
    }

    static /* bridge */ /* synthetic */ String suppressAnnotationText$default(KotlinSuppressIntentionAction kotlinSuppressIntentionAction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kotlinSuppressIntentionAction.suppressAnnotationText(string, bl);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtAnnotated annotated) {
        BindingContext context = ResolutionUtils.analyze$default(annotated, null, 1, null);
        List<KtAnnotationEntry> list2 = annotated.getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotated.annotationEntries");
        return this.findSuppressAnnotation(context, list2);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtFileAnnotationList annotationList) {
        BindingContext context = ResolutionUtils.analyze$default(annotationList, null, 1, null);
        List<KtAnnotationEntry> list2 = annotationList.getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationList.annotationEntries");
        return this.findSuppressAnnotation(context, list2);
    }

    private final KtAnnotationEntry findSuppressAnnotation(BindingContext context, List<? extends KtAnnotationEntry> annotationEntries) {
        Object v1;
        block1: {
            Iterable $receiver$iv = annotationEntries;
            for (Object element$iv : $receiver$iv) {
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, entry);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)KotlinBuiltIns.FQ_NAMES.suppress)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private KotlinSuppressIntentionAction(PsiElement suppressAt, String suppressKey, AnnotationHostKind kind2) {
        this.suppressAt = suppressAt;
        this.suppressKey = suppressKey;
        this.kind = kind2;
    }

    public KotlinSuppressIntentionAction(@NotNull KtExpression suppressAt, @NotNull String suppressKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkParameterIsNotNull((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkParameterIsNotNull((Object)suppressKey, (String)"suppressKey");
        Intrinsics.checkParameterIsNotNull((Object)kind2, (String)"kind");
        this((PsiElement)suppressAt, suppressKey, kind2);
    }

    public KotlinSuppressIntentionAction(@NotNull KtFile suppressAt, @NotNull String suppressKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkParameterIsNotNull((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkParameterIsNotNull((Object)suppressKey, (String)"suppressKey");
        Intrinsics.checkParameterIsNotNull((Object)kind2, (String)"kind");
        this((PsiElement)suppressAt, suppressKey, kind2);
    }

    public static final /* synthetic */ void access$addArgumentToSuppressAnnotation(KotlinSuppressIntentionAction $this, @NotNull KtAnnotationEntry entry, @NotNull String id) {
        $this.addArgumentToSuppressAnnotation(entry, id);
    }
}

