/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0017\u0018\u0019B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typePresentation", "", "typeSourceCode", "upOrDownCast", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Factory", "GenericVarianceConversion", "SmartCastImpossibleFactory", "idea"})
public final class CastExpressionFix
extends KotlinQuickFixAction<KtExpression> {
    private final String typeSourceCode;
    private final String typePresentation;
    private final boolean upOrDownCast;

    @NotNull
    public String getFamilyName() {
        return "Cast expression";
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                KtExpression ktExpression;
                object = (KtExpression)this.getElement();
                if (object == null) break block2;
                KtExpression it = ktExpression = object;
                object = "Cast expression '" + it.getText() + "' to '" + this.typePresentation + '\'';
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return this.upOrDownCast;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block7: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtExpression expressionToInsert = CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file2, false, 2, null), "$0 as $1", new Object[]{element3, this.typeSourceCode}, false, 4, null);
            PsiElement $receiver$iv = (PsiElement)element3;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)expressionToInsert);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            KtExpression newExpression2 = (KtExpression)object;
            KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(newExpression2);
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
            }
            KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)ktExpression2).getRight();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"(KtPsiUtil.safeDeparenth\u2026ssionWithTypeRHS).right!!");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktTypeReference, null, 2, null);
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block7;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)newExpression2));
        }
    }

    public CastExpressionFix(@NotNull KtExpression element3, @NotNull KotlinType type2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element3);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(type2);
        CastExpressionFix castExpressionFix = this;
        CastExpressionFix castExpressionFix2 = this;
        CastExpressionFix $receiver = castExpressionFix;
        KotlinType expressionType = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL).getType(element3);
        castExpressionFix2.upOrDownCast = bl = expressionType != null && (TypeUtilsKt.isSubtypeOf(type2, expressionType) || TypeUtilsKt.isSubtypeOf(expressionType, type2)) && Intrinsics.areEqual((Object)expressionType, (Object)TypeUtilsKt.makeNullable(type2)) ^ true;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "()V", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "originalElement", "data", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static abstract class Factory
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtExpression, KotlinType> {
        @Override
        @Nullable
        public KtExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            return (KtExpression)psiElement2;
        }

        @NotNull
        protected CastExpressionFix createFix(@NotNull KtExpression originalElement2, @NotNull KotlinType data) {
            Intrinsics.checkParameterIsNotNull((Object)originalElement2, (String)"originalElement");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new CastExpressionFix(originalElement2, data);
        }

        public Factory() {
            super(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$SmartCastImpossibleFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class SmartCastImpossibleFactory
    extends Factory {
        public static final SmartCastImpossibleFactory INSTANCE;

        @Override
        @NotNull
        public KotlinType extractFixData(@NotNull KtExpression element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.SMARTCAST_IMPOSSIBLE.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.SMARTCAST_IMPOSSIBLE.cast(diagnostic)");
            return (KotlinType)((DiagnosticWithParameters3)d).getA();
        }

        private SmartCastImpossibleFactory() {
        }

        static {
            SmartCastImpossibleFactory smartCastImpossibleFactory;
            INSTANCE = smartCastImpossibleFactory = new SmartCastImpossibleFactory();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$GenericVarianceConversion;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class GenericVarianceConversion
    extends Factory {
        public static final GenericVarianceConversion INSTANCE;

        @Override
        @Nullable
        public KotlinType extractFixData(@NotNull KtExpression element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = ErrorsJvm.JAVA_TYPE_MISMATCH.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"ErrorsJvm.JAVA_TYPE_MISMATCH.cast(diagnostic)");
            Object b = ((DiagnosticWithParameters2)d).getB();
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"ErrorsJvm.JAVA_TYPE_MISMATCH.cast(diagnostic).b");
            return FlexibleTypesKt.asFlexibleType((KotlinType)b).getUpperBound();
        }

        private GenericVarianceConversion() {
        }

        static {
            GenericVarianceConversion genericVarianceConversion;
            INSTANCE = genericVarianceConversion = new GenericVarianceConversion();
        }
    }
}

