/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.BooleanMissingCase;
import org.jetbrains.kotlin.cfg.ClassMissingCase;
import org.jetbrains.kotlin.cfg.NullMissingCase;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenCheckerKt;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.ImportAllMembersIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\"\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddWhenRemainingBranchesFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "expression", "withImport", "", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Z)V", "getWithImport", "()Z", "getFamilyName", "", "getText", "importAllEntries", "", "element", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Companion", "idea"})
public final class AddWhenRemainingBranchesFix
extends KotlinQuickFixAction<KtWhenExpression> {
    private final boolean withImport;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Add remaining branches" + (this.withImport ? " with import" : "");
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        List<WhenMissingCase> list2;
        List<WhenMissingCase> $receiver;
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression element3 = ktWhenExpression;
        return element3.getCloseBrace() != null && !(collection = (Collection)($receiver = (list2 = WhenChecker.INSTANCE.getMissingCases(element3, ResolutionUtils.analyze$default(element3, null, 1, null))))).isEmpty() && !WhenCheckerKt.getHasUnknown($receiver);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
        if (ktWhenExpression == null) {
            return;
        }
        KtWhenExpression element3 = ktWhenExpression;
        List<WhenMissingCase> missingCases = WhenChecker.INSTANCE.getMissingCases(element3, ResolutionUtils.analyze$default(element3, null, 1, null));
        PsiElement psiElement2 = element3.getCloseBrace();
        if (psiElement2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"isAvailable should check if close brace exist"));
        }
        PsiElement whenCloseBrace = psiElement2;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file2, false, 2, null);
        for (WhenMissingCase whenMissingCase : missingCases) {
            String string;
            WhenMissingCase whenMissingCase2 = whenMissingCase;
            if (Intrinsics.areEqual((Object)whenMissingCase2, (Object)UnknownMissingCase.INSTANCE) || Intrinsics.areEqual((Object)whenMissingCase2, (Object)NullMissingCase.INSTANCE) || whenMissingCase2 instanceof BooleanMissingCase) {
                string = whenMissingCase.getBranchConditionText();
            } else if (whenMissingCase2 instanceof ClassMissingCase) {
                String string2 = ((ClassMissingCase)whenMissingCase).getClassIsSingleton() ? UtilsKt.quoteIfNeeded(((ClassMissingCase)whenMissingCase).getClassFqName()).asString() : "is " + UtilsKt.quoteIfNeeded(((ClassMissingCase)whenMissingCase).getClassFqName()).asString();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (case.classIsSingleto\u2026g()\n                    }");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String branchConditionText = string;
            KtWhenEntry entry = psiFactory.createWhenEntry(branchConditionText + " -> TODO()");
            element3.addBefore((PsiElement)entry, whenCloseBrace);
        }
        if (this.withImport) {
            this.importAllEntries(element3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void importAllEntries(KtWhenExpression element3) {
        block5: {
            KtDotQualifiedExpression ktDotQualifiedExpression;
            ImportAllMembersIntention.Companion $receiver;
            block4: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                ImportAllMembersIntention.Companion companion;
                $receiver = companion = ImportAllMembersIntention.Companion;
                List<KtWhenEntry> list2 = element3.getEntries();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.entries");
                Iterable iterable = list2;
                Iterator iterator2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    Object[] objectArray = v1.getConditions();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.conditions");
                    List list3 = ArraysKt.toList((Object[])objectArray);
                    collection.add(list3);
                }
                $receiver$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                for (Object element$iv : $receiver$iv) {
                    KtDotQualifiedExpression result$iv;
                    KtWhenCondition it = (KtWhenCondition)element$iv;
                    KtWhenCondition ktWhenCondition = it;
                    if (!(ktWhenCondition instanceof KtWhenConditionWithExpression)) {
                        ktWhenCondition = null;
                    }
                    KtWhenConditionWithExpression ktWhenConditionWithExpression = (KtWhenConditionWithExpression)ktWhenCondition;
                    KtExpression ktExpression = ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null;
                    if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                        ktExpression = null;
                    }
                    if ((result$iv = (KtDotQualifiedExpression)ktExpression) == null) continue;
                    ktDotQualifiedExpression = result$iv;
                    break block4;
                }
                ktDotQualifiedExpression = null;
            }
            if (ktDotQualifiedExpression == null) break block5;
            $receiver.importReceiverMembers(ktDotQualifiedExpression);
        }
    }

    public final boolean getWithImport() {
        return this.withImport;
    }

    public AddWhenRemainingBranchesFix(@NotNull KtWhenExpression expression2, boolean withImport) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        super((PsiElement)expression2);
        this.withImport = withImport;
    }

    public /* synthetic */ AddWhenRemainingBranchesFix(KtWhenExpression ktWhenExpression, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(ktWhenExpression, bl);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddWhenRemainingBranchesFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "hasEnumSubject", "", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        private final boolean hasEnumSubject(@NotNull KtWhenExpression $receiver) {
            KtExpression subject;
            KtExpression ktExpression = $receiver.getSubjectExpression();
            if (ktExpression == null) {
                return false;
            }
            KtExpression ktExpression2 = subject = ktExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"subject");
            Object object = ResolutionUtils.analyze$default(ktExpression2, null, 1, null).getType(subject);
            if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
                return false;
            }
            Object descriptor2 = object;
            Object object2 = descriptor2;
            if (!(object2 instanceof ClassDescriptor)) {
                object2 = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)object2;
            return (classDescriptor != null ? classDescriptor.getKind() : null) == ClassKind.ENUM_CLASS;
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenExpression.class, (boolean)false);
            if (ktWhenExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtWhenExpression whenExpression2 = ktWhenExpression;
            List actions = CollectionsKt.mutableListOf((Object[])new AddWhenRemainingBranchesFix[]{new AddWhenRemainingBranchesFix(whenExpression2, false, 2, null)});
            if (this.hasEnumSubject(whenExpression2)) {
                Collection collection = actions;
                AddWhenRemainingBranchesFix addWhenRemainingBranchesFix = new AddWhenRemainingBranchesFix(whenExpression2, true);
                collection.add(addWhenRemainingBranchesFix);
            }
            return actions;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

