/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "declarationName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "getText", "Companion", "UnresolvedReferenceFactory", "idea"})
public final class AddSuspendModifierFix
extends AddModifierFix {
    private final String declarationName;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getText() {
        String string;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner instanceof KtNamedFunction) {
            StringBuilder stringBuilder = new StringBuilder().append("Make ");
            String string2 = this.declarationName;
            if (string2 == null) {
                string2 = "containing function";
            }
            string = stringBuilder.append(string2).append(" suspend").toString();
        } else if (ktModifierListOwner instanceof KtTypeReference) {
            StringBuilder stringBuilder = new StringBuilder().append("Make ");
            String string3 = this.declarationName;
            if (string3 == null) {
                string3 = "receiver";
            }
            string = stringBuilder.append(string3).append(" type suspend").toString();
        } else {
            string = super.getText();
        }
        return string;
    }

    public AddSuspendModifierFix(@NotNull KtModifierListOwner element3, @Nullable String declarationName2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.SUSPEND_KEYWORD");
        super(element3, ktModifierKeywordToken);
        this.declarationName = declarationName2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$UnresolvedReferenceFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "suspendExtensionNames", "", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class UnresolvedReferenceFactory
    extends KotlinSingleIntentionActionFactory {
        private static final Set<String> suspendExtensionNames;
        public static final UnresolvedReferenceFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtTypeReference variableTypeReference;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtNameReferenceExpression)) {
                psiElement2 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)psiElement2;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression refExpr = ktNameReferenceExpression;
            if (!suspendExtensionNames.contains(refExpr.getReferencedName())) {
                return null;
            }
            PsiElement psiElement3 = refExpr.getParent();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callParent = ktCallExpression;
            PsiElement psiElement4 = callParent.getParent();
            if (!(psiElement4 instanceof KtQualifiedExpression)) {
                psiElement4 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement4;
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression qualifiedGrandParent = ktQualifiedExpression;
            if (callParent != qualifiedGrandParent.getSelectorExpression() || refExpr != callParent.getCalleeExpression()) {
                return null;
            }
            KtExpression ktExpression = qualifiedGrandParent.getReceiverExpression();
            if (!(ktExpression instanceof KtNameReferenceExpression)) {
                ktExpression = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression2 = (KtNameReferenceExpression)ktExpression;
            if (ktNameReferenceExpression2 == null) {
                return null;
            }
            KtNameReferenceExpression receiver = ktNameReferenceExpression2;
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(receiver, null, 1, null);
            Object object = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
            if (!(object instanceof ValueDescriptor)) {
                object = null;
            }
            ValueDescriptor valueDescriptor = (ValueDescriptor)object;
            if (valueDescriptor == null) {
                return null;
            }
            ValueDescriptor receiverDescriptor = valueDescriptor;
            KotlinType kotlinType = receiverDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverDescriptor.type");
            if (!FunctionTypesKt.isFunctionType(kotlinType)) {
                return null;
            }
            PsiElement psiElement5 = DescriptorToSourceUtils.descriptorToDeclaration(receiverDescriptor);
            if (!(psiElement5 instanceof KtCallableDeclaration)) {
                psiElement5 = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement5;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration declaration2 = ktCallableDeclaration;
            if (declaration2 instanceof KtFunction) {
                return null;
            }
            KtTypeReference ktTypeReference = declaration2.getTypeReference();
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference ktTypeReference2 = variableTypeReference = ktTypeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"variableTypeReference");
            return new AddSuspendModifierFix((KtModifierListOwner)ktTypeReference2, declaration2.getName());
        }

        private UnresolvedReferenceFactory() {
        }

        static {
            UnresolvedReferenceFactory unresolvedReferenceFactory;
            INSTANCE = unresolvedReferenceFactory = new UnresolvedReferenceFactory();
            suspendExtensionNames = SetsKt.setOf((Object[])new String[]{"startCoroutine", "createCoroutine"});
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddSuspendModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement element3 = diagnostic.getPsiElement();
            PsiElement psiElement2 = element3;
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = (KtElement)psiElement2;
            KtDeclaration ktDeclaration = ktElement != null ? PseudocodeUtilsKt.getContainingDeclarationForPseudocode(ktElement) : null;
            if (!(ktDeclaration instanceof KtNamedFunction)) {
                ktDeclaration = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)ktDeclaration;
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            return new AddSuspendModifierFix((KtModifierListOwner)function2, function2.getName());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

