/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.ConvertToStringTemplateIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.joinLines.JoinToStringTemplateHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinToStringTemplateHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "()V", "createStringTemplate", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "left", "rightText", "", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "tryJoinRawLines", "idea"})
public final class JoinToStringTemplateHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        int n;
        KtExpression ktExpression;
        PsiElement plus;
        Object object;
        block19: {
            block18: {
                PsiElement psiElement2;
                PsiElement it;
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (!(file2 instanceof KtFile)) {
                    return -1;
                }
                if (start == 0) {
                    return -1;
                }
                char c = document.getCharsSequence().charAt(start);
                int index2 = c == '\n' ? start - 1 : start;
                object = file2.findElementAt(index2);
                if (object == null) break block18;
                PsiElement psiElement3 = it = (psiElement2 = object);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it");
                ASTNode aSTNode = psiElement3.getNode();
                object = Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.PLUS)) ? psiElement2 : null;
                if (object != null) break block19;
            }
            return -1;
        }
        PsiElement psiElement4 = plus = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"plus");
        PsiElement psiElement5 = psiElement4.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"plus.parent");
        PsiElement psiElement6 = psiElement5.getParent();
        if (!(psiElement6 instanceof KtBinaryExpression)) {
            psiElement6 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement6;
        if (ktBinaryExpression == null) {
            return -1;
        }
        KtBinaryExpression binaryExpr = ktBinaryExpression;
        if (!JoinToStringTemplateHandlerKt.access$joinable(binaryExpr)) {
            return -1;
        }
        int lineCount = KotlinRefactoringUtilKt.getLineCount((PsiElement)binaryExpr);
        int nextLineCount = lineCount + 1;
        PsiElement parent2 = binaryExpr.getParent();
        while (parent2 instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)parent2) && IfThenUtilsKt.lineCount((KtExpression)parent2) == nextLineCount) {
            binaryExpr = (KtBinaryExpression)parent2;
            parent2 = ((KtBinaryExpression)parent2).getParent();
        }
        String rightText = ConvertToStringTemplateIntention.Companion.buildText(binaryExpr.getRight(), false);
        KtExpression left = binaryExpr.getLeft();
        while (left instanceof KtBinaryExpression && JoinToStringTemplateHandlerKt.access$joinable((KtBinaryExpression)left)) {
            KtExpression leftLeft;
            KtExpression ktExpression2;
            KtExpression ktExpression3 = left;
            if (!(ktExpression3 instanceof KtBinaryExpression)) {
                ktExpression3 = null;
            }
            if ((ktExpression2 = (KtBinaryExpression)ktExpression3) == null || (ktExpression2 = ktExpression2.getLeft()) == null) {
                break;
            }
            KtExpression ktExpression4 = leftLeft = ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"leftLeft");
            if (IfThenUtilsKt.lineCount(ktExpression4) < lineCount) break;
            rightText = ConvertToStringTemplateIntention.Companion.buildText(((KtBinaryExpression)left).getRight(), false) + rightText;
            left = ((KtBinaryExpression)left).getLeft();
        }
        if ((ktExpression = left) instanceof KtStringTemplateExpression) {
            int offset2 = PsiUtilsKt.getEndOffset((PsiElement)left) - 1;
            binaryExpr.replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)left, rightText));
            n = offset2;
        } else if (ktExpression instanceof KtBinaryExpression) {
            KtExpression leftRight = ((KtBinaryExpression)left).getRight();
            if (leftRight instanceof KtStringTemplateExpression) {
                int offset3 = PsiUtilsKt.getEndOffset((PsiElement)leftRight) - 1;
                ((KtStringTemplateExpression)leftRight).replace((PsiElement)this.createStringTemplate((KtStringTemplateExpression)leftRight, rightText));
                binaryExpr.replace((PsiElement)left);
                n = offset3;
            } else {
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private final KtStringTemplateExpression createStringTemplate(KtStringTemplateExpression left, String rightText) {
        String leftText = ConvertToStringTemplateIntention.Companion.buildText(left, false);
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)left, false, 2, null).createExpression('\"' + leftText + rightText + '\"');
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
        }
        return (KtStringTemplateExpression)ktExpression;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return -1;
    }
}

