/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.UseExpressionBodyInspection;
import org.jetbrains.kotlin.idea.intentions.MergeIfsIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "tryJoinRawLines", "idea"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinRawLinesHandlerDelegate {
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        int n;
        ASTNode[] oneLineReturnFunction;
        ASTNode[] aSTNodeArray;
        ASTNode[] it;
        PsiElement brace;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return -1;
        }
        if (start == 0) {
            return -1;
        }
        char c = document.getCharsSequence().charAt(start);
        int index2 = c == '\n' ? start - 1 : start;
        PsiElement psiElement2 = file2.findElementAt(index2);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement3 = brace = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"brace");
        ASTNode aSTNode = psiElement3.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.LBRACE)) ^ true) {
            return -1;
        }
        PsiElement psiElement4 = brace.getParent();
        if (!(psiElement4 instanceof KtBlockExpression)) {
            psiElement4 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement4;
        if (ktBlockExpression == null) {
            return -1;
        }
        KtBlockExpression block = ktBlockExpression;
        List<KtExpression> list2 = block.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(list2);
        if (ktExpression == null) {
            return -1;
        }
        KtExpression statement2 = ktExpression;
        PsiElement parent2 = block.getParent();
        UseExpressionBodyInspection useExpressionBodyInspection = new UseExpressionBodyInspection(false);
        PsiElement psiElement5 = parent2;
        if (!(psiElement5 instanceof KtDeclarationWithBody)) {
            psiElement5 = null;
        }
        ASTNode[] aSTNodeArray2 = (ASTNode[])psiElement5;
        Object object = aSTNodeArray2 != null ? (useExpressionBodyInspection.isActiveFor((KtDeclarationWithBody)(it = (aSTNodeArray = aSTNodeArray2))) ? aSTNodeArray : null) : (oneLineReturnFunction = null);
        if (!(parent2 instanceof KtContainerNode) && !(parent2 instanceof KtWhenEntry) && oneLineReturnFunction == null) {
            return -1;
        }
        ASTNode[] aSTNodeArray3 = block.getNode().getChildren(KtTokens.COMMENTS);
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray3, (String)"block.node.getChildren(KtTokens.COMMENTS)");
        it = aSTNodeArray = aSTNodeArray3;
        if (!(it.length == 0)) {
            return -1;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof KtIfExpression) {
            PsiElement ifParent;
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getThen()) && statement2 instanceof KtIfExpression && ((KtIfExpression)statement2).getElse() == null) {
                if (((KtIfExpression)pparent).getElse() != null) {
                    return -1;
                }
                return MergeIfsIntention.Companion.applyTo((KtIfExpression)pparent);
            }
            if (Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getElse()) && !((ifParent = ((KtIfExpression)pparent).getParent()) instanceof KtBlockExpression) && !(ifParent instanceof KtDeclaration) && !KtPsiUtil.isAssignment(ifParent)) {
                return -1;
            }
        }
        if (oneLineReturnFunction != null) {
            useExpressionBodyInspection.simplify((KtDeclarationWithBody)oneLineReturnFunction, false);
            KtExpression ktExpression2 = oneLineReturnFunction.getBodyExpression();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"oneLineReturnFunction.bodyExpression!!");
            n = PsiUtilsKt.getStartOffset((PsiElement)ktExpression2);
        } else {
            PsiElement newStatement = block.replace((PsiElement)statement2);
            TextRange textRange = newStatement.getTextRange();
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            n = textRange.getStartOffset();
        }
        return n;
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file2, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return -1;
    }
}

