/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ReplaceAddWithPlusAssignIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "compatibleNames", "", "", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "idea"})
public final class ReplaceAddWithPlusAssignIntention
extends SelfTargetingOffsetIndependentIntention<KtDotQualifiedExpression> {
    private final Set<String> compatibleNames = SetsKt.setOf((Object[])new String[]{"add", "addAll"});

    @Override
    public boolean isApplicableTo(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Object object = UtilsKt.getCallExpression(element3);
        if (object == null || (object = ((KtCallExpression)object).getValueArguments()) == null || object.size() != 1) {
            return false;
        }
        if (!CollectionsKt.contains((Iterable)this.compatibleNames, (Object)UtilsKt.getCalleeName(element3))) {
            return false;
        }
        this.setText("Replace '" + UtilsKt.getCalleeName(element3) + "()' with '+='");
        BindingContext context = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
        VariableDescriptor variableDescriptor = BindingContextUtils.extractVariableDescriptorFromReference(context, element3.getReceiverExpression());
        if (variableDescriptor != null) {
            VariableDescriptor variableDescriptor2;
            VariableDescriptor it;
            VariableDescriptor variableDescriptor3 = it = (variableDescriptor2 = variableDescriptor);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor3, (String)"it");
            if (variableDescriptor3.isVar()) {
                return false;
            }
        } else {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element3, context);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        Object object2 = ResolvedCallUtilKt.getExplicitReceiverValue(resolvedCall3);
        if (object2 == null || (object2 = object2.getType()) == null) {
            return false;
        }
        Object receiverType2 = object2;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)receiverType2).getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor receiverClass = classDescriptor;
        ClassDescriptor classDescriptor2 = DefaultBuiltIns.Companion.getInstance().getMutableCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"DefaultBuiltIns.Instance.mutableCollection");
        return DescriptorUtilsKt.isSubclassOf(receiverClass, classDescriptor2);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Object[] objectArray = new Object[2];
        objectArray[0] = element3.getReceiverExpression();
        Object object = UtilsKt.getCallExpression(element3);
        if (object == null || (object = ((KtCallExpression)object).getValueArguments()) == null || (object = (KtValueArgument)object.get(0)) == null || (object = ((KtValueArgument)object).getArgumentExpression()) == null) {
            return;
        }
        objectArray[1] = object;
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), "$0 += $1", objectArray, false, 4, null));
    }

    public ReplaceAddWithPlusAssignIntention() {
        super(KtDotQualifiedExpression.class, "Replace with '+='", null, 4, null);
    }
}

