/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea-core"})
public final class OperatorToFunctionIntention
extends SelfTargetingIntention<KtExpression> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        return ktExpression instanceof KtPrefixExpression ? OperatorToFunctionIntention.Companion.isApplicablePrefix((KtPrefixExpression)element3, caretOffset) : (ktExpression instanceof KtPostfixExpression ? OperatorToFunctionIntention.Companion.isApplicablePostfix((KtPostfixExpression)element3, caretOffset) : (ktExpression instanceof KtBinaryExpression ? OperatorToFunctionIntention.Companion.isApplicableBinary((KtBinaryExpression)element3, caretOffset) : (ktExpression instanceof KtArrayAccessExpression ? OperatorToFunctionIntention.Companion.isApplicableArrayAccess((KtArrayAccessExpression)element3, caretOffset) : (ktExpression instanceof KtCallExpression ? OperatorToFunctionIntention.Companion.isApplicableCall((KtCallExpression)element3, caretOffset) : false))));
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Companion.convert(element3);
    }

    public OperatorToFunctionIntention() {
        super(KtExpression.class, "Replace overloaded operator with function call", null, 4, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention$Companion;", "", "()V", "convert", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "element", "convertArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "convertBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "convertCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "convertPostFix", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "convertPrefix", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "findCallName", "result", "isApplicableArrayAccess", "", "caretOffset", "", "isApplicableBinary", "isApplicableCall", "isApplicablePostfix", "isApplicablePrefix", "isAssignmentLeftSide", "idea-core"})
    public static final class Companion {
        private final boolean isApplicablePrefix(KtPrefixExpression element3, int caretOffset) {
            KtSimpleNameExpression opRef;
            KtSimpleNameExpression ktSimpleNameExpression = opRef = element3.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"opRef");
            if (!ktSimpleNameExpression.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            IElementType iElementType = opRef.getReferencedNameElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSPLUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSMINUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCL));
        }

        private final boolean isApplicablePostfix(KtPostfixExpression element3, int caretOffset) {
            KtSimpleNameExpression opRef;
            KtSimpleNameExpression ktSimpleNameExpression = opRef = element3.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"opRef");
            if (!ktSimpleNameExpression.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            if (element3.getBaseExpression() == null) {
                return false;
            }
            IElementType iElementType = opRef.getReferencedNameElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSPLUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSMINUS));
        }

        private final boolean isApplicableBinary(KtBinaryExpression element3, int caretOffset) {
            boolean bl;
            block8: {
                KtOperationReferenceExpression opRef;
                KtOperationReferenceExpression ktOperationReferenceExpression = opRef = element3.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"opRef");
                if (!ktOperationReferenceExpression.getTextRange().containsOffset(caretOffset)) {
                    return false;
                }
                IElementType iElementType = opRef.getReferencedNameElementType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MUL)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIV)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERC)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.RANGE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MULTEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIVEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERCEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
                    Iterable $receiver$iv = CollectionsKt.listOf((Object[])new KtExpression[]{element3.getLeft(), element3.getRight()});
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            KtExpression it = (KtExpression)element$iv;
                            KtExpression ktExpression = it;
                            if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ktExpression.getNode()) != null ? ktExpression.getElementType() : null), (Object)((Object)KtNodeTypes.NULL))) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                } else {
                    bl = Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQ)) ? element3.getLeft() instanceof KtArrayAccessExpression : false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isApplicableArrayAccess(KtArrayAccessExpression element3, int caretOffset) {
            PsiElement psiElement2 = element3.getLeftBracket();
            if (psiElement2 == null) return false;
            PsiElement lbracket = psiElement2;
            PsiElement psiElement3 = element3.getRightBracket();
            if (psiElement3 == null) return false;
            PsiElement rbracket = psiElement3;
            ReferenceAccess access = ReferenceUtilKt.readWriteAccess(element3, true);
            if (access == ReferenceAccess.READ_WRITE) {
                return false;
            }
            PsiElement psiElement4 = lbracket;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"lbracket");
            if (psiElement4.getTextRange().containsOffset(caretOffset)) return true;
            PsiElement psiElement5 = rbracket;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"rbracket");
            if (!psiElement5.getTextRange().containsOffset(caretOffset)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isApplicableCall(KtCallExpression element3, int caretOffset) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            UserDataHolder userDataHolder;
            KtValueArgumentList ktValueArgumentList = element3.getValueArgumentList();
            if (ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.getLeftParenthesis()) != null) {
                userDataHolder = (UserDataHolder)ktValueArgumentList;
            } else {
                List<KtLambdaArgument> list2 = element3.getLambdaArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.lambdaArguments");
                KtElement ktElement = (KtLambdaArgument)CollectionsKt.firstOrNull(list2);
                userDataHolder = (UserDataHolder)(ktElement != null && (ktElement = ((KtLambdaArgument)ktElement).getLambdaExpression()) != null ? ((KtLambdaExpression)ktElement).getLeftCurlyBrace() : null);
            }
            if (userDataHolder == null) return false;
            if (userDataHolder == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
            }
            PsiElement lbrace = (PsiElement)userDataHolder;
            if (!lbrace.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = ResolutionUtils.resolveToCall(element3, BodyResolveMode.FULL);
            CallableDescriptor descriptor2 = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            if (!(descriptor2 instanceof FunctionDescriptor)) return false;
            if (!Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            if (element3.getParent() instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = element3.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)OperatorNameConventions.INVOKE.asString())) {
                    return false;
                }
            }
            if (element3.getValueArgumentList() != null) return true;
            List<KtLambdaArgument> list3 = element3.getLambdaArguments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.lambdaArguments");
            Collection collection = list3;
            if (collection.isEmpty()) return false;
            return true;
        }

        private final KtExpression convertPrefix(KtPrefixExpression element3) {
            Name name2;
            IElementType op = element3.getOperationReference().getReferencedNameElementType();
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS))) {
                name2 = OperatorNameConventions.UNARY_PLUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS))) {
                name2 = OperatorNameConventions.UNARY_MINUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSPLUS))) {
                name2 = OperatorNameConventions.INC;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSMINUS))) {
                name2 = OperatorNameConventions.DEC;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCL))) {
                name2 = OperatorNameConventions.NOT;
            } else {
                return element3;
            }
            Name operatorName = name2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element3.getBaseExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0.$1()", objectArray, false, 4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final KtExpression convertPostFix(KtPostfixExpression element3) {
            Name name2;
            IElementType op = element3.getOperationReference().getReferencedNameElementType();
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSPLUS))) {
                name2 = OperatorNameConventions.INC;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSMINUS))) {
                name2 = OperatorNameConventions.DEC;
            } else {
                return element3;
            }
            Name operatorName = name2;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element3.getBaseExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0.$1()", objectArray, false, 4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final KtExpression convertBinary(KtBinaryExpression element3) {
            String string;
            IElementType op = element3.getOperationReference().getReferencedNameElementType();
            KtExpression ktExpression = element3.getLeft();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression left = ktExpression;
            KtExpression ktExpression2 = element3.getRight();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            KtExpression right = ktExpression2;
            if (Intrinsics.areEqual((Object)op, (Object)((Object)KtTokens.EQ))) {
                if (left instanceof KtArrayAccessExpression) {
                    this.convertArrayAccess((KtArrayAccessExpression)left);
                }
                return element3;
            }
            BindingContext context = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
            ResolvedCall<? extends CallableDescriptor> functionCandidate = CallUtilKt.getResolvedCall(element3, context);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = functionCandidate;
            String functionName2 = String.valueOf(resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getCandidateDescriptor()) != null ? resolvedCall2.getName() : null);
            KotlinType elemType = context.getType(left);
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUS))) {
                string = "$0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUS))) {
                string = "$0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MUL))) {
                string = "$0.times($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIV))) {
                string = "$0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERC))) {
                string = "$0.rem($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.RANGE))) {
                string = "$0.rangeTo($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD))) {
                string = "$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN))) {
                string = "!$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PLUSEQ))) {
                string = Intrinsics.areEqual((Object)functionName2, (Object)"plusAssign") ? "$0.plusAssign($1)" : "$0 = $0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MINUSEQ))) {
                string = Intrinsics.areEqual((Object)functionName2, (Object)"minusAssign") ? "$0.minusAssign($1)" : "$0 = $0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.MULTEQ))) {
                string = Intrinsics.areEqual((Object)functionName2, (Object)"multAssign") ? "$0.multAssign($1)" : "$0 = $0.mult($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.DIVEQ))) {
                string = Intrinsics.areEqual((Object)functionName2, (Object)"divAssign") ? "$0.divAssign($1)" : "$0 = $0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.PERCEQ))) {
                boolean remSupported = PlatformKt.getLanguageVersionSettings(element3).supportsFeature(LanguageFeature.OperatorRem);
                string = remSupported && Intrinsics.areEqual((Object)functionName2, (Object)"remAssign") ? "$0.remAssign($1)" : (Intrinsics.areEqual((Object)functionName2, (Object)"modAssign") ? "$0.modAssign($1)" : (remSupported ? "$0 = $0.rem($1)" : "$0 = $0.mod($1)"));
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "$0?.equals($1) ?: ($1 == null)" : "$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "!($0?.equals($1) ?: ($1 == null))" : "!$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
                string = "$0.compareTo($1) > 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
                string = "$0.compareTo($1) < 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
                string = "$0.compareTo($1) >= 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
                string = "$0.compareTo($1) <= 0";
            } else {
                return element3;
            }
            String pattern = string;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression3 = left;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"left");
            objectArray[0] = ktExpression3;
            KtExpression ktExpression4 = right;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"right");
            objectArray[1] = ktExpression4;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, pattern, objectArray, false, 4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        /*
         * WARNING - void declaration
         */
        private final KtExpression convertArrayAccess(KtArrayAccessExpression element3) {
            void expressionToReplace;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = element3;
            KtExpression transformed2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(element3, (Ref.ObjectRef)expressionToReplace){
                final /* synthetic */ KtArrayAccessExpression $element;
                final /* synthetic */ Ref.ObjectRef $expressionToReplace;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendExpression(this.$element.getArrayExpression());
                    $receiver.appendFixedText(".");
                    if (org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention$Companion.access$isAssignmentLeftSide(OperatorToFunctionIntention.Companion, this.$element)) {
                        PsiElement parent2;
                        PsiElement psiElement2 = parent2 = this.$element.getParent();
                        if (psiElement2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                        }
                        this.$expressionToReplace.element = (KtBinaryExpression)psiElement2;
                        $receiver.appendFixedText("set(");
                        List<KtExpression> list2 = this.$element.getIndexExpressions();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($receiver, list2, null, 2, null);
                        $receiver.appendFixedText(",");
                        $receiver.appendExpression(((KtBinaryExpression)parent2).getRight());
                    } else {
                        $receiver.appendFixedText("get(");
                        List<KtExpression> list3 = this.$element.getIndexExpressions();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($receiver, list3, null, 2, null);
                    }
                    $receiver.appendFixedText(")");
                }
                {
                    this.$element = ktArrayAccessExpression;
                    this.$expressionToReplace = objectRef;
                    super(1);
                }
            }, 1, null);
            PsiElement psiElement2 = ((KtExpression)expressionToReplace.element).replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final boolean isAssignmentLeftSide(KtArrayAccessExpression element3) {
            PsiElement parent2 = element3.getParent();
            return parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationReference().getReferencedNameElementType(), (Object)((Object)KtTokens.EQ)) && Intrinsics.areEqual((Object)element3, (Object)((KtBinaryExpression)parent2).getLeft());
        }

        private final KtExpression convertCall(KtCallExpression element3) {
            KtCallExpression callExpression2;
            KtExpression ktExpression = element3.getCalleeExpression();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression callee = ktExpression;
            KtValueArgumentList arguments2 = element3.getValueArgumentList();
            Object object = arguments2;
            String argumentString = object != null && (object = object.getText()) != null ? StringsKt.removeSurrounding((String)object, (CharSequence)"(", (CharSequence)")") : null;
            List<KtLambdaArgument> funcLitArgs = element3.getLambdaArguments();
            KtExpression ktExpression2 = callee;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"callee");
            String calleeText = ktExpression2.getText();
            String transformation = calleeText + '.' + OperatorNameConventions.INVOKE.asString() + (argumentString == null ? "()" : '(' + argumentString + ')');
            KtExpression transformed2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression(transformation);
            KtExpression ktExpression3 = CallUtilKt.getCalleeExpressionIfAny(transformed2);
            Object object2 = ktExpression3 != null ? ktExpression3.getParent() : null;
            if (!(object2 instanceof KtCallExpression)) {
                object2 = null;
            }
            if ((callExpression2 = (KtCallExpression)object2) != null) {
                List<KtLambdaArgument> list2 = funcLitArgs;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"funcLitArgs");
                Iterable $receiver$iv = list2;
                for (Object element$iv : $receiver$iv) {
                    KtLambdaArgument it = (KtLambdaArgument)element$iv;
                    callExpression2.add((PsiElement)it);
                }
                if (argumentString == null) {
                    KtValueArgumentList ktValueArgumentList = callExpression2.getValueArgumentList();
                    if (ktValueArgumentList != null) {
                        ktValueArgumentList.delete();
                    }
                }
            }
            PsiElement psiElement2 = callee.getParent().replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        @NotNull
        public final Pair<KtExpression, KtSimpleNameExpression> convert(@NotNull KtExpression element3) {
            KtExpression ktExpression;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtExpression elementToBeReplaced = element3;
            if (element3 instanceof KtArrayAccessExpression && this.isAssignmentLeftSide((KtArrayAccessExpression)element3)) {
                PsiElement psiElement2 = ((KtArrayAccessExpression)element3).getParent();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                elementToBeReplaced = (KtExpression)psiElement2;
            }
            CommentSaver commentSaver = new CommentSaver((PsiElement)elementToBeReplaced, true);
            KtExpression ktExpression2 = element3;
            if (ktExpression2 instanceof KtPrefixExpression) {
                ktExpression = this.convertPrefix((KtPrefixExpression)element3);
            } else if (ktExpression2 instanceof KtPostfixExpression) {
                ktExpression = this.convertPostFix((KtPostfixExpression)element3);
            } else if (ktExpression2 instanceof KtBinaryExpression) {
                ktExpression = this.convertBinary((KtBinaryExpression)element3);
            } else if (ktExpression2 instanceof KtArrayAccessExpression) {
                ktExpression = this.convertArrayAccess((KtArrayAccessExpression)element3);
            } else if (ktExpression2 instanceof KtCallExpression) {
                ktExpression = this.convertCall((KtCallExpression)element3);
            } else {
                throw (Throwable)new IllegalArgumentException(element3.toString());
            }
            KtExpression result2 = ktExpression;
            CommentSaver.restore$default(commentSaver, (PsiElement)result2, false, 2, null);
            KtSimpleNameExpression ktSimpleNameExpression = this.findCallName(result2);
            if (ktSimpleNameExpression == null) {
                String string = "No call name found in " + result2.getText();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KtSimpleNameExpression callName = ktSimpleNameExpression;
            return TuplesKt.to((Object)result2, (Object)callName);
        }

        private final KtSimpleNameExpression findCallName(KtExpression result2) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtExpression ktExpression = result2;
            if (ktExpression instanceof KtBinaryExpression) {
                if (KtPsiUtil.isAssignment((PsiElement)result2)) {
                    KtExpression ktExpression2 = ((KtBinaryExpression)result2).getRight();
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"result.right!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression2);
                } else {
                    KtExpression ktExpression3 = ((KtBinaryExpression)result2).getLeft();
                    if (ktExpression3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"result.left!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression3);
                }
            } else if (ktExpression instanceof KtUnaryExpression) {
                KtExpression ktExpression4 = ((KtUnaryExpression)result2).getBaseExpression();
                if (ktExpression4 != null) {
                    KtExpression ktExpression5;
                    KtExpression it;
                    KtExpression ktExpression6 = it = (ktExpression5 = ktExpression4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression6);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else if (ktExpression instanceof KtParenthesizedExpression) {
                KtExpression ktExpression7 = ((KtParenthesizedExpression)result2).getExpression();
                if (ktExpression7 != null) {
                    KtExpression ktExpression8;
                    KtExpression it;
                    KtExpression ktExpression9 = it = (ktExpression8 = ktExpression7);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression9, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression9);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else {
                ktSimpleNameExpression = (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector(result2);
            }
            return ktSimpleNameExpression;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isAssignmentLeftSide(Companion $this, @NotNull KtArrayAccessExpression element3) {
            return $this.isAssignmentLeftSide(element3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

