/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.MovePropertyToConstructorIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014*\u00060\u0014j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0002H\u0002J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u001eH\u0002J\u001c\u0010 \u001a\n \u0015*\u0004\u0018\u00010\u00180\u0018*\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\f\u0010#\u001a\u00020\u0010*\u00020!H\u0002J\f\u0010$\u001a\u00020\u0010*\u00020%H\u0002J\f\u0010&\u001a\u00020\u0018*\u00020'H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyTo", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "appendWithSpaceBefore", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "Lkotlin/text/StringBuilder;", "str", "", "findConstructorParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getModifiers", "", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "getModifiersText", "getTextWithUseSiteIfMissing", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "useSite", "isApplicableToConstructorParameter", "isValidInConstructor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "render", "Lorg/jetbrains/kotlin/types/KotlinType;", "idea"})
public final class MovePropertyToConstructorIntention
extends SelfTargetingIntention<KtProperty>
implements LocalQuickFix {
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) {
            return;
        }
        KtProperty property2 = ktProperty;
        this.applyTo(property2, (Editor)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        isApplicableTo.1 isDeclaredInClass$ = isApplicableTo.1.INSTANCE;
        if (element3.isLocal()) return false;
        if (element3.hasDelegate()) return false;
        if (element3.getGetter() != null) return false;
        if (element3.getSetter() != null) return false;
        if (element3.hasModifier(KtTokens.LATEINIT_KEYWORD)) return false;
        if (!isDeclaredInClass$.invoke(element3)) return false;
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) return true;
        boolean bl = this.isValidInConstructor(ktExpression);
        if (!bl) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor) {
        String propertyAnnotationsText2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)element3, KtClass.class);
        if (ktClass2 == null) {
            return;
        }
        KtClass parentClass2 = ktClass2;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null);
        KtClass ktClass3 = parentClass2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktClass3, (String)"parentClass");
        KtPrimaryConstructor primaryConstructor2 = KtClassKt.createPrimaryConstructorIfAbsent(ktClass3);
        KtParameter constructorParameter = this.findConstructorParameter(element3);
        CommentSaver commentSaver = new CommentSaver(element3, false, 2, null);
        Object object = element3.getModifierList();
        String string = object != null && (object = ((KtModifierList)object).getAnnotationEntries()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<KtAnnotationEntry, CharSequence>(this){
            final /* synthetic */ MovePropertyToConstructorIntention this$0;

            @NotNull
            public final CharSequence invoke(KtAnnotationEntry it) {
                CharSequence charSequence;
                KtAnnotationEntry ktAnnotationEntry = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"it");
                if (MovePropertyToConstructorIntention.access$isApplicableToConstructorParameter(this.this$0, ktAnnotationEntry)) {
                    String string = MovePropertyToConstructorIntention.access$getTextWithUseSiteIfMissing(this.this$0, it, AnnotationUseSiteTarget.FIELD.getRenderName());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.getTextWithUseSiteIfM\u2026eTarget.FIELD.renderName)");
                    charSequence = string;
                } else {
                    String string = it.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
                    charSequence = string;
                }
                return charSequence;
            }
            {
                this.this$0 = movePropertyToConstructorIntention;
                super(1);
            }
        }), (int)30, null) : (propertyAnnotationsText2 = null);
        if (constructorParameter != null) {
            Object object2;
            Object object3;
            Object it;
            Object p1;
            Object object4;
            Object p12;
            Object object5;
            StringBuilder stringBuilder;
            Object object6 = constructorParameter.getModifierList();
            String parameterAnnotationsText2 = object6 != null && (object6 = ((KtModifierList)object6).getAnnotationEntries()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object6), (CharSequence)" ", null, null, (int)0, null, (Function1)applyTo.parameterAnnotationsText.1.INSTANCE, (int)30, null) : null;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            Object object7 = element3.getModifierList();
            if (object7 != null && (object7 = this.getModifiersText((KtModifierList)object7)) != null) {
                object5 = object7;
                StringBuilder stringBuilder2 = $receiver;
                p12 = object5;
                stringBuilder2.append((String)p12);
            }
            if ((object4 = propertyAnnotationsText2) != null && (object4 = !StringsKt.isBlank((CharSequence)(p12 = (CharSequence)(p1 = (object5 = object4)))) ? object5 : null) != null) {
                it = object5 = object4;
                this.appendWithSpaceBefore($receiver, (String)it);
            }
            String string2 = parameterAnnotationsText2;
            if (string2 != null) {
                it = object5 = string2;
                this.appendWithSpaceBefore($receiver, (String)it);
            }
            if (constructorParameter.isVarArg()) {
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VARARG_KEYWORD;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"VARARG_KEYWORD");
                String string3 = ktModifierKeywordToken.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VARARG_KEYWORD.value");
                this.appendWithSpaceBefore($receiver, string3);
            }
            PsiElement psiElement2 = element3.getValOrVarKeyword();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.valOrVarKeyword");
            String string4 = psiElement2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.valOrVarKeyword.text");
            this.appendWithSpaceBefore($receiver, string4);
            String string5 = element3.getName();
            if (string5 != null) {
                Object object8 = it = (object5 = string5);
                Intrinsics.checkExpressionValueIsNotNull((Object)object8, (String)"it");
                this.appendWithSpaceBefore($receiver, (String)object8);
            }
            if ((object3 = constructorParameter.getTypeReference()) != null && (object3 = object3.getText()) != null) {
                it = object5 = object3;
                $receiver.append(": " + (String)it);
            }
            if ((object2 = constructorParameter.getDefaultValue()) != null && (object2 = object2.getText()) != null) {
                it = object5 = object2;
                $receiver.append(" = " + (String)it);
            }
            String string6 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"StringBuilder().apply(builderAction).toString()");
            String parameterText = string6;
            StringBuilder stringBuilder3 = $receiver = (stringBuilder = constructorParameter.replace(factory2.createParameter(parameterText)));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"this");
            CommentSaver.restore$default(commentSaver, (PsiElement)stringBuilder3, false, 2, null);
        } else {
            Object p1;
            Object object9;
            Object p13;
            Object it;
            Object $i$a$1$apply;
            Object object10;
            Object object11 = element3.getTypeReference();
            if (object11 == null || (object11 = object11.getText()) == null) {
                Annotated annotated;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                object11 = (annotated = (PropertyDescriptor)declarationDescriptor) != null && (annotated = annotated.getType()) != null ? this.render((KotlinType)annotated) : null;
            }
            if (object11 == null) {
                return;
            }
            Object typeText = object11;
            Object $receiver = object10 = new StringBuilder();
            Object object12 = element3.getModifierList();
            if (object12 != null && (object12 = this.getModifiersText((KtModifierList)object12)) != null) {
                $i$a$1$apply = object12;
                it = $receiver;
                p13 = $i$a$1$apply;
                ((StringBuilder)it).append((String)p13);
            }
            if ((object9 = propertyAnnotationsText2) != null && (object9 = !StringsKt.isBlank((CharSequence)(p13 = (CharSequence)(p1 = ($i$a$1$apply = object9)))) ? $i$a$1$apply : null) != null) {
                it = $i$a$1$apply = object9;
                this.appendWithSpaceBefore((StringBuilder)$receiver, (String)it);
            }
            PsiElement psiElement3 = element3.getValOrVarKeyword();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.valOrVarKeyword");
            String string7 = psiElement3.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"element.valOrVarKeyword.text");
            this.appendWithSpaceBefore((StringBuilder)$receiver, string7);
            String string8 = element3.getName();
            if (string8 != null) {
                Object object13 = it = ($i$a$1$apply = string8);
                Intrinsics.checkExpressionValueIsNotNull((Object)object13, (String)"it");
                this.appendWithSpaceBefore((StringBuilder)$receiver, (String)object13);
            }
            this.appendWithSpaceBefore((StringBuilder)$receiver, ": " + (String)typeText);
            Object object14 = element3.getInitializer();
            if (object14 != null && (object14 = object14.getText()) != null) {
                it = $i$a$1$apply = object14;
                ((StringBuilder)$receiver).append(" = " + (String)it);
            }
            String string9 = ((StringBuilder)object10).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"StringBuilder().apply(builderAction).toString()");
            String parameterText = string9;
            KtElementImplStub ktElementImplStub = primaryConstructor2.getValueParameterList();
            if (ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.addParameter(factory2.createParameter(parameterText))) != null) {
                Object object15 = $receiver = (object10 = ktElementImplStub);
                Intrinsics.checkExpressionValueIsNotNull((Object)object15, (String)"this");
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)object15, null, 2, null);
                CommentSaver.restore$default(commentSaver, (PsiElement)$receiver, false, 2, null);
            }
        }
        element3.delete();
    }

    private final KtParameter findConstructorParameter(@NotNull KtProperty $receiver) {
        KtExpression ktExpression = $receiver.getInitializer();
        if (!(ktExpression instanceof KtReferenceExpression)) {
            ktExpression = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression reference2 = ktReferenceExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(reference2, null, 1, null);
        Object object = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(object instanceof ParameterDescriptor)) {
            object = null;
        }
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
        if (parameterDescriptor == null) {
            return null;
        }
        ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
        SourceElement sourceElement = parameterDescriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"parameterDescriptor.source");
        PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
        if (!(psiElement2 instanceof KtParameter)) {
            psiElement2 = null;
        }
        return (KtParameter)psiElement2;
    }

    private final boolean isApplicableToConstructorParameter(@NotNull KtAnnotationEntry $receiver) {
        AnnotationDescriptor descriptor2;
        BindingContext context = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, $receiver);
        if (annotationDescriptor == null) {
            return false;
        }
        AnnotationDescriptor annotationDescriptor2 = descriptor2 = annotationDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotationDescriptor2, (String)"descriptor");
        Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationDescriptor2);
        return applicableTargets.contains((Object)KotlinTarget.VALUE_PARAMETER);
    }

    private final String getTextWithUseSiteIfMissing(@NotNull KtAnnotationEntry $receiver, String useSite) {
        String string;
        if ($receiver.getUseSiteTarget() == null) {
            KtTypeReference ktTypeReference = $receiver.getTypeReference();
            String string2 = ktTypeReference != null ? ktTypeReference.getText() : null;
            StringBuilder stringBuilder = new StringBuilder().append('@').append(useSite).append(':');
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            KtValueArgumentList ktValueArgumentList = $receiver.getValueArgumentList();
            string2 = ktValueArgumentList != null ? ktValueArgumentList.getText() : null;
            stringBuilder = stringBuilder.append(string4);
            String string5 = string2;
            if (string5 == null) {
                string5 = "";
            }
            string4 = string5;
            string = stringBuilder.append(string4).toString();
        } else {
            string = $receiver.getText();
        }
        return string;
    }

    private final String render(@NotNull KotlinType $receiver) {
        return IdeDescriptorRenderers.SOURCE_CODE.renderType($receiver);
    }

    private final String getModifiersText(@NotNull KtModifierList $receiver) {
        return CollectionsKt.joinToString$default((Iterable)this.getModifiers($receiver), (CharSequence)" ", null, null, (int)0, null, (Function1)getModifiersText.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> getModifiers(@NotNull KtModifierList $receiver) {
        Object $receiver$iv$iv;
        ASTNode[] aSTNodeArray = $receiver.getNode().getChildren(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"node.getChildren(null)");
        Object $receiver$iv = aSTNodeArray;
        ASTNode[] aSTNodeArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (ASTNode element$iv$iv : $receiver$iv$iv) {
            void it;
            void v1 = it = element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!(v1.getElementType() instanceof KtModifierKeywordToken)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            ASTNode element$iv$iv;
            Object item$iv$iv = iterator2.next();
            element$iv$iv = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            PsiElement psiElement2 = v2.getPsi();
            collection.add(psiElement2);
        }
        return (List)destination$iv$iv;
    }

    private final StringBuilder appendWithSpaceBefore(@NotNull StringBuilder $receiver, String str) {
        return $receiver.append(' ' + str);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidInConstructor(@NotNull KtExpression $receiver) {
        void isValid2;
        PsiElement $receiver$iv = (PsiElement)$receiver;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)true);
        if (ktClass2 == null) {
            return false;
        }
        KtClass containingClass = ktClass2;
        $receiver$iv = new Ref.BooleanRef();
        $receiver$iv.element = true;
        $receiver.accept(new KtVisitorVoid(containingClass, (Ref.BooleanRef)isValid2){
            final /* synthetic */ KtClass $containingClass;
            final /* synthetic */ Ref.BooleanRef $isValid;

            public void visitKtElement(@NotNull KtElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                element3.acceptChildren(this);
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<D> resolvedCall2 = ResolutionUtils.resolveToCall$default(expression2, null, 1, null);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall<D> declarationDescriptor = resolvedCall2;
                if (Intrinsics.areEqual((Object)declarationDescriptor.getContainingDeclaration(), (Object)UtilsKt.getDescriptor(this.$containingClass))) {
                    this.$isValid.element = false;
                }
            }
            {
                this.$containingClass = $captured_local_variable$0;
                this.$isValid = $captured_local_variable$1;
            }
        });
        return isValid2.element;
    }

    public MovePropertyToConstructorIntention() {
        super(KtProperty.class, "Move to constructor", null, 4, null);
    }

    public static final /* synthetic */ boolean access$isApplicableToConstructorParameter(MovePropertyToConstructorIntention $this, @NotNull KtAnnotationEntry $receiver) {
        return $this.isApplicableToConstructorParameter($receiver);
    }

    public static final /* synthetic */ String access$getTextWithUseSiteIfMissing(MovePropertyToConstructorIntention $this, @NotNull KtAnnotationEntry $receiver, @NotNull String useSite) {
        return $this.getTextWithUseSiteIfMissing($receiver, useSite);
    }
}

