/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IndentRawStringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class IndentRawStringIntention
extends SelfTargetingIntention<KtStringTemplateExpression> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = element3.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        if (KtPsiUtilKt.getQualifiedExpressionForReceiver(element3) != null) {
            return false;
        }
        KtStringTemplateEntry[] entries2 = element3.getEntries();
        if (entries2.length <= 1) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)entries2, (String)"entries");
        KtStringTemplateEntry[] $receiver$iv = entries2;
        int n = $receiver$iv.length;
        int n2 = 0;
        while (n2 < n) {
            KtStringTemplateEntry element$iv;
            KtStringTemplateEntry it;
            KtStringTemplateEntry ktStringTemplateEntry = it = (element$iv = $receiver$iv[n2]);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"it");
            String string2 = ktStringTemplateEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.text");
            if (StringsKt.startsWith$default((String)string2, (String)" ", (boolean)false, (int)2, null)) return false;
            String string3 = it.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.text");
            if (StringsKt.startsWith$default((String)string3, (String)"\t", (boolean)false, (int)2, null)) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor) {
        StringBuilder stringBuilder;
        KtFile file2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtFile ktFile = file2 = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        Project project = ktFile.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettingsManager, (String)"CodeStyleSettingsManager.getInstance(project)");
        CommonCodeStyleSettings.IndentOptions indentOptions = codeStyleSettingsManager.getCurrentSettings().getIndentOptions((FileType)KotlinFileType.INSTANCE);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiFile psiFile = (PsiFile)file2;
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.parent");
        String string = codeStyleManager.getLineIndent(psiFile, PsiUtilsKt.getStartOffset(psiElement2));
        if (string == null) {
            string = "";
        }
        String parentIndent = string;
        String indent = indentOptions.USE_TAB_CHARACTER ? parentIndent + '\t' : parentIndent + StringsKt.repeat((CharSequence)" ", (int)indentOptions.INDENT_SIZE);
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        int maxIndex = element3.getEntries().length - 1;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntryArray, (String)"element.entries");
        KtStringTemplateEntry[] $receiver$iv = ktStringTemplateEntryArray;
        int index$iv = 0;
        for (KtStringTemplateEntry item$iv : $receiver$iv) {
            void entry;
            int n = index$iv++;
            KtStringTemplateEntry ktStringTemplateEntry = item$iv;
            int index2 = n;
            if (index2 == 0) {
                $receiver.append('\n' + indent);
            }
            void v8 = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"entry");
            $receiver.append(v8.getText());
            if (Intrinsics.areEqual((Object)entry.getText(), (Object)"\n")) {
                $receiver.append(indent);
            }
            if (index2 != maxIndex) continue;
            $receiver.append('\n' + indent);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String newString = string2;
        element3.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression("\"\"\"" + newString + "\"\"\".trimIndent()"));
    }

    public IndentRawStringIntention() {
        super(KtStringTemplateExpression.class, "Indent raw string", null, 4, null);
    }
}

