/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertTwoComparisonsToRangeCheckIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J:\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J2\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010!\u001a\u00020\u0010*\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020\u0010*\u00020\u001dH\u0002J\f\u0010#\u001a\u00020\u0010*\u00020\u001dH\u0002J\f\u0010$\u001a\u00020\u0010*\u00020\rH\u0002J\u000e\u0010%\u001a\u00020\u0010*\u0004\u0018\u00010\u001dH\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTwoComparisonsToRangeCheckIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRangeExpressionData", "Lorg/jetbrains/kotlin/idea/intentions/ConvertTwoComparisonsToRangeCheckIntention$RangeExpressionData;", "condition", "firstLess", "Lorg/jetbrains/kotlin/psi/KtExpression;", "firstGreater", "firstStrict", "", "secondLess", "secondGreater", "secondStrict", "value", "min", "max", "incrementMinByOne", "decrementMaxByOne", "getDoubleConstant", "", "intExpr", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isApplicableTo", "isComparable", "isFloatingPoint", "isInteger", "isSimple", "isValidTypeForIncrementDecrementByOne", "RangeExpressionData", "idea"})
public final class ConvertTwoComparisonsToRangeCheckIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.generateRangeExpressionData(element3) != null;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        RangeExpressionData rangeExpressionData = this.generateRangeExpressionData(element3);
        if (rangeExpressionData == null) {
            return;
        }
        RangeExpressionData rangeData = rangeExpressionData;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 in $1..$2", new Object[]{rangeData.getValue(), factory2.createExpression(rangeData.getMin()), factory2.createExpression(rangeData.getMax())}, false, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    private final RangeExpressionData generateRangeExpressionData(KtBinaryExpression condition2) {
        void secondLess;
        void firstLess;
        if (Intrinsics.areEqual((Object)condition2.getOperationToken(), (Object)((Object)KtTokens.ANDAND)) ^ true) {
            return null;
        }
        KtExpression ktExpression = condition2.getLeft();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression firstCondition = ktBinaryExpression;
        KtExpression ktExpression2 = condition2.getRight();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression2 == null) {
            return null;
        }
        KtBinaryExpression secondCondition = ktBinaryExpression2;
        IElementType firstOpToken = firstCondition.getOperationToken();
        IElementType secondOpToken = secondCondition.getOperationToken();
        KtExpression ktExpression3 = firstCondition.getLeft();
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression firstLeft = ktExpression3;
        KtExpression ktExpression4 = firstCondition.getRight();
        if (ktExpression4 == null) {
            return null;
        }
        KtExpression firstRight = ktExpression4;
        KtExpression ktExpression5 = secondCondition.getLeft();
        if (ktExpression5 == null) {
            return null;
        }
        KtExpression secondLeft = ktExpression5;
        KtExpression ktExpression6 = secondCondition.getRight();
        if (ktExpression6 == null) {
            return null;
        }
        KtExpression secondRight = ktExpression6;
        generateRangeExpressionData.1 isStrictComparison$ = generateRangeExpressionData.1.INSTANCE;
        IElementType iElementType = firstOpToken;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"firstOpToken");
        boolean firstStrict = isStrictComparison$.invoke(iElementType);
        IElementType iElementType2 = secondOpToken;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"secondOpToken");
        boolean secondStrict = isStrictComparison$.invoke(iElementType2);
        generateRangeExpressionData.2 orderLessAndGreater$ = generateRangeExpressionData.2.INSTANCE;
        KtExpression ktExpression7 = firstLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"firstLeft");
        KtExpression ktExpression8 = firstRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression8, (String)"firstRight");
        Pair<KtExpression, KtExpression> pair2 = orderLessAndGreater$.invoke(firstOpToken, ktExpression7, ktExpression8);
        if (pair2 == null) {
            return null;
        }
        Object object = pair2;
        KtExpression ktExpression9 = (KtExpression)object.component1();
        KtExpression firstGreater = (KtExpression)object.component2();
        KtExpression ktExpression10 = secondLeft;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression10, (String)"secondLeft");
        KtExpression ktExpression11 = secondRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression11, (String)"secondRight");
        Pair<KtExpression, KtExpression> pair3 = orderLessAndGreater$.invoke(secondOpToken, ktExpression10, ktExpression11);
        if (pair3 == null) {
            return null;
        }
        Pair<KtExpression, KtExpression> pair4 = pair3;
        object = (KtExpression)pair4.component1();
        KtExpression secondGreater = (KtExpression)pair4.component2();
        return this.generateRangeExpressionData((KtExpression)firstLess, firstGreater, firstStrict, (KtExpression)secondLess, secondGreater, secondStrict);
    }

    private final boolean isSimple(@NotNull KtExpression $receiver) {
        return $receiver instanceof KtConstantExpression || $receiver instanceof KtNameReferenceExpression;
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression firstLess, KtExpression firstGreater, boolean firstStrict, KtExpression secondLess, KtExpression secondGreater, boolean secondStrict) {
        return !(firstGreater instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstGreater, secondLess) ? this.generateRangeExpressionData(firstGreater, firstLess, secondGreater, firstStrict, secondStrict) : (!(firstLess instanceof KtConstantExpression) && IfThenUtilsKt.evaluatesTo(firstLess, secondGreater) ? this.generateRangeExpressionData(firstLess, secondLess, firstGreater, secondStrict, firstStrict) : null);
    }

    private final RangeExpressionData generateRangeExpressionData(KtExpression value2, KtExpression min, KtExpression max, boolean incrementMinByOne, boolean decrementMaxByOne) {
        Function3<KtExpression, BindingContext, Integer, String> getChangeBy$ = new Function3<KtExpression, BindingContext, Integer, String>(this){
            final /* synthetic */ ConvertTwoComparisonsToRangeCheckIntention this$0;

            @Nullable
            public final String invoke(@NotNull KtExpression $receiver, @NotNull BindingContext context, int number) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                KotlinType kotlinType = CallUtilKt.getType($receiver, context);
                if (kotlinType == null) {
                    return null;
                }
                KotlinType type2 = kotlinType;
                if (!ConvertTwoComparisonsToRangeCheckIntention.access$isValidTypeForIncrementDecrementByOne(this.this$0, type2)) {
                    return null;
                }
                KtExpression ktExpression = $receiver;
                if (ktExpression instanceof KtConstantExpression) {
                    String string;
                    CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant($receiver, context);
                    if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.getValue(type2)) == null) {
                        return null;
                    }
                    CompileTimeConstant<?> constantValue = compileTimeConstant;
                    if (KotlinBuiltIns.isInt(type2)) {
                        CompileTimeConstant<?> compileTimeConstant2 = constantValue;
                        if (compileTimeConstant2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        string = String.valueOf((Integer)((Object)compileTimeConstant2) + number);
                    } else if (KotlinBuiltIns.isLong(type2)) {
                        CompileTimeConstant<?> compileTimeConstant3 = constantValue;
                        if (compileTimeConstant3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                        }
                        string = String.valueOf((Long)((Object)compileTimeConstant3) + (long)number);
                    } else if (KotlinBuiltIns.isChar(type2)) {
                        CompileTimeConstant<?> compileTimeConstant4 = constantValue;
                        if (compileTimeConstant4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Char");
                        }
                        string = "" + '\'' + (char)(((Character)((Object)compileTimeConstant4)).charValue() + number) + '\'';
                    } else {
                        return null;
                    }
                    return string;
                }
                return number >= 0 ? '(' + $receiver.getText() + " + " + number + ')' : '(' + $receiver.getText() + " - " + -number + ')';
            }
            {
                this.this$0 = convertTwoComparisonsToRangeCheckIntention;
                super(3);
            }
        };
        if (!this.isSimple(min) || !this.isSimple(max)) {
            return null;
        }
        BindingContext context = ResolutionUtils.analyze$default(value2, null, 1, null);
        KotlinType valType = CallUtilKt.getType(value2, context);
        KotlinType minType = CallUtilKt.getType(min, context);
        KotlinType maxType = CallUtilKt.getType(max, context);
        if (valType == null || minType == null || maxType == null) {
            return null;
        }
        if (!this.isComparable(valType)) {
            return null;
        }
        KtExpression minVal = min;
        KtExpression maxVal = max;
        if (Intrinsics.areEqual((Object)minType, (Object)valType) ^ true || Intrinsics.areEqual((Object)maxType, (Object)valType) ^ true) {
            if (TypeUtilsKt.isPrimitiveNumberType(valType) && TypeUtilsKt.isPrimitiveNumberType(minType) && TypeUtilsKt.isPrimitiveNumberType(maxType)) {
                if (KotlinBuiltIns.isChar(valType) || KotlinBuiltIns.isChar(minType) || KotlinBuiltIns.isChar(maxType)) {
                    return null;
                }
                if (this.isFloatingPoint(valType)) {
                    if (this.isInteger(minType)) {
                        String string = this.getDoubleConstant(min, minType, context);
                        if (string == null) {
                            return null;
                        }
                        minVal = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)minVal, false, 2, null).createExpression(string);
                    }
                    if (this.isInteger(maxType)) {
                        String string = this.getDoubleConstant(max, maxType, context);
                        if (string == null) {
                            return null;
                        }
                        maxVal = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)maxVal, false, 2, null).createExpression(string);
                    }
                }
            } else {
                return null;
            }
        }
        if ((incrementMinByOne || decrementMaxByOne) && !this.isValidTypeForIncrementDecrementByOne(valType)) {
            return null;
        }
        String minText = incrementMinByOne ? getChangeBy$.invoke(minVal, context, 1) : minVal.getText();
        String maxText = decrementMaxByOne ? getChangeBy$.invoke(maxVal, context, -1) : maxVal.getText();
        String string = minText;
        if (string == null) {
            return null;
        }
        String string2 = maxText;
        if (string2 == null) {
            return null;
        }
        return new RangeExpressionData(value2, string, string2);
    }

    private final String getDoubleConstant(KtExpression intExpr, KotlinType type2, BindingContext context) {
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(intExpr, context);
        if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.getValue(type2)) == null) {
            return null;
        }
        CompileTimeConstant<?> intConst = compileTimeConstant;
        CompileTimeConstant<?> compileTimeConstant2 = intConst;
        if (!(compileTimeConstant2 instanceof Number)) {
            compileTimeConstant2 = null;
        }
        Number number = (Number)((Object)compileTimeConstant2);
        return number != null ? String.valueOf(number.doubleValue()) : null;
    }

    private final boolean isComparable(@NotNull KotlinType $receiver) {
        return DescriptorUtils.isSubtypeOfClass($receiver, TypeUtilsKt.getBuiltIns($receiver).getComparable());
    }

    private final boolean isFloatingPoint(@NotNull KotlinType $receiver) {
        return KotlinBuiltIns.isFloat($receiver) || KotlinBuiltIns.isDouble($receiver);
    }

    private final boolean isInteger(@NotNull KotlinType $receiver) {
        return KotlinBuiltIns.isInt($receiver) || KotlinBuiltIns.isLong($receiver) || KotlinBuiltIns.isShort($receiver) || KotlinBuiltIns.isByte($receiver);
    }

    private final boolean isValidTypeForIncrementDecrementByOne(@Nullable KotlinType $receiver) {
        if ($receiver == null) {
            return false;
        }
        return this.isInteger($receiver) || KotlinBuiltIns.isChar($receiver);
    }

    public ConvertTwoComparisonsToRangeCheckIntention() {
        super(KtBinaryExpression.class, "Convert to range check", null, 4, null);
    }

    public static final /* synthetic */ boolean access$isValidTypeForIncrementDecrementByOne(ConvertTwoComparisonsToRangeCheckIntention $this, @Nullable KotlinType $receiver) {
        return $this.isValidTypeForIncrementDecrementByOne($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTwoComparisonsToRangeCheckIntention$RangeExpressionData;", "", "value", "Lorg/jetbrains/kotlin/psi/KtExpression;", "min", "", "max", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Ljava/lang/String;)V", "getMax", "()Ljava/lang/String;", "getMin", "getValue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "idea"})
    private static final class RangeExpressionData {
        @NotNull
        private final KtExpression value;
        @NotNull
        private final String min;
        @NotNull
        private final String max;

        @NotNull
        public final KtExpression getValue() {
            return this.value;
        }

        @NotNull
        public final String getMin() {
            return this.min;
        }

        @NotNull
        public final String getMax() {
            return this.max;
        }

        public RangeExpressionData(@NotNull KtExpression value2, @NotNull String min, @NotNull String max) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)min, (String)"min");
            Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
            this.value = value2;
            this.min = min;
            this.max = max;
        }

        @NotNull
        public final KtExpression component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.min;
        }

        @NotNull
        public final String component3() {
            return this.max;
        }

        @NotNull
        public final RangeExpressionData copy(@NotNull KtExpression value2, @NotNull String min, @NotNull String max) {
            Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)min, (String)"min");
            Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
            return new RangeExpressionData(value2, min, max);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RangeExpressionData copy$default(RangeExpressionData rangeExpressionData, KtExpression ktExpression, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                ktExpression = rangeExpressionData.value;
            }
            if ((n & 2) != 0) {
                string = rangeExpressionData.min;
            }
            if ((n & 4) != 0) {
                string2 = rangeExpressionData.max;
            }
            return rangeExpressionData.copy(ktExpression, string, string2);
        }

        public String toString() {
            return "RangeExpressionData(value=" + this.value + ", min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            KtExpression ktExpression = this.value;
            String string = this.min;
            String string2 = this.max;
            return ((ktExpression != null ? ktExpression.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RangeExpressionData)) break block3;
                    RangeExpressionData rangeExpressionData = (RangeExpressionData)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)rangeExpressionData.value) || !Intrinsics.areEqual((Object)this.min, (Object)rangeExpressionData.min) || !Intrinsics.areEqual((Object)this.max, (Object)rangeExpressionData.max)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

