/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ConvertSealedClassToEnumIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertSealedClassToEnumIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClass;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processClass", "klass", "subclasses", "", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "showError", "message", "", "elements", "idea"})
public final class ConvertSealedClassToEnumIntention
extends SelfTargetingRangeIntention<KtClass> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClass element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement2;
        KtModifierList ktModifierList = element3.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.SEALED_KEYWORD)) == null) {
            return null;
        }
        KtModifierList sealedKeyword = ktModifierList;
        ClassDescriptor classDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (DescriptorUtilsKt.getSuperClassNotAny(classDescriptor2) != null) {
            return null;
        }
        KtModifierList ktModifierList2 = sealedKeyword;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList2, (String)"sealedKeyword");
        int n = PsiUtilsKt.getStartOffset((PsiElement)ktModifierList2);
        PsiElement psiElement3 = nameIdentifier;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nameIdentifier");
        return new TextRange(n, PsiUtilsKt.getEndOffset(psiElement3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtClass element3, @Nullable Editor editor) {
        void $receiver$iv$iv;
        Collection $receiver$iv$iv2;
        Iterable $receiver$iv;
        KtClass ktClass2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Project project = element3.getProject();
        KtDeclaration ktDeclaration = ExpectActualUtilKt.liftToExpected(element3);
        if (!(ktDeclaration instanceof KtClass)) {
            ktDeclaration = null;
        }
        if ((ktClass2 = (KtClass)ktDeclaration) == null) {
            ktClass2 = element3;
        }
        KtClass klass2 = ktClass2;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List list2 = (List)ProgressUtilKt.runSynchronouslyWithProgress(project2, "Searching inheritors...", true, (Function0)new Function0<List<? extends PsiElement>>(klass2){
            final /* synthetic */ KtClass $klass;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PsiElement> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                PsiElement psiElement2 = this.$klass;
                SearchScope searchScope2 = this.$klass.getUseScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)searchScope2, (String)"klass.useScope");
                Iterable iterable = $receiver$iv = (Iterable)ClassInheritorsSearchKt.searchInheritors(new HierarchySearchRequest<PsiElement>(psiElement2, searchScope2, false));
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement psiElement3;
                    PsiClass it;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    PsiClass psiClass2 = it = (PsiClass)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"it");
                    if (LightClassUtilsKt.getUnwrapped((PsiElement)psiClass2) == null) continue;
                    PsiElement it$iv$iv = psiElement3;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)var3_3;
            }
            {
                this.$klass = ktClass2;
                super(0);
            }
        });
        if (list2 == null) {
            return;
        }
        List subclasses2 = list2;
        Iterable iterable = $receiver$iv = (Iterable)subclasses2;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            Object object;
            Object object2;
            PsiElement it = (PsiElement)element$iv$iv;
            if (!(it instanceof KtObjectDeclaration)) {
                object2 = null;
            } else if (((KtObjectDeclaration)it).getSuperTypeListEntries().size() != 1) {
                object2 = null;
            } else {
                KtClass containingClass;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)it);
                if (!(ktClassOrObject instanceof KtClass)) {
                    ktClassOrObject = null;
                }
                object2 = (KtClass)ktClassOrObject == null ? null : (Intrinsics.areEqual((Object)containingClass, (Object)klass2) ^ true && Intrinsics.areEqual((Object)ExpectActualUtilKt.liftToExpected(containingClass), (Object)klass2) ^ true ? null : containingClass);
            }
            KtClass key$iv$iv = object2;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map subclassesByContainer = destination$iv$iv;
        List list3 = (List)subclassesByContainer.get(null);
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List inconvertibleSubclasses = list3;
        $receiver$iv$iv2 = inconvertibleSubclasses;
        if (!$receiver$iv$iv2.isEmpty()) {
            this.showError("All inheritors must be nested objects of the class itself and may not inherit from other classes or interfaces.\n", inconvertibleSubclasses, project, editor);
            return;
        }
        Set set2 = subclassesByContainer.keySet();
        if (set2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.psi.KtClass>");
        }
        Iterable $receiver$iv2 = set2;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtClass it = (KtClass)element$iv$iv;
            if (!(!it.isSealed())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonSealedClasses = (List)destination$iv$iv2;
        Object object = nonSealedClasses;
        if (!object.isEmpty()) {
            this.showError("All expected and actual classes must be sealed classes.\n", nonSealedClasses, project, editor);
            return;
        }
        object = subclassesByContainer;
        if (!object.isEmpty()) {
            subclassesByContainer.forEach((BiConsumer)new BiConsumer<KtClass, List<? extends PsiElement>>(this, project){
                final /* synthetic */ ConvertSealedClassToEnumIntention this$0;
                final /* synthetic */ Project $project;

                public final void accept(@Nullable KtClass currentClass, @NotNull List<? extends PsiElement> currentSubclasses) {
                    Intrinsics.checkParameterIsNotNull(currentSubclasses, (String)"currentSubclasses");
                    KtClass ktClass2 = currentClass;
                    if (ktClass2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktClass2, (String)"currentClass!!");
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    ConvertSealedClassToEnumIntention.access$processClass(this.this$0, ktClass2, currentSubclasses, project);
                }
                {
                    this.this$0 = convertSealedClassToEnumIntention;
                    this.$project = project;
                }
            });
        } else {
            this.processClass(klass2, CollectionsKt.emptyList(), project);
        }
    }

    private final void showError(String message2, List<? extends PsiElement> elements2, Project project, Editor editor) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(message2);
        $receiver.append("Following problems are found:\n");
        CollectionsKt.joinTo$default((Iterable)elements2, (Appendable)$receiver, null, null, null, (int)0, null, (Function1)showError.errorText.1.1.INSTANCE, (int)62, null);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String errorText2 = string;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorText2, (String)this.getText(), null);
    }

    /*
     * WARNING - void declaration
     */
    private final void processClass(KtClass klass2, List<? extends PsiElement> subclasses2, Project project) {
        block18: {
            PsiElement semicolon2;
            boolean needSemicolon;
            block17: {
                void $receiver$iv$iv;
                void $receiver$iv;
                Object element$iv2;
                KtEnumEntry ktEnumEntry;
                KtEnumEntry subclass;
                Collection collection;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Collection collection2;
                needSemicolon = klass2.getDeclarations().size() > subclasses2.size();
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default(klass2, false, 2, null);
                PsiElement comma = psiFactory.createComma();
                semicolon2 = psiFactory.createSemicolon();
                boolean constructorCallNeeded = klass2.hasExplicitPrimaryConstructor() || !(collection2 = (Collection)klass2.getSecondaryConstructors()).isEmpty();
                Iterable iterable = $receiver$iv2 = (Iterable)subclasses2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                int index$iv$iv = 0;
                Iterator iterator2 = $receiver$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    void i;
                    String entryText;
                    Object item$iv$iv = iterator2.next();
                    int n = index$iv$iv++;
                    PsiElement psiElement2 = (PsiElement)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    void v1 = subclass;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtObjectDeclaration");
                    }
                    KtObjectDeclaration cfr_ignored_0 = (KtObjectDeclaration)v1;
                    StringBuilder stringBuilder = new StringBuilder();
                    Object $receiver = stringBuilder;
                    ((StringBuilder)$receiver).append(((KtObjectDeclaration)((Object)subclass)).getName());
                    if (constructorCallNeeded) {
                        Object object;
                        Object object2 = CollectionsKt.firstOrNull(((KtObjectDeclaration)((Object)subclass)).getSuperTypeListEntries());
                        if (!(object2 instanceof KtSuperTypeCallEntry)) {
                            object2 = null;
                        }
                        if ((object = (KtSuperTypeCallEntry)object2) == null || (object = ((KtSuperTypeCallEntry)object).getValueArgumentList()) == null || (object = object.getText()) == null) {
                            object = "()";
                        }
                        ((StringBuilder)$receiver).append((String)object);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                    KtEnumEntry entry = psiFactory.createEnumEntry(entryText);
                    KtClassBody ktClassBody = ((KtObjectDeclaration)((Object)subclass)).getBody();
                    if (ktClassBody != null) {
                        Object body2 = $receiver = ktClassBody;
                        entry.add((PsiElement)body2);
                    }
                    if (i < CollectionsKt.getLastIndex(subclasses2)) {
                        entry.add(comma);
                    } else if (needSemicolon) {
                        entry.add(semicolon2);
                    }
                    ktEnumEntry = entry;
                    collection.add(ktEnumEntry);
                }
                List entriesToAdd = (List)destination$iv$iv;
                $receiver$iv2 = subclasses2;
                for (Object element$iv2 : $receiver$iv2) {
                    PsiElement it = (PsiElement)element$iv2;
                    it.delete();
                }
                klass2.removeModifier(KtTokens.SEALED_KEYWORD);
                klass2.addModifier(KtTokens.ENUM_KEYWORD);
                $receiver$iv2 = entriesToAdd;
                if (!(!$receiver$iv2.isEmpty())) break block17;
                $receiver$iv$iv2 = CollectionsKt.reversed((Iterable)entriesToAdd);
                element$iv2 = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    KtEnumEntry ktEnumEntry2;
                    void it;
                    void this_$iv;
                    subclass = (KtEnumEntry)item$iv$iv;
                    collection = destination$iv$iv2;
                    KtClass i = klass2;
                    Object anchor$iv = null;
                    if ((PsiElement)CollectionsKt.firstOrNull(this_$iv.getDeclarations()) == null) {
                        void this_$iv$iv = this_$iv;
                        KtClassBody body$iv$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv$iv);
                        PsiElement psiElement3 = body$iv$iv.getRBrace();
                        if (psiElement3 == null && (psiElement3 = body$iv$iv.getLastChild()) == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiElement anchor$iv$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement3, (Class[])new Class[]{PsiWhiteSpace.class});
                        PsiElement psiElement4 = body$iv$iv.addAfter((KtDeclaration)it, anchor$iv$iv);
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
                        }
                        ktEnumEntry2 = (KtEnumEntry)psiElement4;
                    } else {
                        PsiElement anchorAfter$iv;
                        PsiElement psiElement5 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv).addBefore((KtDeclaration)it, anchorAfter$iv);
                        if (psiElement5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEnumEntry");
                        }
                        ktEnumEntry2 = (KtEnumEntry)psiElement5;
                    }
                    ktEnumEntry = ktEnumEntry2;
                    collection.add(ktEnumEntry);
                }
                KtEnumEntry firstEntry = (KtEnumEntry)CollectionsKt.last((List)((List)destination$iv$iv2));
                firstEntry.getParent().addBefore(psiFactory.createNewLine(), (PsiElement)firstEntry);
                break block18;
            }
            if (!needSemicolon) break block18;
            KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull(klass2.getDeclarations());
            if (ktDeclaration != null) {
                KtDeclaration ktDeclaration2;
                KtDeclaration anchor2 = ktDeclaration2 = ktDeclaration;
                PsiElement delimiter = anchor2.getParent().addBefore(semicolon2, (PsiElement)anchor2);
                CodeStyleManager.getInstance((Project)project).reformat(delimiter);
            }
        }
    }

    public ConvertSealedClassToEnumIntention() {
        super(KtClass.class, "Convert to enum class", null, 4, null);
    }

    public static final /* synthetic */ void access$processClass(ConvertSealedClassToEnumIntention $this, @NotNull KtClass klass2, @NotNull List subclasses2, @NotNull Project project) {
        $this.processClass(klass2, subclasses2, project);
    }
}

