/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.AbstractProcessableUsageInfo;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionTypeParameterToReceiverIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertFunctionTypeParameterToReceiverIntention$Converter$checkThisExpressionsAreExplicatable$;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoring;
import org.jetbrains.kotlin.idea.refactoring.CallableRefactoringKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinImplicitThisToParameterUsageKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinIntroduceVariableHandler;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "getConversionData", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "ConversionData", "Converter", "FunctionDefinitionInfo", "InternalReferencePassInfo", "LambdaInfo", "ParameterCallInfo", "idea"})
public final class ConvertFunctionTypeParameterToReceiverIntention
extends SelfTargetingRangeIntention<KtTypeReference> {
    /*
     * WARNING - void declaration
     */
    private final ConversionData getConversionData(@NotNull KtTypeReference $receiver) {
        void $receiver$iv;
        PsiElement psiElement2 = $receiver.getParent();
        if (!(psiElement2 instanceof KtParameter)) {
            psiElement2 = null;
        }
        KtParameter ktParameter = (KtParameter)psiElement2;
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        PsiElement psiElement3 = parameter;
        Function1 branch$iv = getConversionData.functionType.1.INSTANCE;
        boolean strict$iv = false;
        void $receiver$iv$iv = $receiver$iv;
        PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtFunctionType.class, (boolean)strict$iv);
        KtFunctionType ktFunctionType = (KtFunctionType)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, (PsiElement)$receiver$iv, branch$iv) : null);
        if (ktFunctionType == null) {
            return null;
        }
        KtFunctionType functionType2 = ktFunctionType;
        if (functionType2.getReceiverTypeReference() != null) {
            return null;
        }
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(functionType2, ResolutionUtils.analyze(functionType2, BodyResolveMode.PARTIAL));
        if (kotlinType == null) {
            return null;
        }
        KotlinType lambdaType = kotlinType;
        PsiElement psiElement5 = functionType2.getParent();
        if (!(psiElement5 instanceof KtTypeReference)) {
            psiElement5 = null;
        }
        KtTypeReference ktTypeReference = (KtTypeReference)psiElement5;
        Object object = ktTypeReference != null ? ktTypeReference.getParent() : null;
        if (!(object instanceof KtParameter)) {
            object = null;
        }
        KtParameter ktParameter2 = (KtParameter)object;
        if (ktParameter2 == null) {
            return null;
        }
        KtParameter containingParameter = ktParameter2;
        KtDeclarationWithBody ktDeclarationWithBody = containingParameter.getOwnerFunction();
        if (!(ktDeclarationWithBody instanceof KtFunction)) {
            ktDeclarationWithBody = null;
        }
        KtFunction ktFunction = (KtFunction)ktDeclarationWithBody;
        if (ktFunction == null) {
            return null;
        }
        KtFunction ownerFunction = ktFunction;
        int typeParameterIndex = functionType2.getParameters().indexOf(parameter);
        int functionParameterIndex = ownerFunction.getValueParameters().indexOf(containingParameter);
        return new ConversionData(typeParameterIndex, functionParameterIndex, lambdaType, ownerFunction);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtTypeReference element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ConversionData conversionData = this.getConversionData(element3);
        if (conversionData == null) {
            return null;
        }
        ConversionData data = conversionData;
        KtParameter ktParameter = data.getFunction().getValueParameters().get(data.getFunctionParameterIndex());
        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"data.function.valueParam\u2026a.functionParameterIndex]");
        KtTypeReference ktTypeReference = ktParameter.getTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeElement ktTypeElement = ktTypeReference.getTypeElement();
        if (ktTypeElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunctionType");
        }
        KtFunctionType elementBefore = (KtFunctionType)ktTypeElement;
        PsiElement psiElement2 = PsiModificationUtilsKt.copied((PsiElement)elementBefore);
        KtFunctionType $receiver = (KtFunctionType)psiElement2;
        TypeRefHelpersKt.setReceiverTypeReference($receiver, element3);
        KtParameterList ktParameterList = $receiver.getParameterList();
        if (ktParameterList == null) {
            Intrinsics.throwNpe();
        }
        ktParameterList.removeParameter(data.getTypeParameterIndex());
        KtFunctionType elementAfter = (KtFunctionType)psiElement2;
        this.setText("Convert '" + elementBefore.getText() + "' to '" + elementAfter.getText() + '\'');
        return element3.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtTypeReference element3, @Nullable Editor editor) {
        block0: {
            ConversionData conversionData;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            ConversionData conversionData2 = this.getConversionData(element3);
            if (conversionData2 == null) break block0;
            ConversionData it = conversionData = conversionData2;
            new Converter(it).run();
        }
    }

    public ConvertFunctionTypeParameterToReceiverIntention() {
        super(KtTypeReference.class, "Convert function type parameter to receiver", null, 4, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$FunctionDefinitionInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class FunctionDefinitionInfo
    extends AbstractProcessableUsageInfo<KtFunction, ConversionData> {
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            KtParameterList functionTypeParameterList;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtFunction ktFunction = (KtFunction)this.getElement();
            if (ktFunction == null) {
                return;
            }
            KtFunction function2 = ktFunction;
            List<KtParameter> list2 = function2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.valueParameters");
            KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)data.getFunctionParameterIndex());
            if (ktParameter == null) {
                return;
            }
            KtParameter functionParameter = ktParameter;
            KtTypeReference ktTypeReference = functionParameter.getTypeReference();
            KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(ktTypeElement instanceof KtFunctionType)) {
                ktTypeElement = null;
            }
            KtFunctionType ktFunctionType = (KtFunctionType)ktTypeElement;
            if (ktFunctionType == null) {
                return;
            }
            KtFunctionType functionType2 = ktFunctionType;
            KtParameterList ktParameterList = functionType2.getParameterList();
            if (ktParameterList == null) {
                return;
            }
            KtParameterList ktParameterList2 = functionTypeParameterList = ktParameterList;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameterList2, (String)"functionTypeParameterList");
            List<KtParameter> list3 = ktParameterList2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"functionTypeParameterList.parameters");
            KtParameter ktParameter2 = (KtParameter)CollectionsKt.getOrNull(list3, (int)data.getTypeParameterIndex());
            if (ktParameter2 == null) {
                return;
            }
            KtParameter parameterToMove = ktParameter2;
            KtTypeReference ktTypeReference2 = parameterToMove.getTypeReference();
            if (ktTypeReference2 == null) {
                return;
            }
            KtTypeReference typeReferenceToMove = ktTypeReference2;
            TypeRefHelpersKt.setReceiverTypeReference(functionType2, typeReferenceToMove);
            functionTypeParameterList.removeParameter(parameterToMove);
        }

        public FunctionDefinitionInfo(@NotNull KtFunction element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ParameterCallInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class ParameterCallInfo
    extends AbstractProcessableUsageInfo<KtCallExpression, ConversionData> {
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            KtValueArgumentList argumentList2;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtCallExpression ktCallExpression = (KtCallExpression)this.getElement();
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtValueArgumentList ktValueArgumentList = callExpression2.getValueArgumentList();
            if (ktValueArgumentList == null) {
                return;
            }
            KtValueArgumentList ktValueArgumentList2 = argumentList2 = ktValueArgumentList;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgumentList2, (String)"argumentList");
            List<KtValueArgument> list2 = ktValueArgumentList2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argumentList.arguments");
            KtElement ktElement = (KtValueArgument)CollectionsKt.getOrNull(list2, (int)data.getTypeParameterIndex());
            if (ktElement == null || (ktElement = ktElement.getArgumentExpression()) == null) {
                return;
            }
            KtElement expressionToMove = ktElement;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callExpression2, false, 2, null);
            Object[] objectArray = new Object[2];
            KtElement ktElement2 = expressionToMove;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"expressionToMove");
            objectArray[0] = ktElement2;
            objectArray[1] = callExpression2;
            KtExpression ktExpression = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0.$1", objectArray, false, 4, null);
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
            }
            KtQualifiedExpression callWithReceiver = (KtQualifiedExpression)ktExpression;
            KtExpression ktExpression2 = callWithReceiver.getSelectorExpression();
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            KtValueArgumentList ktValueArgumentList3 = ((KtCallExpression)ktExpression2).getValueArgumentList();
            if (ktValueArgumentList3 == null) {
                Intrinsics.throwNpe();
            }
            ktValueArgumentList3.removeArgument(data.getTypeParameterIndex());
            callExpression2.replace((PsiElement)callWithReceiver);
        }

        public ParameterCallInfo(@NotNull KtCallExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$InternalReferencePassInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)V", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class InternalReferencePassInfo
    extends AbstractProcessableUsageInfo<KtSimpleNameExpression, ConversionData> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Object object;
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)this.getElement();
            if (ktSimpleNameExpression == null) {
                return;
            }
            KtSimpleNameExpression expression2 = ktSimpleNameExpression;
            KotlinType lambdaType = data.getLambdaType();
            CollectingNameValidator validator2 = new CollectingNameValidator(null, null, 3, null);
            Iterable iterable = CollectionsKt.dropLast(lambdaType.getArguments(), (int)1);
            void var8_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                Iterator it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                String string = (String)CollectionsKt.first(KotlinNameSuggester.INSTANCE.suggestNamesByType(kotlinType, (Function1<? super String, Boolean>)((Function1)validator2), "p"));
                collection.add(string);
            }
            List parameterNames = (List)destination$iv$iv;
            String string = (String)CollectionsKt.getOrNull((List)parameterNames, (int)data.getTypeParameterIndex());
            if (string == null) {
                return;
            }
            String receiver = string;
            Iterable $receiver$iv2 = parameterNames;
            Object object2 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)it, (Object)receiver) ^ true)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List arguments2 = (List)destination$iv$iv2;
            PsiElement $receiver$iv3 = (PsiElement)expression2;
            KtLambdaExpression adapterLambda = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null).createLambdaExpression(CollectionsKt.joinToString$default((Iterable)parameterNames, null, null, null, (int)0, null, null, (int)63, null), receiver + '.' + expression2.getText() + '(' + CollectionsKt.joinToString$default((Iterable)arguments2, null, null, null, (int)0, null, null, (int)63, null) + ')');
            PsiElement result$iv = $receiver$iv3.replace((PsiElement)adapterLambda);
            if (result$iv instanceof KtLambdaExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
                }
                object = (KtLambdaExpression)ktExpression;
            }
            object2 = object;
            KtLambdaExpression it = (KtLambdaExpression)object2;
            PsiModificationUtilsKt.moveFunctionLiteralOutsideParenthesesIfPossible(it);
        }

        public InternalReferencePassInfo(@NotNull KtSimpleNameExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$LambdaInfo;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "element", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "generateVariable", "", "expression", "process", "", "data", "elementsToShorten", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "idea"})
    public static final class LambdaInfo
    extends AbstractProcessableUsageInfo<KtExpression, ConversionData> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void process(@NotNull ConversionData data, @NotNull List<KtElement> elementsToShorten) {
            Object object;
            void $receiver$iv$iv;
            void $receiver$iv$iv2;
            Object object2;
            Collection collection;
            Object item$iv$iv;
            KtExpression $receiver$iv$iv3;
            Iterable $receiver$iv;
            KtParameter $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull(elementsToShorten, (String)"elementsToShorten");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            if (expression2 instanceof KtLambdaExpression || !(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtCallableReferenceExpression)) {
                PsiElement psiElement2 = (PsiElement)expression2;
                Function1 action$iv = (Function1)new Function1<KtThisExpression, Unit>(context, psiFactory){
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ KtPsiFactory $psiFactory;

                    public final void invoke(@NotNull KtThisExpression it) {
                        DeclarationDescriptor descriptor2;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (it.getLabelName() != null) {
                            return;
                        }
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.$context.get(BindingContext.REFERENCE_TARGET, it.getInstanceReference());
                        if (declarationDescriptor == null) {
                            return;
                        }
                        DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
                        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor");
                        it.replace((PsiElement)this.$psiFactory.createExpression(KotlinImplicitThisToParameterUsageKt.explicateReceiverOf(declarationDescriptor2)));
                    }
                    {
                        this.$context = bindingContext2;
                        this.$psiFactory = ktPsiFactory;
                        super(1);
                    }
                };
                void $receiver$iv$iv4 = $receiver$iv2;
                $receiver$iv$iv4.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        super.visitElement(element3);
                        if (element3 instanceof KtThisExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            if (expression2 instanceof KtLambdaExpression) {
                List<KtParameter> list2 = ((KtLambdaExpression)expression2).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.valueParameters");
                KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)data.getTypeParameterIndex());
                if (ktParameter != null) {
                    KtFunctionLiteral lambda2;
                    KtParameter parameterToConvert = $receiver$iv2 = ktParameter;
                    KtThisExpression thisRefExpr = psiFactory.createThisExpression();
                    Iterator $i$f$forEachDescendantOfType = ReferencesSearch.search((PsiElement)parameterToConvert, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)expression2))).iterator();
                    while ($i$f$forEachDescendantOfType.hasNext()) {
                        PsiReference ref;
                        PsiReference psiReference = ref = (PsiReference)$i$f$forEachDescendantOfType.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"ref");
                        PsiElement psiElement3 = psiReference.getElement();
                        if (!(psiElement3 instanceof KtSimpleNameExpression)) {
                            psiElement3 = null;
                        }
                        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)psiElement3;
                        if (ktSimpleNameExpression == null) continue;
                        ktSimpleNameExpression.replace((PsiElement)thisRefExpr);
                    }
                    KtFunctionLiteral ktFunctionLiteral = lambda2 = ((KtLambdaExpression)expression2).getFunctionLiteral();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambda");
                    KtParameterList ktParameterList = ktFunctionLiteral.getValueParameterList();
                    if (ktParameterList == null) {
                        Intrinsics.throwNpe();
                    }
                    ktParameterList.removeParameter(parameterToConvert);
                    if (lambda2.getValueParameters().isEmpty()) {
                        PsiElement psiElement4 = lambda2.getArrow();
                        if (psiElement4 != null) {
                            psiElement4.delete();
                        }
                    }
                }
                return;
            }
            KotlinType originalLambdaTypes = data.getLambdaType();
            Iterable $i$f$forEachDescendantOfType = $receiver$iv = (Iterable)CollectionsKt.dropLast(originalLambdaTypes.getArguments(), (int)1);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator $i$a$2$let = $receiver$iv$iv3.iterator();
            while ($i$a$2$let.hasNext()) {
                void it;
                item$iv$iv = $i$a$2$let.next();
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                object2 = it.getType();
                collection.add(object2);
            }
            List originalParameterTypes = (List)destination$iv$iv;
            $receiver$iv$iv3 = expression2;
            String calleeText = $receiver$iv$iv3 instanceof KtSimpleNameExpression ? ((KtSimpleNameExpression)expression2).getText() : ($receiver$iv$iv3 instanceof KtCallableReferenceExpression ? '(' + ((KtCallableReferenceExpression)expression2).getText() + ')' : this.generateVariable(expression2));
            CollectingNameValidator parameterNameValidator = new CollectingNameValidator(!(expression2 instanceof KtCallableReferenceExpression) ? CollectionsKt.listOf((Object)calleeText) : CollectionsKt.emptyList(), null, 2, null);
            Iterable $receiver$iv3 = originalParameterTypes;
            item$iv$iv = $receiver$iv3;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                String string;
                void i;
                int n = index$iv$iv++;
                KotlinType kotlinType = (KotlinType)item$iv$iv2;
                int n2 = n;
                collection = destination$iv$iv2;
                if (i != data.getTypeParameterIndex()) {
                    void type2;
                    void v10 = type2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"type");
                    string = (String)CollectionsKt.first(KotlinNameSuggester.INSTANCE.suggestNamesByType((KotlinType)v10, (Function1<? super String, Boolean>)((Function1)parameterNameValidator), "p"));
                } else {
                    string = "this";
                }
                object2 = string;
                collection.add(object2);
            }
            List parameterNamesWithReceiver = (List)destination$iv$iv2;
            Iterable $receiver$iv4 = parameterNamesWithReceiver;
            destination$iv$iv2 = $receiver$iv4;
            Collection destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)it, (Object)"this") ^ true)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List parameterNames = (List)destination$iv$iv3;
            KtExpression body2 = psiFactory.createExpression(CollectionsKt.joinToString$default((Iterable)parameterNamesWithReceiver, null, (CharSequence)(calleeText + '('), (CharSequence)")", (int)0, null, null, (int)57, null));
            KtExpression ktExpression2 = CreateByPatternKt.buildExpression$default(psiFactory, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(parameterNames, body2){
                final /* synthetic */ List $parameterNames;
                final /* synthetic */ KtExpression $body;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendFixedText("{ ");
                    $receiver.appendFixedText(CollectionsKt.joinToString$default((Iterable)this.$parameterNames, null, null, null, (int)0, null, null, (int)63, null));
                    $receiver.appendFixedText(" -> ");
                    $receiver.appendExpression(this.$body);
                    $receiver.appendFixedText(" }");
                }
                {
                    this.$parameterNames = list2;
                    this.$body = ktExpression;
                    super(1);
                }
            }, 1, null);
            if (ktExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
            }
            PsiElement $receiver$iv5 = (PsiElement)expression2;
            KtLambdaExpression replacingLambda2 = (KtLambdaExpression)ktExpression2;
            PsiElement result$iv = $receiver$iv5.replace((PsiElement)replacingLambda2);
            if (result$iv instanceof KtLambdaExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement5 = result$iv;
                if (psiElement5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement5).getExpression();
                if (ktExpression3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
                }
                object = (KtLambdaExpression)ktExpression3;
            }
            PsiElement psiElement6 = object;
            KtLambdaExpression it = (KtLambdaExpression)psiElement6;
            PsiModificationUtilsKt.moveFunctionLiteralOutsideParenthesesIfPossible(it);
        }

        /*
         * WARNING - void declaration
         */
        private final String generateVariable(KtExpression expression2) {
            void baseCallee;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KotlinIntroduceVariableHandler.INSTANCE.doRefactoring(project, null, expression2, false, CollectionsKt.emptyList(), (Function1<? super KtDeclaration, Unit>)((Function1)new Function1<KtDeclaration, Unit>((Ref.ObjectRef)baseCallee){
                final /* synthetic */ Ref.ObjectRef $baseCallee;

                public final void invoke(@NotNull KtDeclaration it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$baseCallee.element = string;
                }
                {
                    this.$baseCallee = objectRef;
                    super(1);
                }
            }));
            return (String)baseCallee.element;
        }

        public LambdaInfo(@NotNull KtExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            super((PsiElement)element3);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014JP\u0010\u0017\u001a\u00020\u00142\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0018\u001a\u00020\n2*\u0010\u0019\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u001b0\u001aj\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u001b`\u001cH\u0002J<\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2*\u0010\u0019\u001a&\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u001b0\u001aj\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u001b`\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$Converter;", "Lorg/jetbrains/kotlin/idea/refactoring/CallableRefactoring;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "data", "Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "(Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention;Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;)V", "checkThisExpressionsAreExplicatable", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "expressionToProcess", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getArgumentExpressionToProcess", "callElement", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "performRefactoring", "", "descriptorsForChange", "", "processExternalUsage", "refElement", "usages", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/idea/intentions/AbstractProcessableUsageInfo;", "Lkotlin/collections/ArrayList;", "processInternalUsages", "callable", "Lorg/jetbrains/kotlin/psi/KtFunction;", "idea"})
    private final class Converter
    extends CallableRefactoring<CallableDescriptor> {
        private final ConversionData data;

        @Override
        protected void performRefactoring(@NotNull Collection<? extends CallableDescriptor> descriptorsForChange) {
            Intrinsics.checkParameterIsNotNull(descriptorsForChange, (String)"descriptorsForChange");
            List<PsiElement> callables = CallableRefactoringKt.getAffectedCallables(this.getProject(), descriptorsForChange);
            MultiMap conflicts2 = new MultiMap();
            ArrayList usages2 = new ArrayList();
            ProgressUtilKt.runSynchronouslyWithProgress(this.getProject(), "Looking for usages and conflicts...", true, (Function0)new Function0<Unit>(this, callables, conflicts2, usages2){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ List $callables;
                final /* synthetic */ MultiMap $conflicts;
                final /* synthetic */ ArrayList $usages;

                public final void invoke() {
                    ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            double progressStep = 1.0 / (double)this.this$0.$callables.size();
                            boolean bl = false;
                            for (PsiElement callable2 : (Iterable)this.this$0.$callables) {
                                void i;
                                ProgressManager progressManager = ProgressManager.getInstance();
                                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                                ProgressIndicator progressIndicator = ApplicationUtilsKt.getProgressIndicatorNullable(progressManager);
                                if (progressIndicator == null) {
                                    Intrinsics.throwNpe();
                                }
                                progressIndicator.setFraction((double)(i + true) * progressStep);
                                if (callable2 instanceof PsiNamedElement) {
                                    if (!Converter.access$checkModifiable(this.this$0.this$0, callable2)) {
                                        String string = RefactoringUIUtil.getDescription((PsiElement)callable2, (boolean)true);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringUIUtil.getDescription(callable, true)");
                                        String renderedCallable = StringsKt.capitalize((String)string);
                                        this.this$0.$conflicts.putValue((Object)callable2, (Object)("Can't modify " + renderedCallable));
                                    }
                                    for (PsiReference ref : UtilsKt.searchReferencesOrMethodReferences(callable2)) {
                                        PsiElement refElement;
                                        if (ref.getElement() == null) {
                                            continue;
                                        }
                                        PsiReference psiReference = ref;
                                        if (psiReference instanceof KtSimpleReference) {
                                            Converter converter = this.this$0.this$0;
                                            MultiMap multiMap = this.this$0.$conflicts;
                                            PsiElement psiElement2 = refElement;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"refElement");
                                            Converter.access$processExternalUsage(converter, multiMap, psiElement2, this.this$0.$usages);
                                            continue;
                                        }
                                        if (psiReference instanceof KtReference || Converter.access$getData$p(this.this$0.this$0).isFirstParameter()) continue;
                                        MultiMap multiMap = this.this$0.$conflicts;
                                        StringBuilder stringBuilder = new StringBuilder().append("Can't replace non-Kotlin reference with call expression: ");
                                        PsiElement psiElement3 = refElement;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"refElement");
                                        multiMap.putValue((Object)refElement, (Object)stringBuilder.append(StringUtil.htmlEmphasize((String)psiElement3.getText())).toString());
                                    }
                                    if (callable2 instanceof KtFunction) {
                                        Collection collection = this.this$0.$usages;
                                        Object object = new FunctionDefinitionInfo((KtFunction)callable2);
                                        collection.add(object);
                                        Converter.access$processInternalUsages(this.this$0.this$0, (KtFunction)callable2, this.this$0.$usages);
                                    }
                                }
                                ++i;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.this$0 = converter;
                    this.$callables = list2;
                    this.$conflicts = multiMap;
                    this.$usages = arrayList;
                    super(0);
                }
            });
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(this.getProject(), conflicts2, null, (Function0)new Function0<Unit>(this, usages2){
                final /* synthetic */ Converter this$0;
                final /* synthetic */ ArrayList $usages;

                public final void invoke() {
                    ApplicationUtilsKt.executeWriteCommand(this.this$0.getProject(), this.this$0.ConvertFunctionTypeParameterToReceiverIntention.this.getText(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ performRefactoring.2 this$0;

                        public final void invoke() {
                            ArrayList<E> elementsToShorten = new ArrayList<E>();
                            Iterable $receiver$iv = this.this$0.$usages;
                            for (T element$iv : $receiver$iv) {
                                AbstractProcessableUsageInfo it = (AbstractProcessableUsageInfo)((Object)element$iv);
                                it.process(Converter.access$getData$p(this.this$0.this$0), (List<KtElement>)elementsToShorten);
                            }
                            ShortenReferences.process$default(ShortenReferences.DEFAULT, elementsToShorten, null, 2, null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = converter;
                    this.$usages = arrayList;
                    super(0);
                }
            }, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void processExternalUsage(MultiMap<PsiElement, String> conflicts2, PsiElement refElement, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            void $receiver$iv;
            void $receiver$iv2;
            PsiElement psiElement2 = refElement;
            Object branch$iv = processExternalUsage.callElement.1.INSTANCE;
            boolean strict$iv = false;
            void $receiver$iv$iv = $receiver$iv2;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallElement.class, (boolean)strict$iv);
            KtCallElement callElement2 = (KtCallElement)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$receiver$iv2, branch$iv) : null);
            if (callElement2 != null) {
                BindingContext context = ResolutionUtils.analyze(callElement2, BodyResolveMode.PARTIAL);
                KtExpression ktExpression = this.getArgumentExpressionToProcess(callElement2, context);
                if (ktExpression == null) {
                    return;
                }
                KtExpression expressionToProcess = ktExpression;
                if (!(this.data.isFirstParameter() || !(callElement2 instanceof KtConstructorDelegationCall) || expressionToProcess instanceof KtLambdaExpression || expressionToProcess instanceof KtSimpleNameExpression || expressionToProcess instanceof KtCallableReferenceExpression)) {
                    conflicts2.putValue((Object)expressionToProcess, (Object)("Following expression won't be processed since refactoring can't preserve its semantics: " + expressionToProcess.getText()));
                    return;
                }
                if (!this.checkThisExpressionsAreExplicatable(conflicts2, context, expressionToProcess)) {
                    return;
                }
                if (this.data.isFirstParameter() && !(expressionToProcess instanceof KtLambdaExpression)) {
                    return;
                }
                branch$iv = usages2;
                LambdaInfo $i$f$getParentOfTypeAndBranch = new LambdaInfo(expressionToProcess);
                branch$iv.add($i$f$getParentOfTypeAndBranch);
                return;
            }
            if (this.data.isFirstParameter()) {
                return;
            }
            PsiElement expressionToProcess = refElement;
            Function1 branch$iv2 = processExternalUsage.callableReference.1.INSTANCE;
            boolean strict$iv2 = false;
            void $receiver$iv$iv2 = $receiver$iv;
            PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv2, KtCallableReferenceExpression.class, (boolean)strict$iv2);
            KtCallableReferenceExpression callableReference2 = (KtCallableReferenceExpression)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, (PsiElement)$receiver$iv, branch$iv2) : null);
            if (callableReference2 != null) {
                conflicts2.putValue((Object)refElement, (Object)("Callable reference transformation is not supported: " + StringUtil.htmlEmphasize((String)callableReference2.getText())));
                return;
            }
        }

        private final KtExpression getArgumentExpressionToProcess(KtCallElement callElement2, BindingContext context) {
            KtExpression ktExpression;
            Object object = (ValueArgument)CollectionsKt.singleOrNull(ResolvedCallUtilKt.getArgumentByParameterIndex(callElement2, this.data.getFunctionParameterIndex(), context));
            if (object != null && (object = object.getArgumentExpression()) != null) {
                Object object2;
                Object it = object2 = object;
                ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)it);
            } else {
                ktExpression = null;
            }
            return ktExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean checkThisExpressionsAreExplicatable(MultiMap<PsiElement, String> conflicts2, BindingContext context, KtExpression expressionToProcess) {
            void $receiver$iv$iv$iv;
            PsiElement $receiver$iv = (PsiElement)expressionToProcess;
            Function1 predicate$iv = Converter$checkThisExpressionsAreExplicatable$$inlined$collectDescendantsOfType$1.INSTANCE;
            PsiElement $receiver$iv$iv = $receiver$iv;
            ArrayList result$iv$iv = new ArrayList();
            PsiElement psiElement2 = $receiver$iv$iv;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtThisExpression, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement it = element3;
                    super.visitElement(element3);
                    if (element3 instanceof KtThisExpression) {
                        this.$action.invoke((Object)element3);
                    }
                }
            });
            for (KtThisExpression thisExpr : (List)result$iv$iv) {
                DeclarationDescriptor descriptor2;
                if (thisExpr.getLabelName() != null) continue;
                if ((DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, thisExpr.getInstanceReference()) == null) {
                    continue;
                }
                DeclarationDescriptor declarationDescriptor = descriptor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                if (!Intrinsics.areEqual((Object)KotlinImplicitThisToParameterUsageKt.explicateReceiverOf(declarationDescriptor), (Object)"this")) continue;
                conflicts2.putValue((Object)thisExpr, (Object)("Following expression won't be processed since refactoring can't preserve its semantics: " + thisExpr.getText()));
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final void processInternalUsages(KtFunction callable2, ArrayList<AbstractProcessableUsageInfo<?, ConversionData>> usages2) {
            KtElement body2;
            KtElement ktElement;
            KtFunction ktFunction = callable2;
            if (ktFunction instanceof KtConstructor) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(callable2);
                ktElement = ktClassOrObject != null ? ktClassOrObject.getBody() : null;
            } else {
                ktElement = body2 = (KtElement)callable2.getBodyExpression();
            }
            if (body2 != null) {
                List<KtParameter> list2 = callable2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callable.valueParameters");
                KtParameter ktParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)this.data.getFunctionParameterIndex());
                if (ktParameter == null) {
                    return;
                }
                KtParameter functionParameter = ktParameter;
                Iterator iterator2 = ReferencesSearch.search((PsiElement)functionParameter, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)body2))).iterator();
                while (iterator2.hasNext()) {
                    void $receiver$iv;
                    KtSimpleNameExpression element3;
                    PsiReference ref;
                    PsiReference psiReference = ref = (PsiReference)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"ref");
                    PsiElement psiElement2 = psiReference.getElement();
                    if (!(psiElement2 instanceof KtSimpleNameExpression)) {
                        psiElement2 = null;
                    }
                    if ((KtSimpleNameExpression)psiElement2 == null) {
                        continue;
                    }
                    Object object = (PsiElement)element3;
                    Function1 branch$iv = processInternalUsages.callExpression.1.INSTANCE;
                    boolean strict$iv = false;
                    void $receiver$iv$iv = $receiver$iv;
                    PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallExpression.class, (boolean)strict$iv);
                    KtCallExpression callExpression2 = (KtCallExpression)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$receiver$iv, branch$iv) : null);
                    if (callExpression2 != null) {
                        object = usages2;
                        ParameterCallInfo parameterCallInfo = new ParameterCallInfo(callExpression2);
                        object.add(parameterCallInfo);
                        continue;
                    }
                    if (this.data.isFirstParameter()) continue;
                    object = usages2;
                    InternalReferencePassInfo internalReferencePassInfo = new InternalReferencePassInfo(element3);
                    object.add(internalReferencePassInfo);
                }
            }
        }

        public Converter(ConversionData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Project project = data.getFunction().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"data.function.project");
            super(project, (CallableDescriptor)data.getFunctionDescriptor(), ConvertFunctionTypeParameterToReceiverIntention.this.getText());
            this.data = data;
        }

        public static final /* synthetic */ boolean access$checkModifiable(Converter $this, @NotNull PsiElement element3) {
            return $this.checkModifiable(element3);
        }

        public static final /* synthetic */ void access$processExternalUsage(Converter $this, @NotNull MultiMap conflicts2, @NotNull PsiElement refElement, @NotNull ArrayList usages2) {
            $this.processExternalUsage((MultiMap<PsiElement, String>)conflicts2, refElement, usages2);
        }

        @NotNull
        public static final /* synthetic */ ConversionData access$getData$p(Converter $this) {
            return $this.data;
        }

        public static final /* synthetic */ void access$processInternalUsages(Converter $this, @NotNull KtFunction callable2, @NotNull ArrayList usages2) {
            $this.processInternalUsages(callable2, usages2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertFunctionTypeParameterToReceiverIntention$ConversionData;", "", "typeParameterIndex", "", "functionParameterIndex", "lambdaType", "Lorg/jetbrains/kotlin/types/KotlinType;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(IILorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor$delegate", "Lkotlin/Lazy;", "getFunctionParameterIndex", "()I", "isFirstParameter", "", "()Z", "getLambdaType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeParameterIndex", "idea"})
    public static final class ConversionData {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final Lazy functionDescriptor$delegate;
        private final int typeParameterIndex;
        private final int functionParameterIndex;
        @NotNull
        private final KotlinType lambdaType;
        @NotNull
        private final KtFunction function;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConversionData.class), "functionDescriptor", "getFunctionDescriptor()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;"))};
        }

        public final boolean isFirstParameter() {
            return this.typeParameterIndex == 0;
        }

        @NotNull
        public final FunctionDescriptor getFunctionDescriptor() {
            Lazy lazy = this.functionDescriptor$delegate;
            ConversionData conversionData = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (FunctionDescriptor)lazy.getValue();
        }

        public final int getTypeParameterIndex() {
            return this.typeParameterIndex;
        }

        public final int getFunctionParameterIndex() {
            return this.functionParameterIndex;
        }

        @NotNull
        public final KotlinType getLambdaType() {
            return this.lambdaType;
        }

        @NotNull
        public final KtFunction getFunction() {
            return this.function;
        }

        public ConversionData(int typeParameterIndex, int functionParameterIndex, @NotNull KotlinType lambdaType, @NotNull KtFunction function2) {
            Intrinsics.checkParameterIsNotNull((Object)lambdaType, (String)"lambdaType");
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            this.typeParameterIndex = typeParameterIndex;
            this.functionParameterIndex = functionParameterIndex;
            this.lambdaType = lambdaType;
            this.function = function2;
            this.functionDescriptor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FunctionDescriptor>(this){
                final /* synthetic */ ConversionData this$0;

                @NotNull
                public final FunctionDescriptor invoke() {
                    DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(this.this$0.getFunction(), null, 1, null);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    return (FunctionDescriptor)declarationDescriptor;
                }
                {
                    this.this$0 = conversionData;
                    super(0);
                }
            }));
        }
    }
}

