/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertArrayParameterToVarargIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class ConvertArrayParameterToVarargIntention
extends SelfTargetingIntention<KtParameter> {
    private static final String DEFAULT_TEXT = "Convert to vararg parameter";
    private static final String BREAKING_TEXT = "Convert to vararg parameter (may break code)";
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtParameter element3, int caretOffset) {
        KtTypeProjection typeProjection;
        KtTypeReference typeArgument;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3;
        KtTypeReference ktTypeReference = (KtTypeReference)PsiTreeUtil.getChildOfType((PsiElement)psiElement2, KtTypeReference.class);
        if (ktTypeReference == null) return false;
        KtTypeReference typeReference = ktTypeReference;
        PsiElement psiElement3 = element3.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.parent");
        if (psiElement3.getParent() instanceof KtFunctionLiteral) {
            return false;
        }
        if (element3.isVarArg()) {
            return false;
        }
        ValueParameterDescriptor valueParameterDescriptor = UtilsKt.getDescriptor(element3);
        Annotated annotated = valueParameterDescriptor;
        if (valueParameterDescriptor == null) return false;
        KotlinType kotlinType = annotated.getType();
        annotated = kotlinType;
        if (kotlinType == null) return false;
        Annotated annotated2 = annotated;
        if (KotlinBuiltIns.isPrimitiveArray((KotlinType)annotated2)) {
            this.setText(DEFAULT_TEXT);
            return true;
        }
        if (!KotlinBuiltIns.isArray((KotlinType)annotated2)) return false;
        Object object = typeReference.getTypeElement();
        KtTypeReference ktTypeReference2 = typeArgument = object != null && (object = object.getTypeArgumentsAsTypes()) != null ? (KtTypeReference)CollectionsKt.firstOrNull((List)object) : null;
        Object object2 = ktTypeReference2 != null ? ktTypeReference2.getParent() : null;
        if (!(object2 instanceof KtTypeProjection)) {
            object2 = null;
        }
        KtTypeProjection ktTypeProjection = typeProjection = (KtTypeProjection)object2;
        if (ktTypeProjection == null) return false;
        if (ktTypeProjection.hasModifier(KtTokens.IN_KEYWORD)) return false;
        this.setText(!typeProjection.hasModifier(KtTokens.OUT_KEYWORD) && !KotlinBuiltIns.isPrimitiveType(PlatformKt.getBuiltIns(element3).getArrayElementType((KotlinType)annotated2)) ? BREAKING_TEXT : DEFAULT_TEXT);
        return true;
    }

    @Override
    public void applyTo(@NotNull KtParameter element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement $receiver$iv = element3;
        KtTypeReference ktTypeReference = (KtTypeReference)PsiTreeUtil.getChildOfType((PsiElement)$receiver$iv, KtTypeReference.class);
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        Annotated annotated = UtilsKt.getDescriptor(element3);
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated type2 = annotated;
        Object object = KotlinBuiltIns.getPrimitiveArrayElementType((KotlinType)type2);
        if (object == null || (object = object.getTypeName()) == null || (object = ((Name)object).asString()) == null) {
            Object object2 = typeReference.getTypeElement();
            object = object2 != null && (object2 = object2.getTypeArgumentsAsTypes()) != null && (object2 = (KtTypeReference)CollectionsKt.firstOrNull((List)object2)) != null ? object2.getText() : null;
        }
        if (object == null) {
            return;
        }
        PrimitiveType newType = object;
        typeReference.replace(KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createType((String)((Object)newType)));
        element3.addModifier(KtTokens.VARARG_KEYWORD);
    }

    public ConvertArrayParameterToVarargIntention() {
        super(KtParameter.class, DEFAULT_TEXT, null, 4, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertArrayParameterToVarargIntention$Companion;", "", "()V", "BREAKING_TEXT", "", "DEFAULT_TEXT", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

