/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddLabeledReturnInLambdaIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "block", "idea"})
public final class AddLabeledReturnInLambdaIntention
extends SelfTargetingRangeIntention<KtBlockExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtBlockExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!this.isApplicableTo(element3)) {
            return null;
        }
        String string = UtilsKt.getParentLambdaLabelName(element3);
        if (string == null) {
            return null;
        }
        String labelName2 = string;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.SUSPEND_KEYWORD");
        if (Intrinsics.areEqual((Object)labelName2, (Object)ktModifierKeywordToken.getValue())) {
            return null;
        }
        this.setText("Add return@" + labelName2);
        List<KtExpression> list2 = element3.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull(list2);
        return ktExpression != null ? ktExpression.getTextRange() : null;
    }

    @Override
    public void applyTo(@NotNull KtBlockExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = UtilsKt.getParentLambdaLabelName(element3);
        if (string == null) {
            return;
        }
        String labelName2 = string;
        List<KtExpression> list2 = element3.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.statements");
        KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull(list2);
        if (ktExpression == null) {
            return;
        }
        KtExpression lastStatement = ktExpression;
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(new KtPsiFactory(project, false, 2, null), "return@" + labelName2 + " $0", new Object[]{lastStatement}, false, 4, null);
        lastStatement.replace((PsiElement)newExpression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicableTo(KtBlockExpression block) {
        List<KtExpression> list2 = block.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
        KtExpression lastStatement = (KtExpression)CollectionsKt.lastOrNull(list2);
        if (lastStatement instanceof KtReturnExpression) return false;
        KtExpression ktExpression = lastStatement;
        if (ktExpression == null) return false;
        if (!BindingContextUtilsKt.isUsedAsExpression(ktExpression, ResolutionUtils.analyze$default(lastStatement, null, 1, null))) return false;
        return true;
    }

    public AddLabeledReturnInLambdaIntention() {
        super(KtBlockExpression.class, "Add labeled return to last expression in a lambda", null, 4, null);
    }
}

