/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "MyVisitor", "VersionFinder", "idea-gradle"})
public final class DifferentStdlibGradleVersionInspection
extends GradleBaseInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor(CollectionsKt.listOf((Object[])new String[]{"kotlin-stdlib", "kotlin-stdlib-jre7", "kotlin-stdlib-jdk7", "kotlin-stdlib-jre8", "kotlin-stdlib-jdk8"}));
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return "Plugin version (" + args[0] + ") is not the same as library version (" + args[1] + ')';
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "libraryIds", "", "", "(Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "idea-gradle"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        private final List<String> libraryIds;

        protected abstract void onFound(@NotNull String var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $receiver$iv = (PsiElement)closure;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            GrExpression grExpression = dependenciesCall.getInvokedExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"dependenciesCall.invokedExpression");
            if (Intrinsics.areEqual((Object)grExpression.getText(), (Object)"dependencies") ^ true) {
                return;
            }
            if (!(dependenciesCall.getParent() instanceof PsiFile)) {
                return;
            }
            GrCallExpression grCallExpression = Companion.findLibraryStatement(closure, "org.jetbrains.kotlin", this.libraryIds);
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression stdlibStatement = grCallExpression;
            PsiFile psiFile = closure.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"closure.containingFile");
            String string = Companion.getResolvedKotlinStdlibVersion(psiFile, this.libraryIds);
            if (string == null) {
                return;
            }
            String stdlibVersion = string;
            this.onFound(stdlibVersion, stdlibStatement);
        }

        public VersionFinder(@NotNull List<String> libraryIds) {
            Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
            this.libraryIds = libraryIds;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "libraryIds", "", "", "(Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "idea-gradle"})
    private final class MyVisitor
    extends VersionFinder {
        @Override
        protected void onFound(@NotNull String stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
            Intrinsics.checkParameterIsNotNull((Object)stdlibVersion, (String)"stdlibVersion");
            Intrinsics.checkParameterIsNotNull((Object)stdlibStatement, (String)"stdlibStatement");
            PsiFile psiFile = stdlibStatement.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"stdlibStatement.containingFile");
            String gradlePluginVersion = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(psiFile);
            if (Intrinsics.areEqual((Object)stdlibVersion, (Object)gradlePluginVersion) ^ true) {
                this.registerError((PsiElement)stdlibStatement, new Object[]{gradlePluginVersion, stdlibVersion});
            }
        }

        public MyVisitor(List<String> libraryIds) {
            Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
            super(libraryIds);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$Companion;", "", "()V", "findLibraryStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "libraryGroup", "", "libraryIds", "", "getKotlinStdlibVersions", "", "gradleFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "libraryId", "getResolvedKotlinStdlibVersion", "file", "Lcom/intellij/psi/PsiFile;", "idea-gradle"})
    public static final class Companion {
        @NotNull
        public final Collection<String> getKotlinStdlibVersions(@NotNull GroovyFileBase gradleFile, @NotNull List<String> libraryId) {
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Intrinsics.checkParameterIsNotNull(libraryId, (String)"libraryId");
            LinkedHashSet versions = new LinkedHashSet();
            VersionFinder visitor2 = new VersionFinder(versions, libraryId, libraryId){
                final /* synthetic */ LinkedHashSet $versions;
                final /* synthetic */ List $libraryId;

                public void visitElement(@NotNull GroovyPsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    element3.acceptChildren((GroovyElementVisitor)this);
                }

                protected void onFound(@NotNull String stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
                    Intrinsics.checkParameterIsNotNull((Object)stdlibVersion, (String)"stdlibVersion");
                    Intrinsics.checkParameterIsNotNull((Object)stdlibStatement, (String)"stdlibStatement");
                    Collection collection = this.$versions;
                    collection.add(stdlibVersion);
                }
                {
                    this.$versions = $captured_local_variable$0;
                    this.$libraryId = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            gradleFile.accept((GroovyElementVisitor)visitor2);
            return versions;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final GrCallExpression findLibraryStatement(GrClosableBlock closure, String libraryGroup, List<String> libraryIds) {
            Object element$iv;
            Object v0;
            boolean bl;
            Iterable $receiver$iv = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleHeuristicHelper.INSTANCE.getPRODUCTION_DEPENDENCY_STATEMENTS());
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                boolean bl2;
                GrCallExpression statement2;
                block7: {
                    if (!iterator2.hasNext()) {
                        v0 = null;
                        return v0;
                    }
                    element$iv = iterator2.next();
                    statement2 = (GrCallExpression)element$iv;
                    Iterable $receiver$iv2 = libraryIds;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv2) {
                            String it = (String)element$iv2;
                            String string = statement2.getText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"statement.text");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    String string = statement2.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"statement.text");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)libraryGroup, (boolean)false, (int)2, null)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v0 = element$iv;
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getResolvedKotlinStdlibVersion(@NotNull PsiFile file2, @NotNull List<String> libraryIds) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
            DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(file2);
            if (dataNode == null) {
                return null;
            }
            DataNode<ProjectData> projectStructureNode = dataNode;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file2.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            Module module = projectRootManager.getFileIndex().getModuleForFile(file2.getVirtualFile());
            if (module == null) {
                return null;
            }
            Module module2 = module;
            Key key = ProjectKeys.MODULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.MODULE");
            Iterable iterable = $receiver$iv = (Iterable)KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                NodeWithData it = (NodeWithData)element$iv$iv;
                Object t = it.getData();
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it.data");
                String string = ((ModuleData)t).getInternalName();
                Module module3 = module2;
                Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
                if (!Intrinsics.areEqual((Object)string, (Object)module3.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (NodeWithData moduleData : (List)destination$iv$iv) {
                String string;
                String string2 = DifferentStdlibGradleVersionInspectionKt.getResolvedKotlinStdlibVersionByModuleData(moduleData.getNode(), libraryIds);
                if (string2 == null) continue;
                String it = string = string2;
                return it;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

