/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.conventionNameCalls;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.conventionNameCalls.ReplaceCallWithBinaryOperatorInspection$getWrappingPrefixExpressionIfAny$;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ConventionUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u000bH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0019*\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceCallWithBinaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionTarget", "Lorg/jetbrains/kotlin/psi/KtExpression;", "inspectionText", "isApplicable", "", "operation", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getWrappingPrefixExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "inverted", "Lcom/intellij/psi/tree/IElementType;", "idea"})
public final class ReplaceCallWithBinaryOperatorInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    private final KtSingleValueToken inverted(@NotNull IElementType $receiver) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT)) ? KtTokens.GT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT)) ? KtTokens.LT : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ)) ? KtTokens.LTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ)) ? KtTokens.GTEQ : null)));
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return false;
        }
        KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression;
        KtSingleValueToken ktSingleValueToken = this.operation(calleeExpression2);
        if (ktSingleValueToken == null) {
            return false;
        }
        KtSingleValueToken operation = ktSingleValueToken;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(element3, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
            return false;
        }
        Call call2 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        if (call2.getTypeArgumentList() != null) {
            return false;
        }
        Call call3 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call3, (String)"resolvedCall.call");
        List<? extends ValueArgument> list2 = call3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.call.valueArguments");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(argument2);
        if (argumentMapping == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch");
        }
        if (((ArgumentMatch)argumentMapping).getValueParameter().getIndex() != 0) {
            return false;
        }
        return UtilsKt.isReceiverExpressionWithValue(element3);
    }

    @NotNull
    public KtExpression inspectionTarget(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = UtilsKt.getCallExpression(element3);
        if (ktExpression == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
            ktExpression = element3;
        }
        return ktExpression;
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtDotQualifiedExpression element3) {
        KtSimpleNameExpression calleeExpression2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression2 = (KtSimpleNameExpression)ktExpression;
        Name identifier2 = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
        return Intrinsics.areEqual((Object)identifier2, (Object)OperatorNameConventions.EQUALS) || Intrinsics.areEqual((Object)identifier2, (Object)OperatorNameConventions.COMPARE_TO) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Call replaceable with binary operator";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return "Replace with binary operator";
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return this.getDefaultFixText();
        }
        KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression;
        KtSingleValueToken ktSingleValueToken = this.operation(calleeExpression2);
        if (ktSingleValueToken == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken operation = ktSingleValueToken;
        return "Replace with '" + operation.getValue() + '\'';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDotQualifiedExpression.class, (boolean)strict$iv);
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression qualifiedExpression = ktDotQualifiedExpression;
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(qualifiedExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSingleValueToken ktSingleValueToken = this.operation(ktSimpleNameExpression);
        if (ktSingleValueToken == null) {
            return;
        }
        KtSingleValueToken operation = ktSingleValueToken;
        List<KtValueArgument> list2 = callExpression2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.single(list2)).getArgumentExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression argument2 = ktExpression2;
        KtExpression receiver = qualifiedExpression.getReceiverExpression();
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)qualifiedExpression, false, 2, null);
        KtSingleValueToken ktSingleValueToken2 = operation;
        if (Intrinsics.areEqual((Object)((Object)ktSingleValueToken2), (Object)((Object)KtTokens.EXCLEQ))) {
            KtPrefixExpression ktPrefixExpression = this.getWrappingPrefixExpressionIfAny((PsiElement)qualifiedExpression);
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            Object[] objectArray = new Object[2];
            objectArray[0] = receiver;
            KtExpression ktExpression3 = argument2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"argument");
            objectArray[1] = ktExpression3;
            KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 != $1", objectArray, false, 4, null);
            prefixExpression.replace((PsiElement)newExpression2);
        } else if (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)ktSingleValueToken2)) {
            PsiElement psiElement3 = qualifiedExpression.getParent();
            if (!(psiElement3 instanceof KtBinaryExpression)) {
                psiElement3 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression binaryParent = ktBinaryExpression;
            String string = "$0 " + operation.getValue() + " $1";
            Object[] objectArray = new Object[2];
            objectArray[0] = receiver;
            KtExpression ktExpression4 = argument2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"argument");
            objectArray[1] = ktExpression4;
            KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
            binaryParent.replace((PsiElement)newExpression3);
        } else {
            String string = "$0 " + operation.getValue() + " $1";
            Object[] objectArray = new Object[2];
            objectArray[0] = receiver;
            KtExpression ktExpression5 = argument2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"argument");
            objectArray[1] = ktExpression5;
            KtExpression newExpression4 = CreateByPatternKt.createExpressionByPattern$default(factory2, string, objectArray, false, 4, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedExpression.replace((PsiElement)newExpression4), (String)"qualifiedExpression.replace(newExpression)");
        }
    }

    private final KtPrefixExpression getWrappingPrefixExpressionIfAny(@NotNull PsiElement $receiver) {
        PsiElement $receiver$iv = $receiver;
        Object object = SequencesKt.lastOrNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents($receiver$iv), (Function1)getWrappingPrefixExpressionIfAny$$inlined$getLastParentOfTypeInRow$1.INSTANCE));
        if (!(object instanceof KtParenthesizedExpression)) {
            object = null;
        }
        KtParenthesizedExpression ktParenthesizedExpression = (KtParenthesizedExpression)object;
        PsiElement psiElement2 = (ktParenthesizedExpression != null ? (PsiElement)ktParenthesizedExpression : $receiver).getParent();
        if (!(psiElement2 instanceof KtPrefixExpression)) {
            psiElement2 = null;
        }
        return (KtPrefixExpression)psiElement2;
    }

    private final KtSingleValueToken operation(KtSimpleNameExpression calleeExpression2) {
        KtSingleValueToken ktSingleValueToken;
        Name identifier2 = calleeExpression2.getReferencedNameAsName();
        PsiElement psiElement2 = calleeExpression2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"calleeExpression.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtDotQualifiedExpression)) {
            psiElement3 = null;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement3;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression dotQualified = ktDotQualifiedExpression;
        Name name2 = identifier2;
        if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS)) {
            if (!ConventionUtilsKt.isAnyEquals(dotQualified)) {
                return null;
            }
            KtPrefixExpression prefixExpression = this.getWrappingPrefixExpressionIfAny((PsiElement)dotQualified);
            ktSingleValueToken = prefixExpression != null && Intrinsics.areEqual((Object)prefixExpression.getOperationToken(), (Object)((Object)KtTokens.EXCL)) ? KtTokens.EXCLEQ : KtTokens.EQEQ;
        } else if (Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.COMPARE_TO)) {
            KtExpression ktExpression;
            PsiElement psiElement4 = dotQualified.getParent();
            if (!(psiElement4 instanceof KtBinaryExpression)) {
                psiElement4 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement4;
            if (ktBinaryExpression == null) {
                return null;
            }
            KtBinaryExpression binaryParent = ktBinaryExpression;
            KtExpression ktExpression2 = binaryParent.getRight();
            if (Intrinsics.areEqual((Object)(ktExpression2 != null ? ktExpression2.getText() : null), (Object)"0")) {
                ktExpression = binaryParent.getLeft();
            } else {
                KtExpression ktExpression3 = binaryParent.getLeft();
                if (Intrinsics.areEqual((Object)(ktExpression3 != null ? ktExpression3.getText() : null), (Object)"0")) {
                    ktExpression = binaryParent.getRight();
                } else {
                    return null;
                }
            }
            KtExpression notZero = ktExpression;
            if (Intrinsics.areEqual((Object)notZero, (Object)dotQualified) ^ true) {
                return null;
            }
            IElementType iElementType = binaryParent.getOperationToken();
            if (!(iElementType instanceof KtSingleValueToken)) {
                iElementType = null;
            }
            KtSingleValueToken ktSingleValueToken2 = (KtSingleValueToken)iElementType;
            if (ktSingleValueToken2 == null) {
                return null;
            }
            KtSingleValueToken token = ktSingleValueToken2;
            ktSingleValueToken = OperatorConventions.COMPARISON_OPERATIONS.contains((Object)token) ? (Intrinsics.areEqual((Object)notZero, (Object)binaryParent.getLeft()) ? token : this.inverted(token)) : null;
        } else {
            ktSingleValueToken = (KtSingleValueToken)((Object)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get((Object)identifier2));
        }
        return ktSingleValueToken;
    }

    public ReplaceCallWithBinaryOperatorInspection() {
        super(KtDotQualifiedExpression.class);
    }
}

