/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.UnnecessaryVariableInspection$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "startFixInWriteAction", "", "getStartFixInWriteAction", "()Z", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionTarget", "inspectionText", "isApplicable", "Companion", "idea"})
public final class UnnecessaryVariableInspection
extends AbstractApplicabilityBasedInspection<KtProperty> {
    @NotNull
    private final String defaultFixText = "Inline variable";
    private final boolean startFixInWriteAction = false;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicable(@NotNull KtProperty element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return UnnecessaryVariableInspection.Companion.statusFor(element3) != null;
    }

    @Override
    @NotNull
    public PsiElement inspectionTarget(@NotNull KtProperty element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element3;
        }
        return psiElement2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String inspectionText(@NotNull KtProperty element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Companion.Status status2 = UnnecessaryVariableInspection.Companion.statusFor(element3);
        if (status2 == null) return "";
        switch (UnnecessaryVariableInspection$WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 1: {
                return "Variable used only in following return and should be inlined";
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder().append("Variable is same as '");
                KtExpression ktExpression = element3.getInitializer();
                if (!(ktExpression instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                String string = stringBuilder.append(ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null).append("' and should be inlined").toString();
                return string;
            }
            default: {
                return "";
            }
        }
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    public boolean getStartFixInWriteAction() {
        return this.startFixInWriteAction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtProperty.class, (boolean)strict$iv);
        if (ktProperty == null) {
            return;
        }
        KtProperty property2 = ktProperty;
        new KotlinInlineValHandler(false).inlineElement(project, editor, property2);
    }

    public UnnecessaryVariableInspection() {
        super(KtProperty.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion;", "", "()V", "statusFor", "Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion$Status;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Status", "idea"})
    public static final class Companion {
        private final Status statusFor(KtProperty property2) {
            KtElement ktElement = KtPsiUtil.getEnclosingElementForLocalDeclaration(property2);
            if (ktElement == null) {
                return null;
            }
            KtElement enclosingElement = ktElement;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression == null) {
                return null;
            }
            KtExpression initializer2 = ktExpression;
            Function0<Boolean> isExactCopy$ = new Function0<Boolean>(property2, initializer2, enclosingElement){
                final /* synthetic */ KtProperty $property;
                final /* synthetic */ KtExpression $initializer;
                final /* synthetic */ KtElement $enclosingElement;

                public final boolean invoke() {
                    if (!this.$property.isVar() && this.$initializer instanceof KtNameReferenceExpression && this.$property.getTypeReference() == null) {
                        KtExpression ktExpression = this.$initializer;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"initializer");
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = ResolutionUtils.resolveToCall(ktExpression, BodyResolveMode.FULL);
                        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                        if (!(callableDescriptor instanceof VariableDescriptor)) {
                            callableDescriptor = null;
                        }
                        VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
                        if (variableDescriptor == null) {
                            return false;
                        }
                        VariableDescriptor initializerDescriptor = variableDescriptor;
                        if (initializerDescriptor.isVar()) {
                            return false;
                        }
                        if (!(initializerDescriptor.getContainingDeclaration() instanceof FunctionDescriptor)) {
                            return false;
                        }
                        String copyName = initializerDescriptor.getName().asString();
                        if (ReferencesSearch.search((PsiElement)this.$property, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)this.$enclosingElement))).findFirst() == null) {
                            return false;
                        }
                        PsiElement $receiver$iv = this.$property;
                        KtDeclaration containingDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)true);
                        if (containingDeclaration != null) {
                            PsiElement psiElement2 = containingDeclaration;
                            PsiElement psiElement3 = this.$property;
                            PsiElement psiElement4 = DescriptorToSourceUtils.descriptorToDeclaration(initializerDescriptor);
                            if (!(psiElement4 instanceof KtDeclaration)) {
                                psiElement4 = null;
                            }
                            NewDeclarationNameValidator validator2 = new NewDeclarationNameValidator(psiElement2, psiElement3, NewDeclarationNameValidator.Target.VARIABLES, (List<? extends KtDeclaration>)CollectionsKt.listOfNotNull((Object)((KtDeclaration)psiElement4)));
                            String string = copyName;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"copyName");
                            if (!validator2.invoke(string).booleanValue()) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return false;
                }
                {
                    this.$property = ktProperty;
                    this.$initializer = ktExpression;
                    this.$enclosingElement = ktElement;
                    super(0);
                }
            };
            Function0<Boolean> isReturnOnly$ = new Function0<Boolean>(property2){
                final /* synthetic */ KtProperty $property;

                public final boolean invoke() {
                    PsiElement psiElement2 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(this.$property, false, 1, null);
                    if (!(psiElement2 instanceof KtReturnExpression)) {
                        psiElement2 = null;
                    }
                    KtReturnExpression ktReturnExpression = (KtReturnExpression)psiElement2;
                    if (ktReturnExpression == null) {
                        return false;
                    }
                    KtReturnExpression nextStatement = ktReturnExpression;
                    KtExpression ktExpression = nextStatement.getReturnedExpression();
                    if (!(ktExpression instanceof KtNameReferenceExpression)) {
                        ktExpression = null;
                    }
                    KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                    if (ktNameReferenceExpression == null) {
                        return false;
                    }
                    KtNameReferenceExpression returned = ktNameReferenceExpression;
                    BindingContext context = ResolutionUtils.analyze$default(nextStatement, null, 1, null);
                    return Intrinsics.areEqual((Object)((DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, returned)), (Object)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.$property));
                }
                {
                    this.$property = ktProperty;
                    super(0);
                }
            };
            return isExactCopy$.invoke() ? Status.EXACT_COPY : (isReturnOnly$.invoke() ? Status.RETURN_ONLY : null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnnecessaryVariableInspection$Companion$Status;", "", "(Ljava/lang/String;I)V", "RETURN_ONLY", "EXACT_COPY", "idea"})
        private static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status RETURN_ONLY;
            public static final /* enum */ Status EXACT_COPY;
            private static final /* synthetic */ Status[] $VALUES;

            static {
                Status[] statusArray = new Status[2];
                Status[] statusArray2 = statusArray;
                statusArray[0] = RETURN_ONLY = new Status();
                statusArray[1] = EXACT_COPY = new Status();
                $VALUES = statusArray;
            }

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String string) {
                return Enum.valueOf(Status.class, string);
            }
        }
    }
}

