/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionToParameter;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionToReceiver;
import org.jetbrains.kotlin.idea.inspections.ScopeFunctionConversionInspectionKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ScopeFunctionConversionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class ScopeFunctionConversionInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.callExpressionVisitor((Function1<? super KtCallExpression, Unit>)((Function1)new Function1<KtCallExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                String counterpartName = ScopeFunctionConversionInspectionKt.access$getCounterpart(expression2);
                if (counterpartName != null) {
                    KtExpression ktExpression = expression2.getCalleeExpression();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$holder.registerProblem((PsiElement)ktExpression, "Call is replaceable with another scope function", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{Intrinsics.areEqual((Object)counterpartName, (Object)"also") || Intrinsics.areEqual((Object)counterpartName, (Object)"let") ? (ConvertScopeFunctionFix)new ConvertScopeFunctionToParameter(counterpartName) : (ConvertScopeFunctionFix)new ConvertScopeFunctionToReceiver(counterpartName)});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

