/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.Replacement;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0016\u001a\u00020\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00062\u0006\u0010\u0019\u001a\u0002H\u00182\u001d\u0010\u001a\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00060\u001b\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u001fR-\u0010\u0003\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "", "()V", "createParameter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/ExtensionFunctionType;", "getCreateParameter", "()Lkotlin/jvm/functions/Function1;", "setCreateParameter", "(Lkotlin/jvm/functions/Function1;)V", "elementToRename", "getElementToRename", "()Lcom/intellij/psi/PsiElement;", "setElementToRename", "(Lcom/intellij/psi/PsiElement;)V", "project", "Lcom/intellij/openapi/project/Project;", "replacements", "", "Lorg/jetbrains/kotlin/idea/inspections/Replacement;", "add", "", "T", "element", "replacementFactory", "Lkotlin/Function2;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function2;)V", "apply", "isNotEmpty", "", "idea"})
public final class ReplacementCollection {
    private Project project;
    private final List<Replacement<? extends PsiElement>> replacements;
    @NotNull
    private Function1<? super KtPsiFactory, ? extends PsiElement> createParameter;
    @Nullable
    private PsiElement elementToRename;

    @NotNull
    public final Function1<KtPsiFactory, PsiElement> getCreateParameter() {
        return this.createParameter;
    }

    public final void setCreateParameter(@NotNull Function1<? super KtPsiFactory, ? extends PsiElement> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.createParameter = function1;
    }

    @Nullable
    public final PsiElement getElementToRename() {
        return this.elementToRename;
    }

    public final void setElementToRename(@Nullable PsiElement psiElement2) {
        this.elementToRename = psiElement2;
    }

    public final <T extends PsiElement> void add(@NotNull T element3, @NotNull Function2<? super KtPsiFactory, ? super T, ? extends PsiElement> replacementFactory) {
        Intrinsics.checkParameterIsNotNull(element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(replacementFactory, (String)"replacementFactory");
        Project project = element3.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        this.project = project;
        this.replacements.add(Replacement.Companion.create(element3, replacementFactory));
    }

    public final void apply() {
        Collection collection = this.replacements;
        if (!collection.isEmpty()) {
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            this.elementToRename = (PsiElement)this.createParameter.invoke((Object)factory2);
            List<Replacement<? extends PsiElement>> list2 = this.replacements;
            if (list2.size() > 1) {
                List<Replacement<? extends PsiElement>> list3 = list2;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Replacement it = (Replacement)a;
                        Comparable comparable = Integer.valueOf(it.getEndOffset());
                        it = (Replacement)b;
                        Comparable comparable2 = comparable;
                        Integer n = it.getEndOffset();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                CollectionsKt.sortWith((List)list3, (Comparator)comparator);
            }
            for (Replacement replacement2 : this.replacements) {
                replacement2.apply(factory2);
            }
        }
    }

    public final boolean isNotEmpty() {
        Collection collection = this.replacements;
        return !collection.isEmpty();
    }

    public ReplacementCollection() {
        List list2;
        ReplacementCollection replacementCollection = this;
        replacementCollection.replacements = list2 = (List)new ArrayList();
        this.createParameter = createParameter.1.INSTANCE;
    }
}

