/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\u0006"}, d2={"hasLowerVisibilityThanProperty", "", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "isFieldText", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isRedundantSetter", "idea"})
public final class RedundantSetterInspectionKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isRedundantSetter(@NotNull KtPropertyAccessor $receiver) {
        if (!$receiver.isSetter()) {
            return false;
        }
        List<KtAnnotationEntry> list2 = $receiver.getAnnotationEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntries");
        Collection collection = list2;
        if (!collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (RedundantSetterInspectionKt.hasLowerVisibilityThanProperty($receiver)) {
            return false;
        }
        KtExpression ktExpression = $receiver.getBodyExpression();
        if (ktExpression == null) return true;
        KtExpression expression2 = ktExpression;
        if (!(expression2 instanceof KtBlockExpression)) return false;
        List<KtExpression> list3 = ((KtBlockExpression)expression2).getStatements();
        List<KtExpression> it = list3;
        if (it.size() != 1) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        List<KtExpression> list4 = list3;
        Object object = list4;
        if (list4 == null) return false;
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.firstOrNull(object);
        object = ktExpression2;
        if (ktExpression2 == null) return false;
        Object statement2 = object;
        List<KtExpression> it2 = it = $receiver.getValueParameters();
        if (it2.size() != 1) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        List<KtExpression> list5 = it;
        Object object2 = list5;
        if (list5 == null) return false;
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull(object2);
        object2 = ktParameter;
        if (ktParameter == null) return false;
        Object parameter = object2;
        Object object3 = statement2;
        if (!(object3 instanceof KtBinaryExpression)) {
            object3 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)object3;
        if (ktBinaryExpression == null) return false;
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)((Object)KtTokens.EQ))) return false;
        KtExpression ktExpression3 = binaryExpression.getLeft();
        if (ktExpression3 == null) return false;
        if (!RedundantSetterInspectionKt.isFieldText(ktExpression3)) return false;
        Object object4 = binaryExpression.getRight();
        if (!Intrinsics.areEqual(object4 != null && (object4 = ReferenceUtilKt.getMainReference((KtElement)object4)) != null ? object4.resolve() : null, (Object)parameter)) return false;
        return true;
    }

    private static final boolean hasLowerVisibilityThanProperty(@NotNull KtPropertyAccessor $receiver) {
        KtProperty p = $receiver.getProperty();
        return p.hasModifier(KtTokens.PRIVATE_KEYWORD) ? false : (p.hasModifier(KtTokens.PROTECTED_KEYWORD) ? $receiver.hasModifier(KtTokens.PRIVATE_KEYWORD) : (p.hasModifier(KtTokens.INTERNAL_KEYWORD) ? $receiver.hasModifier(KtTokens.PRIVATE_KEYWORD) || $receiver.hasModifier(KtTokens.PROTECTED_KEYWORD) : $receiver.hasModifier(KtTokens.PRIVATE_KEYWORD) || $receiver.hasModifier(KtTokens.PROTECTED_KEYWORD) || $receiver.hasModifier(KtTokens.INTERNAL_KEYWORD)));
    }

    private static final boolean isFieldText(@NotNull KtExpression $receiver) {
        return $receiver.textMatches("field");
    }

    public static final /* synthetic */ boolean access$isRedundantSetter(@NotNull KtPropertyAccessor $receiver) {
        return RedundantSetterInspectionKt.isRedundantSetter($receiver);
    }
}

