/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.ImplicitReceiversUtilsKt;
import org.jetbrains.kotlin.idea.util.ReceiverExpressionFactory;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ExplicitThisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Fix", "idea"})
public final class ExplicitThisInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (!PlatformKt.getLanguageVersionSettings(expression2).supportsFeature(LanguageFeature.CallableReferencesToClassMembersWithEmptyLHS)) {
                    return;
                }
                KtExpression ktExpression = expression2.getReceiverExpression();
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                if (ktThisExpression == null) {
                    return;
                }
                KtThisExpression thisExpression = ktThisExpression;
                KtSimpleNameExpression selectorExpression = expression2.getCallableReference();
                KtExpression ktExpression2 = expression2;
                KtSimpleNameExpression ktSimpleNameExpression = selectorExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"selectorExpression");
                this.handle(ktExpression2, thisExpression, ktSimpleNameExpression);
            }

            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getReceiverExpression();
                if (!(ktExpression instanceof KtThisExpression)) {
                    ktExpression = null;
                }
                KtThisExpression ktThisExpression = (KtThisExpression)ktExpression;
                if (ktThisExpression == null) {
                    return;
                }
                KtThisExpression thisExpression = ktThisExpression;
                KtExpression ktExpression2 = expression2.getSelectorExpression();
                if (!(ktExpression2 instanceof KtReferenceExpression)) {
                    ktExpression2 = null;
                }
                KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression2;
                if (ktReferenceExpression == null) {
                    return;
                }
                KtReferenceExpression selectorExpression = ktReferenceExpression;
                this.handle(expression2, thisExpression, selectorExpression);
            }

            private final void handle(KtExpression expression2, KtThisExpression thisExpression, KtReferenceExpression reference2) {
                String label2;
                KtNameReferenceExpression ktNameReferenceExpression;
                BindingContext context = ResolutionUtils.analyze$default(expression2, null, 1, null);
                LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)expression2, context);
                if (lexicalScope == null) {
                    return;
                }
                LexicalScope scope2 = lexicalScope;
                KtReferenceExpression ktReferenceExpression = reference2;
                if (!(ktReferenceExpression instanceof KtNameReferenceExpression)) {
                    ktReferenceExpression = null;
                }
                if ((ktNameReferenceExpression = (KtNameReferenceExpression)ktReferenceExpression) == null) {
                    PsiElement $receiver$iv = (PsiElement)reference2;
                    ktNameReferenceExpression = (KtNameReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)$receiver$iv, KtNameReferenceExpression.class);
                }
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression referenceExpression = ktNameReferenceExpression;
                Name name2 = referenceExpression.getReferencedNameAsName();
                List candidates2 = CollectionsKt.plus(ScopeUtils.getAllAccessibleVariables(scope2, name2), (Iterable)ScopeUtils.getAllAccessibleFunctions(scope2, name2));
                if (candidates2.size() != 1) {
                    return;
                }
                Object object = (KotlinTypeInfo)context.get(BindingContext.EXPRESSION_TYPE_INFO, thisExpression);
                if (object == null || (object = ((KotlinTypeInfo)object).getType()) == null) {
                    return;
                }
                Object receiverType2 = object;
                ReceiverExpressionFactory receiverExpressionFactory = ImplicitReceiversUtilsKt.getFactoryForImplicitReceiverWithSubtypeOf(scope2, (KotlinType)receiverType2);
                if (receiverExpressionFactory == null) {
                    return;
                }
                ReceiverExpressionFactory expressionFactory = receiverExpressionFactory;
                String string = thisExpression.getLabelName();
                if (string == null) {
                    string = label2 = "";
                }
                if (!this.matchesLabel(expressionFactory, label2)) {
                    return;
                }
                PsiElement psiElement2 = (PsiElement)thisExpression;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                String string2 = thisExpression.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"thisExpression.text");
                localQuickFixArray[0] = new Fix(string2);
                this.$holder.registerProblem(psiElement2, "Redundant explicit this", ProblemHighlightType.LIKE_UNUSED_SYMBOL, localQuickFixArray);
            }

            private final boolean matchesLabel(@NotNull ReceiverExpressionFactory $receiver, String label2) {
                String implicitLabel = StringsKt.substringAfter((String)$receiver.getExpressionText(), (String)"@", (String)"");
                return Intrinsics.areEqual((Object)label2, (Object)implicitLabel) || Intrinsics.areEqual((Object)label2, (Object)"") && $receiver.isImmediate();
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ExplicitThisInspection$Fix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "text", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "idea"})
    private static final class Fix
    implements LocalQuickFix {
        private final String text;

        @NotNull
        public String getFamilyName() {
            return "Remove redundant '" + this.text + '\'';
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement parent2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtThisExpression)) {
                psiElement2 = null;
            }
            KtThisExpression ktThisExpression = (KtThisExpression)psiElement2;
            if (ktThisExpression == null) {
                return;
            }
            KtThisExpression thisExpression = ktThisExpression;
            PsiElement psiElement3 = parent2 = thisExpression.getParent();
            if (psiElement3 instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = ((KtDotQualifiedExpression)parent2).getSelectorExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((KtDotQualifiedExpression)parent2).replace((PsiElement)ktExpression), (String)"parent.replace(parent.se\u2026ctorExpression ?: return)");
            } else if (psiElement3 instanceof KtCallableReferenceExpression) {
                thisExpression.delete();
            }
        }

        public Fix(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            this.text = text2;
        }
    }
}

