/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionToReceiver;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionToReceiver;", "Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "(Ljava/lang/String;)V", "analyzeLambda", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "lambdaDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "replacements", "Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "postprocessLambda", "idea"})
public final class ConvertScopeFunctionToReceiver
extends ConvertScopeFunctionFix {
    @Override
    protected void analyzeLambda(@NotNull BindingContext bindingContext2, @NotNull KtLambdaArgument lambda2, @NotNull SimpleFunctionDescriptor lambdaDescriptor, @NotNull ReplacementCollection replacements) {
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        Intrinsics.checkParameterIsNotNull((Object)lambdaDescriptor, (String)"lambdaDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)replacements, (String)"replacements");
        lambda2.accept(new KtTreeVisitorVoid(lambdaDescriptor, replacements, bindingContext2){
            final /* synthetic */ SimpleFunctionDescriptor $lambdaDescriptor;
            final /* synthetic */ ReplacementCollection $replacements;
            final /* synthetic */ BindingContext $bindingContext;

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitSimpleNameExpression(expression2);
                if (Intrinsics.areEqual((Object)expression2.getReferencedName(), (Object)"it")) {
                    DeclarationDescriptor result2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(expression2));
                    if (result2 instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((ValueParameterDescriptor)result2).getContainingDeclaration(), (Object)this.$lambdaDescriptor)) {
                        this.$replacements.add((PsiElement)expression2, analyzeLambda.visitSimpleNameExpression.1.INSTANCE);
                    }
                } else {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                    if (resolvedCall2 == null) {
                        return;
                    }
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                    ReceiverValue dispatchReceiver = resolvedCall3.getDispatchReceiver();
                    if (dispatchReceiver instanceof ImplicitReceiver) {
                        PsiElement parent2 = expression2.getParent();
                        String thisLabelName = KotlinRefactoringUtilKt.getThisLabelName(((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor());
                        if (parent2 instanceof KtCallExpression && Intrinsics.areEqual((Object)expression2, (Object)((KtCallExpression)parent2).getCalleeExpression())) {
                            this.$replacements.add(parent2, (Function2)new Function2<KtPsiFactory, KtCallExpression, KtExpression>(thisLabelName){
                                final /* synthetic */ String $thisLabelName;

                                @NotNull
                                public final KtExpression invoke(@NotNull KtPsiFactory $receiver, @NotNull KtCallExpression element3) {
                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                    return CreateByPatternKt.createExpressionByPattern$default($receiver, "this@$0.$1", new Object[]{this.$thisLabelName, element3}, false, 4, null);
                                }
                                {
                                    this.$thisLabelName = string;
                                    super(2);
                                }
                            });
                        } else {
                            String referencedName = expression2.getReferencedName();
                            this.$replacements.add((PsiElement)expression2, (Function2)new Function2<KtPsiFactory, KtSimpleNameExpression, KtExpression>(thisLabelName, referencedName){
                                final /* synthetic */ String $thisLabelName;
                                final /* synthetic */ String $referencedName;

                                @NotNull
                                public final KtExpression invoke(@NotNull KtPsiFactory $receiver, @NotNull KtSimpleNameExpression it) {
                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return $receiver.createExpression("this@" + this.$thisLabelName + '.' + this.$referencedName);
                                }
                                {
                                    this.$thisLabelName = string;
                                    this.$referencedName = string2;
                                    super(2);
                                }
                            });
                        }
                    }
                }
            }

            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall2 == null) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                DeclarationDescriptor declarationDescriptor = resolvedCall3.getResultingDescriptor().getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"resolvedCall.resultingDe\u2026tor.containingDeclaration");
                Name qualifierName = declarationDescriptor.getName();
                this.$replacements.add((PsiElement)expression2, (Function2)new Function2<KtPsiFactory, KtThisExpression, KtThisExpression>(qualifierName){
                    final /* synthetic */ Name $qualifierName;

                    @NotNull
                    public final KtThisExpression invoke(@NotNull KtPsiFactory $receiver, @NotNull KtThisExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String string = this.$qualifierName.asString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifierName.asString()");
                        return $receiver.createThisExpression(string);
                    }
                    {
                        this.$qualifierName = name2;
                        super(2);
                    }
                });
            }
            {
                this.$lambdaDescriptor = $captured_local_variable$0;
                this.$replacements = $captured_local_variable$1;
                this.$bindingContext = $captured_local_variable$2;
            }
        });
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
        new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)postprocessLambda.1.INSTANCE)).process(lambda2, (Function1<? super PsiElement, ? extends ShortenReferences.FilterResult>)((Function1)postprocessLambda.2.INSTANCE));
    }

    public ConvertScopeFunctionToReceiver(@NotNull String counterpartName) {
        Intrinsics.checkParameterIsNotNull((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }
}

