/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.MovePropertyToConstructorIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/CanBePrimaryConstructorPropertyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class CanBePrimaryConstructorPropertyInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.propertyVisitor((Function1<? super KtProperty, Unit>)((Function1)new Function1<KtProperty, Unit>(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public final void invoke(@NotNull KtProperty property2) {
                PsiElement nameIdentifier;
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                if (property2.isLocal()) {
                    return;
                }
                if (property2.getGetter() != null || property2.getSetter() != null || property2.getDelegate() != null) {
                    return;
                }
                KtExpression ktExpression = property2.getInitializer();
                if (!(ktExpression instanceof KtReferenceExpression)) {
                    ktExpression = null;
                }
                KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
                if (ktReferenceExpression == null) {
                    return;
                }
                KtReferenceExpression assigned = ktReferenceExpression;
                BindingContext context = ResolutionUtils.analyze$default(assigned, null, 1, null);
                V v = context.get(BindingContext.REFERENCE_TARGET, assigned);
                if (!(v instanceof ValueParameterDescriptor)) {
                    v = null;
                }
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)v;
                if (valueParameterDescriptor == null) {
                    return;
                }
                ValueParameterDescriptor assignedDescriptor = valueParameterDescriptor;
                CallableDescriptor callableDescriptor = assignedDescriptor.getContainingDeclaration();
                if (!(callableDescriptor instanceof ClassConstructorDescriptor)) {
                    callableDescriptor = null;
                }
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableDescriptor;
                if (classConstructorDescriptor == null) {
                    return;
                }
                ClassConstructorDescriptor containingConstructor = classConstructorDescriptor;
                if (containingConstructor.getContainingDeclaration().isData()) {
                    return;
                }
                KtTypeReference propertyTypeReference = property2.getTypeReference();
                KotlinType propertyType = (KotlinType)context.get(BindingContext.TYPE, propertyTypeReference);
                if (propertyType != null && Intrinsics.areEqual((Object)propertyType, (Object)assignedDescriptor.getType()) ^ true) {
                    return;
                }
                PsiElement psiElement2 = property2.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement psiElement3 = nameIdentifier = psiElement2;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nameIdentifier");
                if (Intrinsics.areEqual((Object)psiElement3.getText(), (Object)assignedDescriptor.getName().asString()) ^ true) {
                    return;
                }
                PsiElement psiElement4 = DescriptorToSourceUtils.descriptorToDeclaration(assignedDescriptor);
                if (!(psiElement4 instanceof KtParameter)) {
                    psiElement4 = null;
                }
                KtParameter ktParameter = (KtParameter)psiElement4;
                if (ktParameter == null) {
                    return;
                }
                KtParameter assignedParameter = ktParameter;
                if (KtPsiUtilKt.getContainingClassOrObject(property2) != KtPsiUtilKt.getContainingClassOrObject(assignedParameter)) {
                    return;
                }
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(property2);
                if (ktClassOrObject != null ? KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)ktClassOrObject) : false) {
                    return;
                }
                this.$holder.registerProblem(this.$holder.getManager().createProblemDescriptor(nameIdentifier, nameIdentifier, "Property is explicitly assigned to parameter " + assignedDescriptor.getName() + ", can be declared directly in constructor", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, new LocalQuickFix[]{new MovePropertyToConstructorIntention()}));
            }
            {
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }
}

