/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/PlatformExpectedAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isExpectedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "idea"})
public final class PlatformExpectedAnnotator
implements Annotator {
    /*
     * WARNING - void declaration
     */
    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtNamedDeclaration)) {
            psiElement2 = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement2;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (!this.isExpectedDeclaration(declaration2)) {
            return;
        }
        if (!(TargetPlatformDetector.getPlatform(declaration2.getContainingKtFile()) instanceof TargetPlatform.Common)) {
            return;
        }
        List<ModuleDescriptor> implementingModules2 = MultiplatformUtilKt.getImplementingDescriptors(ResolutionUtils.findModuleDescriptor(declaration2));
        if (implementingModules2.isEmpty()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
        if (!(declarationDescriptor instanceof MemberDescriptor)) {
            declarationDescriptor = null;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
        if (memberDescriptor == null) {
            return;
        }
        MemberDescriptor descriptor2 = memberDescriptor;
        if (!descriptor2.isExpect()) {
            return;
        }
        BindingTraceContext trace = new BindingTraceContext();
        for (ModuleDescriptor module : implementingModules2) {
            ExpectedActualDeclarationChecker.INSTANCE.checkExpectedDeclarationHasActual(declaration2, descriptor2, trace, module, ExpectActualTracker.DoNothing.INSTANCE);
        }
        Project project = declaration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
        KotlinSuppressCache suppressionCache = KotlinCacheService.Companion.getInstance(project).getSuppressionCache();
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"trace.bindingContext.diagnostics");
        Iterable iterable = $receiver$iv = (Iterable)diagnostics2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Diagnostic diagnostic = (Diagnostic)element$iv$iv;
            PsiElement psiElement3 = declaration2;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory, (String)"diagnostic.factory");
            String string = diagnosticFactory.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"diagnostic.factory.name");
            Severity severity = diagnostic.getSeverity();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"diagnostic.severity");
            if (!(!suppressionCache.isSuppressed(psiElement3, string, severity))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredList = (List)destination$iv$iv;
        if (filteredList.isEmpty()) {
            return;
        }
        new KotlinPsiChecker().annotateElement(declaration2, holder, new SimpleDiagnostics(filteredList));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExpectedDeclaration(KtDeclaration declaration2) {
        if (PsiUtilsKt.hasExpectModifier(declaration2)) return true;
        if (!(declaration2 instanceof KtClassOrObject)) return false;
        KtClassOrObject ktClassOrObject = KtPsiUtil.getOutermostClassOrObject((KtClassOrObject)declaration2);
        if (ktClassOrObject == null) return false;
        if (!PsiUtilsKt.hasExpectModifier(ktClassOrObject)) return false;
        return true;
    }
}

