/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor$WhenMappings;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor$getJavaScriptTestIcon$;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.string.StringUtilKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinTestRunLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getJavaScriptTestIcon", "Ljavax/swing/Icon;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getJavaTestIcon", "getTestStateIcon", "url", "", "project", "Lcom/intellij/openapi/project/Project;", "isIgnored", "", "isTest", "Companion", "idea"})
public final class KotlinTestRunLineMarkerContributor
extends RunLineMarkerContributor {
    private static final FqName TEST_FQ_NAME;
    private static final FqName IGNORE_FQ_NAME;
    public static final Companion Companion;

    /*
     * Enabled aggressive block sorting
     */
    private final Icon getTestStateIcon(String url, Project project) {
        Icon icon;
        TestStateInfo.Magnitude magnitude;
        Icon defaultIcon = AllIcons.RunConfigurations.TestState.Run;
        TestStateStorage.Record record2 = TestStateStorage.getInstance((Project)project).getState(url);
        if (record2 == null) return defaultIcon;
        TestStateStorage.Record state = record2;
        TestStateInfo.Magnitude magnitude2 = magnitude = TestIconMapper.getMagnitude((int)state.magnitude);
        if (magnitude2 != null) {
            switch (KotlinTestRunLineMarkerContributor$WhenMappings.$EnumSwitchMapping$0[magnitude2.ordinal()]) {
                case 1: 
                case 2: {
                    icon = AllIcons.RunConfigurations.TestState.Red2;
                    return icon;
                }
                case 3: 
                case 4: {
                    icon = AllIcons.RunConfigurations.TestState.Green2;
                    return icon;
                }
            }
        }
        icon = defaultIcon;
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    private final Icon getJavaTestIcon(KtNamedDeclaration declaration2) {
        void url;
        Pair pair2;
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass = ktLightClass;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)lightClass);
            if (testFramework == null) {
                return null;
            }
            TestFramework framework = testFramework;
            if (!framework.isTestClass((PsiElement)lightClass)) {
                return null;
            }
            String string = lightClass.getQualifiedName();
            if (string == null) {
                return null;
            }
            String qualifiedName2 = string;
            pair2 = TuplesKt.to((Object)("java:suite://" + qualifiedName2), (Object)framework);
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            PsiMethod psiMethod = (PsiMethod)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightMethods(declaration2));
            if (psiMethod == null) {
                return null;
            }
            PsiMethod lightMethod = psiMethod;
            PsiClass psiClass2 = lightMethod.getContainingClass();
            if (!(psiClass2 instanceof KtLightClass)) {
                psiClass2 = null;
            }
            KtLightClass ktLightClass = (KtLightClass)psiClass2;
            if (ktLightClass == null) {
                return null;
            }
            KtLightClass lightClass = ktLightClass;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)lightClass);
            if (testFramework == null) {
                return null;
            }
            TestFramework framework = testFramework;
            if (!framework.isTestMethod((PsiElement)lightMethod)) {
                return null;
            }
            pair2 = TuplesKt.to((Object)("java:test://" + lightClass.getQualifiedName() + '.' + lightMethod.getName()), (Object)framework);
        } else {
            return null;
        }
        Pair pair3 = pair2;
        String string = (String)pair3.component1();
        TestFramework framework = (TestFramework)pair3.component2();
        Project project = declaration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
        Icon icon = this.getTestStateIcon((String)url, project);
        if (icon == null) {
            TestFramework testFramework = framework;
            Intrinsics.checkExpressionValueIsNotNull((Object)testFramework, (String)"framework");
            icon = testFramework.getIcon();
        }
        return icon;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnored(@NotNull DeclarationDescriptor $receiver) {
        boolean bl;
        Iterable $receiver$iv = $receiver.getAnnotations();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)IGNORE_FQ_NAME)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) return false;
        boolean bl2 = this.isIgnored(classDescriptor);
        if (!bl2) return false;
        return true;
    }

    private final boolean isTest(@NotNull DeclarationDescriptor $receiver) {
        Object it;
        boolean bl;
        Iterable $receiver$iv;
        block9: {
            if (this.isIgnored($receiver)) {
                return false;
            }
            $receiver$iv = $receiver.getAnnotations();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (AnnotationDescriptor)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)TEST_FQ_NAME)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if ($receiver instanceof ClassDescriptorWithResolutionScopes) {
            boolean bl2;
            block10: {
                Collection<CallableMemberDescriptor> collection = ((ClassDescriptorWithResolutionScopes)$receiver).getDeclaredCallableMembers();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"declaredCallableMembers");
                $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        Object object = it = (CallableMemberDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                        if (!this.isTest((DeclarationDescriptor)object)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        return false;
    }

    private final Icon getJavaScriptTestIcon(KtNamedDeclaration declaration2, DeclarationDescriptor descriptor2) {
        String testName;
        KtClassOrObject ktClassOrObject;
        if (!this.isTest(descriptor2)) {
            return null;
        }
        Module module = ProjectRootsUtilKt.getModule(declaration2);
        if (module == null || (module = JsUtilsKt.jsOrJsImpl(module)) == null) {
            return null;
        }
        Module module2 = module;
        String string = JsUtilsKt.getJsTestOutputFilePath(module2);
        if (string == null) {
            return null;
        }
        String testFilePath = string;
        ArrayList locations = new ArrayList();
        Collection collection = locations;
        Object object = FileUtil.toSystemDependentName((String)testFilePath);
        collection.add(object);
        object = declaration2;
        if (object instanceof KtClassOrObject) {
            ktClassOrObject = (KtClassOrObject)declaration2;
        } else if (object instanceof KtNamedFunction) {
            ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration2);
            if (ktClassOrObject == null) {
                return null;
            }
        } else {
            return null;
        }
        KtClassOrObject klass2 = ktClassOrObject;
        object = locations;
        Object $receiver$iv = PsiUtilsKt.getParentsWithSelf(klass2);
        Sequence sequence2 = SequencesKt.filter($receiver$iv, (Function1)getJavaScriptTestIcon$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $receiver$iv = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence2, (Function1)getJavaScriptTestIcon.1.INSTANCE)));
        CollectionsKt.addAll((Collection)object, $receiver$iv);
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (!(ktNamedDeclaration instanceof KtNamedFunction)) {
            ktNamedDeclaration = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)ktNamedDeclaration;
        String string2 = testName = ktNamedFunction != null ? ktNamedFunction.getName() : null;
        if (testName != null) {
            $receiver$iv = locations;
            String $i$f$filterIsInstance = String.valueOf(testName);
            $receiver$iv.add((String)$i$f$filterIsInstance);
        }
        String prefix = testName != null ? "test://" : "suite://";
        String url = prefix + StringUtilKt.joinWithEscape(locations, '.');
        Project project = declaration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
        return this.getTestStateIcon(url, project);
    }

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element3) {
        Icon icon;
        TargetPlatform platform;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement $receiver$iv = element3;
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedDeclaration.class, (boolean)true);
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (Intrinsics.areEqual((Object)declaration2.getNameIdentifier(), (Object)element3) ^ true) {
            return null;
        }
        if (!(declaration2 instanceof KtClassOrObject) && !(declaration2 instanceof KtNamedFunction)) {
            return null;
        }
        if (declaration2 instanceof KtNamedFunction && KtPsiUtilKt.getContainingClassOrObject(declaration2) == null) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        TargetPlatform targetPlatform = platform = TargetPlatformDetector.getPlatform(declaration2.getContainingKtFile());
        if (targetPlatform instanceof JvmPlatform) {
            icon = this.getJavaTestIcon(declaration2);
        } else if (targetPlatform instanceof JsPlatform || targetPlatform instanceof TargetPlatform.Common) {
            icon = this.getJavaScriptTestIcon(declaration2, descriptor2);
        } else {
            return null;
        }
        if (icon == null) {
            return null;
        }
        Icon icon2 = icon;
        return new RunLineMarkerContributor.Info(icon2, (Function)getInfo.1.INSTANCE, ExecutorAction.Companion.getActions$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null));
    }

    static {
        Companion = new Companion(null);
        TEST_FQ_NAME = new FqName("kotlin.test.Test");
        IGNORE_FQ_NAME = new FqName("kotlin.test.Ignore");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinTestRunLineMarkerContributor$Companion;", "", "()V", "IGNORE_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TEST_FQ_NAME", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

