/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesFileAttributeKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingUtil;", "", "()V", "shouldHighlight", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "shouldHighlightErrors", "shouldHighlightScript", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-core"})
public final class KotlinHighlightingUtil {
    public static final KotlinHighlightingUtil INSTANCE;

    public final boolean shouldHighlight(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (ktFile2 instanceof KtCodeFragment && ((KtCodeFragment)ktFile2).getContext() != null) {
            return true;
        }
        if (ktFile2.isScript()) {
            return this.shouldHighlightScript(ktFile2);
        }
        return ProjectRootsUtil.isInProjectOrLibraryContent((PsiElement)ktFile2) && !(GetModuleInfoKt.getModuleInfo((PsiElement)ktFile2) instanceof NotUnderContentRootModuleInfo);
    }

    public final boolean shouldHighlightErrors(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        if (ktFile2.isCompiled()) {
            return false;
        }
        if (ktFile2 instanceof KtCodeFragment && ((KtCodeFragment)ktFile2).getContext() != null) {
            return true;
        }
        if (ktFile2.isScript()) {
            return this.shouldHighlightScript(ktFile2);
        }
        return ProjectRootsUtil.isInProjectSource((PsiElement)ktFile2);
    }

    private final boolean shouldHighlightScript(KtFile ktFile) {
        VirtualFile virtualFile2 = ktFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile.virtualFile");
        if (ScriptDependenciesFileAttributeKt.getScriptDependencies(virtualFile2) == null) {
            return false;
        }
        List list2 = (List)ktFile.getVirtualFile().getUserData((Key)IdeScriptReportSink.Reports.INSTANCE);
        if (list2 != null) {
            boolean bl;
            block7: {
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ScriptReport it = (ScriptReport)element$iv;
                        if (!(it.getSeverity() == ScriptReport.Severity.FATAL)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        KotlinScriptDefinition kotlinScriptDefinition = KotlinScriptDefinitionProviderKt.getScriptDefinition((PsiFile)ktFile);
        if (kotlinScriptDefinition == null) {
            return false;
        }
        KotlinScriptDefinition scriptDefinition2 = kotlinScriptDefinition;
        Project project = ktFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ktFile.project");
        return ScriptDefinitionsManager.Companion.getInstance(project).isInExpectedLocation(ktFile, scriptDefinition2);
    }

    private KotlinHighlightingUtil() {
    }

    static {
        KotlinHighlightingUtil kotlinHighlightingUtil;
        INSTANCE = kotlinHighlightingUtil = new KotlinHighlightingUtil();
    }
}

