/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.DeclarationKindDetector;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007J,\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u001c2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010*J\u001f\u0010+\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020,2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010-\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DeclarationKindDetector;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "", "()V", "detect", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "kind", "", "name", "newLineNeeded", "", "visitClass", "d", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitDeclaration", "", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/Unit;)Ljava/lang/Void;", "visitDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitObjectDeclaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "idea-core"})
final class DeclarationKindDetector
extends KtVisitor<AnnotationHostKind, Unit> {
    public static final DeclarationKindDetector INSTANCE;

    @Nullable
    public final AnnotationHostKind detect(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return (AnnotationHostKind)declaration2.accept(this, null);
    }

    @Override
    @Nullable
    public Void visitDeclaration(@NotNull KtDeclaration d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return null;
    }

    @Override
    @NotNull
    public AnnotationHostKind visitClass(@NotNull KtClass d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return DeclarationKindDetector.detect$default(this, d, d.isInterface() ? "interface" : "class", null, false, 12, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitNamedFunction(@NotNull KtNamedFunction d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return DeclarationKindDetector.detect$default(this, d, "fun", null, false, 12, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitProperty(@NotNull KtProperty d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        KtDeclaration ktDeclaration = d;
        PsiElement psiElement2 = d.getValOrVarKeyword();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"d.valOrVarKeyword");
        String string = psiElement2.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return DeclarationKindDetector.detect$default(this, ktDeclaration, string, null, false, 12, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        KtDeclaration ktDeclaration = d;
        Object object = d.getValOrVarKeyword();
        if (object == null || (object = object.getText()) == null) {
            object = "val";
        }
        List<KtDestructuringDeclarationEntry> list2 = d.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"d.entries");
        return DeclarationKindDetector.detect$default(this, ktDeclaration, (String)object, CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)visitDestructuringDeclaration.1.INSTANCE, (int)24, null), false, 8, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitTypeParameter(@NotNull KtTypeParameter d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return DeclarationKindDetector.detect$default(this, d, "type parameter", null, false, 4, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitEnumEntry(@NotNull KtEnumEntry d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return DeclarationKindDetector.detect$default(this, d, "enum entry", null, false, 12, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitParameter(@NotNull KtParameter d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return DeclarationKindDetector.detect$default(this, d, "parameter", null, false, 4, null);
    }

    @Override
    @NotNull
    public AnnotationHostKind visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
        return DeclarationKindDetector.detect$default(this, constructor2, "secondary constructor of", null, false, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public AnnotationHostKind visitObjectDeclaration(@NotNull KtObjectDeclaration d, @Nullable Unit data) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        if (d.isCompanion()) {
            void $receiver$iv;
            PsiElement psiElement2 = d;
            StringBuilder stringBuilder = new StringBuilder().append(d.getName()).append(" of ");
            String string = "companion object";
            KtDeclaration ktDeclaration = d;
            DeclarationKindDetector declarationKindDetector = this;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)true);
            KtClass ktClass2 = (KtClass)psiElement3;
            return DeclarationKindDetector.detect$default(declarationKindDetector, ktDeclaration, string, stringBuilder.append(ktClass2 != null ? ktClass2.getName() : null).toString(), false, 8, null);
        }
        if (d.getParent() instanceof KtObjectLiteralExpression) {
            return null;
        }
        return DeclarationKindDetector.detect$default(this, d, "object", null, false, 12, null);
    }

    private final AnnotationHostKind detect(KtDeclaration declaration2, String kind2, String name2, boolean newLineNeeded) {
        return new AnnotationHostKind(kind2, name2, newLineNeeded);
    }

    static /* bridge */ /* synthetic */ AnnotationHostKind detect$default(DeclarationKindDetector declarationKindDetector, KtDeclaration ktDeclaration, String string, String string2, boolean bl, int n, Object object) {
        String string3;
        if ((n & 4) != 0 && (string3 = ktDeclaration.getName()) == null) {
            string3 = string2 = "<anonymous>";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return declarationKindDetector.detect(ktDeclaration, string, string2, bl);
    }

    private DeclarationKindDetector() {
    }

    static {
        DeclarationKindDetector declarationKindDetector;
        INSTANCE = declarationKindDetector = new DeclarationKindDetector();
    }
}

