/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"getCurrentElement", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class HierarchyUtilsKt {
    @Nullable
    public static final PsiElement getCurrentElement(@NotNull DataContext dataContext, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file2;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = file2 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile2)) {
                return null;
            }
            TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)targetElementUtil, (String)"TargetElementUtil.getInstance()");
            return TargetElementUtil.findTargetElement((Editor)editor, (int)targetElementUtil.getAllAccepted());
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }
}

