/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.ui.ValidityListener;
import org.jetbrains.kotlin.idea.util.UiUtilKt;

public class CopyIntoPanel {
    private JPanel contentPane;
    private TextFieldWithBrowseButton copyIntoField;
    private JLabel copyIntoLabel;
    private final EventDispatcher<ValidityListener> validityDispatcher;
    private boolean hasErrorsState;

    public CopyIntoPanel(@Nullable Project project, @NotNull String defaultPath) {
        if (defaultPath == null) {
            CopyIntoPanel.$$$reportNull$$$0(0);
        }
        this(project, defaultPath, null);
    }

    public CopyIntoPanel(@Nullable Project project, @NotNull String defaultPath, @Nullable String labelText) {
        if (defaultPath == null) {
            CopyIntoPanel.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.validityDispatcher = EventDispatcher.create(ValidityListener.class);
        this.copyIntoField.addBrowseFolderListener("Copy Into...", "Choose folder where files will be copied", project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        UiUtilKt.onTextChange(this.copyIntoField.getTextField(), (Function1<? super DocumentEvent, Unit>)((Function1)e -> {
            this.updateComponents();
            return Unit.INSTANCE;
        }));
        if (labelText != null) {
            String text2 = labelText.replace("&", "");
            int mnemonicIndex = labelText.indexOf("&");
            char mnemonicChar = mnemonicIndex != -1 && mnemonicIndex + 1 < labelText.length() ? labelText.charAt(mnemonicIndex + 1) : (char)'\u0000';
            this.copyIntoLabel.setText(text2);
            this.copyIntoLabel.setDisplayedMnemonic(mnemonicChar);
            this.copyIntoLabel.setDisplayedMnemonicIndex(mnemonicIndex);
        } else {
            this.copyIntoLabel.setVisible(false);
        }
        this.copyIntoLabel.setLabelFor(this.copyIntoField.getTextField());
        this.copyIntoField.getTextField().setText(defaultPath);
        this.copyIntoField.getTextField().setColumns(40);
        this.updateComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public void addValidityListener(ValidityListener listener2) {
        this.validityDispatcher.addListener((EventListener)listener2);
    }

    @Nullable
    public String getPath() {
        return this.copyIntoField.isEnabled() ? this.copyIntoField.getText().trim() : null;
    }

    private void updateComponents() {
        boolean isError = false;
        this.copyIntoLabel.setForeground(JBColor.foreground());
        if (this.copyIntoField.isEnabled() && this.copyIntoField.getText().trim().isEmpty()) {
            this.copyIntoLabel.setForeground((Color)JBColor.red);
            isError = true;
        }
        if (isError != this.hasErrorsState) {
            this.hasErrorsState = isError;
            ((ValidityListener)this.validityDispatcher.getMulticaster()).validityChanged(isError);
        }
    }

    public void setEnabled(boolean enabled) {
        this.copyIntoField.setEnabled(enabled);
    }

    public boolean hasErrors() {
        return this.hasErrorsState;
    }

    public void setLabelWidth(int width) {
        this.copyIntoLabel.setPreferredSize(new Dimension(width, -1));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.copyIntoField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.copyIntoLabel = jLabel = new JLabel();
        jLabel.setText("Copy into:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPath", "org/jetbrains/kotlin/idea/framework/ui/CopyIntoPanel", "<init>"));
    }
}

