/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.formatter.CollectChangesWithoutApplyModelKt;
import org.jetbrains.kotlin.idea.formatter.KotlinBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtilImpl;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingRulesKt;
import org.jetbrains.kotlin.idea.formatter.NodeAlignmentStrategy;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "element", "Lcom/intellij/psi/PsiElement;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getRangeAffectingIndent", "Lcom/intellij/openapi/util/TextRange;", "psiFile", "Lcom/intellij/psi/PsiFile;", "i", "", "astNode", "Lcom/intellij/lang/ASTNode;", "idea"})
public final class KotlinFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element3, @NotNull CodeStyleSettings settings2) {
        FormattingModel collectChangesModel;
        PsiFile containingFile;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        PsiFile psiFile = element3.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        PsiFile psiFile2 = containingFile = psiFile.getViewProvider().getPsi((Language)KotlinLanguage.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"containingFile");
        FileASTNode fileASTNode = psiFile2.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileASTNode, (String)"containingFile.node");
        ASTNode aSTNode = (ASTNode)fileASTNode;
        NodeAlignmentStrategy nodeAlignmentStrategy = NodeAlignmentStrategy.getNullStrategy();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeAlignmentStrategy, (String)"NodeAlignmentStrategy.getNullStrategy()");
        KotlinBlock block = new KotlinBlock(aSTNode, nodeAlignmentStrategy, Indent.getNoneIndent(), null, settings2, KotlinSpacingRulesKt.createSpacingBuilder(settings2, KotlinSpacingBuilderUtilImpl.INSTANCE), null, 64, null);
        if (!element3.isPhysical()) {
            FileViewProvider fileViewProvider = containingFile.getViewProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"containingFile.viewProvider");
            FormattingDocumentModelImpl formattingDocumentModel = new FormattingDocumentModelImpl((Document)new DocumentImpl(fileViewProvider.getContents(), true), containingFile);
            return (FormattingModel)new PsiBasedFormattingModel(containingFile, (Block)block, formattingDocumentModel);
        }
        if (element3 instanceof PsiFile && (collectChangesModel = CollectChangesWithoutApplyModelKt.createCollectFormattingChangesModel((PsiFile)element3, (Block)block)) != null) {
            return collectChangesModel;
        }
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)element3.getContainingFile(), (Block)((Block)block), (CodeStyleSettings)settings2);
        Intrinsics.checkExpressionValueIsNotNull((Object)formattingModel, (String)"FormattingModelProvider.\u2026ingFile, block, settings)");
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(@NotNull PsiFile psiFile, int i, @NotNull ASTNode astNode) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)astNode, (String)"astNode");
        return null;
    }
}

