/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.findUsages.KotlinElementDescriptionProvider;
import org.jetbrains.kotlin.idea.findUsages.KotlinElementDescriptionProvider$fqName$;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameJavaSyntheticPropertyHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPropertyProcessor;
import org.jetbrains.kotlin.idea.util.string.StringUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0082\u0010J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/KotlinElementDescriptionProvider;", "Lcom/intellij/psi/ElementDescriptionProvider;", "()V", "getElementDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/ElementDescriptionLocation;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "name", "Lorg/jetbrains/kotlin/name/Name;", "parentForFqName", "renderShort", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "idea"})
public final class KotlinElementDescriptionProvider
implements ElementDescriptionProvider {
    private final KtNamedDeclaration parentForFqName(@NotNull KtNamedDeclaration $receiver) {
        KtNamedDeclaration parent2;
        while (true) {
            PsiElement $receiver$iv;
            if ((KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = (PsiElement)$receiver), KtNamedDeclaration.class, (boolean)true) == null) {
                return null;
            }
            if (!(parent2 instanceof KtProperty) || !((KtProperty)parent2).isLocal()) break;
            $receiver = parent2;
        }
        return parent2;
    }

    private final Name name(@NotNull KtNamedDeclaration $receiver) {
        Name name2 = $receiver.getNameAsName();
        if (name2 == null) {
            name2 = Name.special("<no name provided>");
        }
        return name2;
    }

    private final FqNameUnsafe fqName(@NotNull KtNamedDeclaration $receiver) {
        List<Name> packageSegments;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($receiver);
        if (ktClassOrObject != null) {
            KtClassOrObject ktClassOrObject2 = ktClassOrObject;
            KtClassOrObject it = ktClassOrObject2;
            if (it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion()) {
                FqNameUnsafe fqNameUnsafe = this.fqName(it).child(this.name($receiver));
                Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"it.fqName().child(name())");
                return fqNameUnsafe;
            }
            return new FqNameUnsafe("" + this.name(it) + '.' + this.name($receiver));
        }
        Sequence $receiver$iv = SequencesKt.generateSequence((Object)$receiver, (Function1)((Function1)new Function1<KtNamedDeclaration, KtNamedDeclaration>(this){
            final /* synthetic */ KotlinElementDescriptionProvider this$0;

            @Nullable
            public final KtNamedDeclaration invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return KotlinElementDescriptionProvider.access$parentForFqName(this.this$0, it);
            }
            {
                this.this$0 = kotlinElementDescriptionProvider;
                super(1);
            }
        }));
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)fqName$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List internalSegments2 = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)sequence2, (Function1)fqName.internalSegments.2.INSTANCE)));
        List<Name> list2 = packageSegments = $receiver.getContainingKtFile().getPackageFqName().pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"packageSegments");
        return new FqNameUnsafe(CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)list2, (Iterable)internalSegments2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
    }

    private final String renderShort(@NotNull KtTypeReference $receiver) {
        return (String)$receiver.accept(new KtVisitor<String, Unit>(){

            private final renderShort.1 getVisitor() {
                return this;
            }

            @NotNull
            public String visitTypeReference(@NotNull KtTypeReference typeReference, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Object object = typeReference.getTypeElement();
                if (object == null || (object = (String)object.accept(this, data)) == null) {
                    object = "???";
                }
                Object typeText = object;
                return typeReference.hasParentheses() ? '(' + (String)typeText + ')' : typeText;
            }

            public String visitDynamicType(@NotNull KtDynamicType type2, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return type2.getText();
            }

            @NotNull
            public String visitFunctionType(@NotNull KtFunctionType type2, @NotNull Unit data) {
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                KtTypeReference ktTypeReference = type2.getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference ktTypeReference2;
                    KtTypeReference it = ktTypeReference2 = ktTypeReference;
                    $receiver.append((String)it.accept(this.getVisitor(), data)).append('.');
                }
                List<KtParameter> list2 = type2.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"type.parameters");
                CollectionsKt.joinTo$default((Iterable)list2, (Appendable)$receiver, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<KtParameter, String>(this, type2, data){
                    final /* synthetic */ renderShort.1 this$0;
                    final /* synthetic */ KtFunctionType $type$inlined;
                    final /* synthetic */ Unit $data$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$type$inlined = ktFunctionType;
                        this.$data$inlined = unit;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(KtParameter it) {
                        R r = it.accept(renderShort.1.access$getVisitor$p(this.this$0), this.$data$inlined);
                        Intrinsics.checkExpressionValueIsNotNull(r, (String)"it.accept(visitor, data)");
                        return (String)r;
                    }
                }), (int)50, null);
                $receiver.append(" -> ");
                Object object = type2.getReturnTypeReference();
                if (object == null || (object = (String)((KtTypeReference)object).accept(this.getVisitor(), data)) == null) {
                    object = "???";
                }
                $receiver.append((String)object);
                String string = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }

            @NotNull
            public String visitNullableType(@NotNull KtNullableType nullableType, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)nullableType, (String)"nullableType");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Object object = nullableType.getInnerType();
                if (object == null || (object = (String)object.accept(this, data)) == null) {
                    return "???";
                }
                Object innerTypeText = object;
                return (String)innerTypeText + '?';
            }

            public String visitSelfType(@NotNull KtSelfType type2, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return type2.getText();
            }

            @NotNull
            public String visitUserType(@NotNull KtUserType type2, @NotNull Unit data) {
                List<KtTypeProjection> arguments2;
                StringBuilder stringBuilder;
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                String string = type2.getReferencedName();
                if (string == null) {
                    string = "???";
                }
                $receiver.append(string);
                List<KtTypeProjection> list2 = arguments2 = type2.getTypeArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arguments");
                Collection collection = list2;
                if (!collection.isEmpty()) {
                    CollectionsKt.joinTo$default((Iterable)arguments2, (Appendable)$receiver, null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<KtTypeProjection, CharSequence>(this, type2, data){
                        final /* synthetic */ renderShort.1 this$0;
                        final /* synthetic */ KtUserType $type$inlined;
                        final /* synthetic */ Unit $data$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$type$inlined = ktUserType2;
                            this.$data$inlined = unit;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(KtTypeProjection it) {
                            CharSequence charSequence;
                            KtTypeProjection ktTypeProjection = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeProjection, (String)"it");
                            Object object = ktTypeProjection.getTypeReference();
                            if (object != null && (object = (String)((KtTypeReference)object).accept(renderShort.1.access$getVisitor$p(this.this$0), this.$data$inlined)) != null) {
                                charSequence = (CharSequence)object;
                            } else {
                                String string = it.getText();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
                                charSequence = string;
                            }
                            return charSequence;
                        }
                    }), (int)50, null);
                }
                String string2 = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                return string2;
            }

            @NotNull
            public String visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                Object object = parameter.getTypeReference();
                if (object == null || (object = (String)((KtTypeReference)object).accept(this, data)) == null) {
                    object = "???";
                }
                return object;
            }

            @NotNull
            public static final /* synthetic */ renderShort.1 access$getVisitor$p(renderShort.1 $this) {
                return $this.getVisitor();
            }
        }, Unit.INSTANCE);
    }

    @Nullable
    public String getElementDescription(@NotNull PsiElement element3, @NotNull ElementDescriptionLocation location2) {
        Object object;
        PsiNamedElement namedElement;
        PsiNamedElement psiNamedElement;
        PsiElement psiElement2;
        boolean shouldUnwrap;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        boolean bl = shouldUnwrap = !(location2 instanceof UsageViewShortNameLocation) && !(location2 instanceof UsageViewLongNameLocation);
        if (shouldUnwrap) {
            psiElement2 = LightClassUtilsKt.getUnwrapped(element3);
            if (psiElement2 == null) {
                psiElement2 = element3;
            }
        } else {
            psiElement2 = element3;
        }
        PsiElement targetElement = psiElement2;
        Function0<String> elementKind$ = new Function0<String>(targetElement){
            final /* synthetic */ PsiElement $targetElement;

            @Nullable
            public final String invoke() {
                PsiElement psiElement2 = this.$targetElement;
                return psiElement2 instanceof KtClass ? (((KtClass)this.$targetElement).isInterface() ? "interface" : "class") : (psiElement2 instanceof KtObjectDeclaration ? (((KtObjectDeclaration)this.$targetElement).isCompanion() ? "companion object" : "object") : (psiElement2 instanceof KtNamedFunction ? "function" : (psiElement2 instanceof KtPropertyAccessor ? (((KtPropertyAccessor)this.$targetElement).isGetter() ? "getter" : "setter") + " for property " : (psiElement2 instanceof KtFunctionLiteral ? "lambda" : (psiElement2 instanceof KtPrimaryConstructor || psiElement2 instanceof KtSecondaryConstructor ? "constructor" : (psiElement2 instanceof KtProperty ? (((KtProperty)this.$targetElement).isLocal() ? "variable" : "property") : (psiElement2 instanceof KtTypeParameter ? "type parameter" : (psiElement2 instanceof KtParameter ? "parameter" : (psiElement2 instanceof KtDestructuringDeclarationEntry ? "variable" : (psiElement2 instanceof KtTypeAlias ? "type alias" : (psiElement2 instanceof KtLabeledExpression ? "label" : (psiElement2 instanceof KtImportAlias ? "import alias" : (psiElement2 instanceof RenameJavaSyntheticPropertyHandler.SyntheticPropertyWrapper ? "property" : (psiElement2 instanceof KtLightClassForFacade ? "facade class" : (psiElement2 instanceof RenameKotlinPropertyProcessor.PropertyMethodWrapper ? "property accessor" : null)))))))))))))));
            }
            {
                this.$targetElement = psiElement2;
                super(0);
            }
        };
        if (targetElement instanceof KtPropertyAccessor) {
            PsiElement psiElement3 = ((KtPropertyAccessor)targetElement).getParent();
            if (!(psiElement3 instanceof KtProperty)) {
                psiElement3 = null;
            }
            psiNamedElement = (PsiNamedElement)((KtProperty)psiElement3);
        } else {
            PsiElement psiElement4 = targetElement;
            if (!(psiElement4 instanceof PsiNamedElement)) {
                psiElement4 = null;
            }
            psiNamedElement = namedElement = (PsiNamedElement)psiElement4;
        }
        if (namedElement == null) {
            String string;
            if (targetElement instanceof KtElement) {
                StringBuilder stringBuilder = new StringBuilder().append("'");
                String string2 = ((KtElement)targetElement).getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"targetElement.text");
                string = stringBuilder.append(StringUtil.shortenTextWithEllipsis((String)StringUtilKt.collapseSpaces(string2), (int)53, (int)0)).append("'").toString();
            } else {
                string = null;
            }
            return string;
        }
        if (Intrinsics.areEqual((Object)namedElement.getLanguage(), (Object)((Object)KotlinLanguage.INSTANCE)) ^ true) {
            return null;
        }
        ElementDescriptionLocation elementDescriptionLocation = location2;
        if (elementDescriptionLocation instanceof UsageViewTypeLocation) {
            object = elementKind$.invoke();
        } else if (elementDescriptionLocation instanceof UsageViewShortNameLocation || elementDescriptionLocation instanceof UsageViewLongNameLocation) {
            object = namedElement.getName();
        } else if (elementDescriptionLocation instanceof RefactoringDescriptionLocation) {
            String string;
            Object object2 = elementKind$.invoke();
            if (object2 == null) {
                return null;
            }
            Object kind2 = object2;
            if (!(namedElement instanceof KtNamedDeclaration)) {
                return null;
            }
            boolean renderFqName = ((RefactoringDescriptionLocation)location2).includeParent() && !(namedElement instanceof KtTypeParameter) && !(namedElement instanceof KtParameter) && !(namedElement instanceof KtConstructor);
            PsiNamedElement psiNamedElement2 = namedElement;
            if (psiNamedElement2 instanceof KtFunction) {
                FqNameUnsafe parentFqName;
                StringBuilder stringBuilder;
                StringBuilder $receiver = stringBuilder = new StringBuilder();
                String string3 = ((KtFunction)namedElement).getName();
                if (string3 == null) {
                    string3 = "";
                }
                $receiver.append(string3);
                List<KtParameter> list2 = ((KtFunction)namedElement).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"namedElement.valueParameters");
                CollectionsKt.joinTo$default((Iterable)list2, (Appendable)$receiver, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<KtParameter, String>(this, namedElement){
                    final /* synthetic */ KotlinElementDescriptionProvider this$0;
                    final /* synthetic */ PsiNamedElement $namedElement$inlined;
                    {
                        this.this$0 = kotlinElementDescriptionProvider;
                        this.$namedElement$inlined = psiNamedElement;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(KtParameter it) {
                        StringBuilder stringBuilder = new StringBuilder();
                        KtParameter ktParameter = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                        StringBuilder stringBuilder2 = stringBuilder.append(ktParameter.isVarArg() ? "vararg " : "");
                        Object object = it.getTypeReference();
                        if (object == null || (object = KotlinElementDescriptionProvider.access$renderShort(this.this$0, (KtTypeReference)object)) == null) {
                            object = "";
                        }
                        return stringBuilder2.append(object).toString();
                    }
                }), (int)50, null);
                KtTypeReference ktTypeReference = ((KtFunction)namedElement).getReceiverTypeReference();
                if (ktTypeReference != null) {
                    KtTypeReference ktTypeReference2;
                    KtTypeReference it = ktTypeReference2 = ktTypeReference;
                    StringBuilder stringBuilder2 = $receiver.append(" on ");
                    KtTypeReference ktTypeReference3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
                    stringBuilder2.append(this.renderShort(ktTypeReference3));
                }
                String string4 = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                String baseText = string4;
                FqNameUnsafe fqNameUnsafe = parentFqName = renderFqName ? this.fqName((KtNamedDeclaration)namedElement).parent() : null;
                if (fqNameUnsafe != null ? fqNameUnsafe.isRoot() : true) {
                    string = baseText;
                } else {
                    StringBuilder stringBuilder3 = new StringBuilder();
                    FqNameUnsafe fqNameUnsafe2 = parentFqName;
                    if (fqNameUnsafe2 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = stringBuilder3.append(fqNameUnsafe2.asString()).append('.').append(baseText).toString();
                }
            } else {
                string = renderFqName ? this.fqName((KtNamedDeclaration)namedElement).asString() : ((KtNamedDeclaration)namedElement).getName();
                if (string == null) {
                    string = "";
                }
            }
            String desc = string;
            object = (String)kind2 + ' ' + CommonRefactoringUtil.htmlEmphasize((String)desc);
        } else if (elementDescriptionLocation instanceof HighlightUsagesDescriptionLocation) {
            Object object3 = elementKind$.invoke();
            if (object3 == null) {
                return null;
            }
            Object kind3 = object3;
            if (!(namedElement instanceof KtNamedDeclaration)) {
                return null;
            }
            object = (String)kind3 + ' ' + ((KtNamedDeclaration)namedElement).getName();
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final /* synthetic */ KtNamedDeclaration access$parentForFqName(KotlinElementDescriptionProvider $this, @NotNull KtNamedDeclaration $receiver) {
        return $this.parentForFqName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$renderShort(KotlinElementDescriptionProvider $this, @NotNull KtTypeReference $receiver) {
        return $this.renderShort($receiver);
    }
}

