/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/QuoteHandler;", "()V", "hasNonClosedLiteral", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isClosingQuote", "isInsideLiteral", "isOpeningQuote", "idea"})
public final class KotlinQuoteHandler
implements QuoteHandler {
    public boolean isClosingQuote(@NotNull HighlighterIterator iterator2, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)iterator2, (String)"iterator");
        IElementType tokenType = iterator2.getTokenType();
        if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.CHARACTER_LITERAL))) {
            int start = iterator2.getStart();
            int end = iterator2.getEnd();
            return end - start >= 1 && offset2 == end - 1;
        }
        return Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.CLOSING_QUOTE));
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator2, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)iterator2, (String)"iterator");
        IElementType tokenType = iterator2.getTokenType();
        if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.OPEN_QUOTE)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.CHARACTER_LITERAL))) {
            int start = iterator2.getStart();
            return offset2 == start;
        }
        return false;
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator2, int offset2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)iterator2, (String)"iterator");
        return true;
    }

    public boolean isInsideLiteral(@NotNull HighlighterIterator iterator2) {
        Intrinsics.checkParameterIsNotNull((Object)iterator2, (String)"iterator");
        IElementType tokenType = iterator2.getTokenType();
        return Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.REGULAR_STRING_PART)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.OPEN_QUOTE)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.CLOSING_QUOTE)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) || Intrinsics.areEqual((Object)tokenType, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START));
    }
}

