/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.debugger.surroundWith.KotlinRuntimeTypeCastSurrounder;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder;", "()V", "getTemplateDescription", "", "isApplicable", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "SurroundWithCastWorker", "idea-jvm"})
public final class KotlinRuntimeTypeCastSurrounder
extends KotlinExpressionSurrounder {
    @Override
    protected boolean isApplicable(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (!super.isApplicable(expression2)) {
            return false;
        }
        if (!expression2.isPhysical()) {
            return false;
        }
        PsiFile file2 = expression2.getContainingFile();
        if (!(file2 instanceof KtCodeFragment)) {
            return false;
        }
        KotlinType kotlinType = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    @Override
    @Nullable
    protected TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull KtExpression expression2) {
        block1: {
            DebuggerContextImpl debuggerContext;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
            DebuggerContextImpl debuggerContextImpl = debuggerContext = debuggerManagerEx.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            if (debuggerSession == null) break block1;
            ProgressWindow progressWindow = new ProgressWindow(true, expression2.getProject());
            SurroundWithCastWorker worker2 = new SurroundWithCastWorker(editor, expression2, debuggerContext, (ProgressIndicator)progressWindow);
            progressWindow.setTitle(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
            DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
            if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                debugProcessImpl.startProgress((DebuggerCommandImpl)worker2, progressWindow);
            }
        }
        return null;
    }

    @NotNull
    public String getTemplateDescription() {
        String string = KotlinBundle.message("surround.with.runtime.type.cast.template", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"su\u2026time.type.cast.template\")");
        return string;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder$SurroundWithCastWorker;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lorg/jetbrains/kotlin/idea/debugger/surroundWith/KotlinRuntimeTypeCastSurrounder;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "typeCalculationFinished", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "idea-jvm"})
    private final class SurroundWithCastWorker
    extends KotlinRuntimeTypeEvaluator {
        private final Editor myEditor;

        @Override
        protected void typeCalculationFinished(@Nullable KotlinType type2) {
            if (type2 == null) {
                return;
            }
            this.hold();
            Project project = this.myEditor.getProject();
            Runnable runnable = new Runnable(this, type2, project){
                final /* synthetic */ SurroundWithCastWorker this$0;
                final /* synthetic */ KotlinType $type;
                final /* synthetic */ Project $project;

                public final void run() {
                    new WriteCommandAction<Object>(this, this.$project, CodeInsightBundle.message((String)"command.name.surround.with.runtime.cast", (Object[])new Object[0]), new PsiFile[0]){
                        final /* synthetic */ typeCalculationFinished.1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void run(@NotNull Result<Object> result2) {
                            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
                            try {
                                PsiElement psiElement2 = SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0);
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"myElement");
                                Project project = psiElement2.getProject();
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myElement.project");
                                KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
                                ClassifierDescriptor classifierDescriptor = this.this$0.$type.getConstructor().getDeclarationDescriptor();
                                if (classifierDescriptor == null) {
                                    Intrinsics.throwNpe();
                                }
                                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(classifierDescriptor);
                                KtExpression ktExpression = factory2.createExpression("(expr as " + fqName2.asString() + ")");
                                if (ktExpression == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                                }
                                KtParenthesizedExpression parentCast = (KtParenthesizedExpression)ktExpression;
                                KtExpression ktExpression2 = parentCast.getExpression();
                                if (ktExpression2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
                                }
                                KtBinaryExpressionWithTypeRHS cast = (KtBinaryExpressionWithTypeRHS)ktExpression2;
                                cast.getLeft().replace(SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0));
                                PsiElement psiElement3 = SurroundWithCastWorker.access$getMyElement$p(this.this$0.this$0).replace((PsiElement)parentCast);
                                if (psiElement3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                                }
                                KtExpression expr2 = (KtExpression)psiElement3;
                                ShortenReferences.process$default(ShortenReferences.DEFAULT, expr2, null, 2, null);
                                TextRange range = expr2.getTextRange();
                                SelectionModel selectionModel = SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getSelectionModel();
                                TextRange textRange = range;
                                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
                                selectionModel.setSelection(textRange.getStartOffset(), range.getEndOffset());
                                SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getCaretModel().moveToOffset(range.getEndOffset());
                                SurroundWithCastWorker.access$getMyEditor$p(this.this$0.this$0).getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            }
                            finally {
                                this.this$0.this$0.release();
                            }
                        }
                        {
                            this.this$0 = $outer;
                            super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                        }
                    }.execute();
                }
                {
                    this.this$0 = surroundWithCastWorker;
                    this.$type = kotlinType;
                    this.$project = project;
                }
            };
            ProgressIndicator progressIndicator = this.myProgressIndicator;
            Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"myProgressIndicator");
            DebuggerInvocationUtil.invokeLater((Project)project, (Runnable)runnable, (ModalityState)progressIndicator.getModalityState());
        }

        public SurroundWithCastWorker(@NotNull Editor myEditor, @NotNull KtExpression expression2, @NotNull DebuggerContextImpl context, ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)myEditor, (String)"myEditor");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            super(myEditor, expression2, context, indicator);
            this.myEditor = myEditor;
        }

        public static final /* synthetic */ PsiElement access$getMyElement$p(SurroundWithCastWorker $this) {
            return $this.myElement;
        }

        @NotNull
        public static final /* synthetic */ Editor access$getMyEditor$p(SurroundWithCastWorker $this) {
            return $this.myEditor;
        }
    }
}

