/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtFunction;

public class KotlinLineBreakpointType
extends JavaLineBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", "Kotlin Line Breakpoints");
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position2) {
        JavaBreakpointProperties properties2;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (position2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(1);
        }
        if ((properties2 = KotlinLineBreakpointType.getProperties(breakpoint)) == null || properties2 instanceof JavaLineBreakpointProperties) {
            if (position2 instanceof KotlinPositionManager.KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties2 != null && ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return KotlinLineBreakpointType.inTheMethod(position2, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        KtFunction lambda2;
        SourcePosition position2;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(2);
        }
        if ((position2 = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        JavaBreakpointProperties properties2 = KotlinLineBreakpointType.getProperties(breakpoint);
        if (properties2 instanceof JavaLineBreakpointProperties && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal = ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal())) != null) {
            return lambda2;
        }
        return KotlinLineBreakpointType.getContainingMethod(position2.getElementAt());
    }

    @Nullable
    private static JavaBreakpointProperties getProperties(@NotNull LineBreakpoint<?> breakpoint) {
        XBreakpoint xBreakpoint;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(3);
        }
        return (xBreakpoint = breakpoint.getXBreakpoint()) != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
    }

    @Nullable
    private static KtFunction getLambdaByOrdinal(SourcePosition position2, Integer ordinal) {
        List<KtFunction> lambdas;
        if (ordinal != null && ordinal >= 0 && (lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position2)).size() > ordinal) {
            return lambdas.get(ordinal);
        }
        return null;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, (Class[])new Class[]{KtFunction.class, KtClassInitializer.class});
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (method == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(5);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)KotlinLineBreakpointType.getContainingMethod(elem), (Object)method);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        if (file2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(6);
        }
        if (project == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(7);
        }
        return BreakpointTypeUtilsKt.canPutAt(file2, line, project, ((Object)((Object)this)).getClass());
    }

    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position2) {
        if (project == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(8);
        }
        if (position2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(9);
        }
        List<JavaLineBreakpointType.JavaBreakpointVariant> list2 = BreakpointTypeUtilsKt.computeVariants(project, position2, this);
        if (list2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        KtFunction lambda2;
        SourcePosition position2;
        Breakpoint javaBreakpoint;
        Integer ordinal;
        JavaLineBreakpointProperties properties2 = (JavaLineBreakpointProperties)breakpoint.getProperties();
        if (properties2 != null && (ordinal = properties2.getLambdaOrdinal()) != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (position2 = ((LineBreakpoint)javaBreakpoint).getSourcePosition()) != null && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal)) != null) {
            return lambda2.getTextRange();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

