/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DiagnosticSuppressorForDebugger;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "()V", "isSuppressed", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea-jvm"})
public final class DiagnosticSuppressorForDebugger
implements DiagnosticSuppressor {
    @Override
    public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        PsiElement element3;
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = element3 = diagnostic.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
        PsiFile containingFile = psiElement2.getContainingFile();
        if (containingFile instanceof KtFile && CodeFragmentUtilKt.getSuppressDiagnosticsInDebugMode((KtFile)containingFile)) {
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            return Intrinsics.areEqual(diagnosticFactory, Errors.UNSAFE_CALL);
        }
        return false;
    }
}

