/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "toJdiName", "", "idea-jvm"})
public final class DebuggerClassNameProviderKt {
    private static final String toJdiName(@NotNull String $receiver) {
        return StringsKt.replace$default((String)$receiver, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final List<ReferenceType> findTargetClasses(@NotNull DebugProcess $receiver, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $receiver.getVirtualMachineProxy();
        if (!outerClass.isPrepared()) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            Iterable iterable;
            for (Location location2 : outerClass.allLineLocations()) {
                Method method;
                int locationLine = location2.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                iterable = targetClasses;
                iterable.add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                ReferenceType referenceType = nested;
                Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"nested");
                iterable = DebuggerClassNameProviderKt.findTargetClasses($receiver, referenceType, lineAt);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    @NotNull
    public static final /* synthetic */ List access$findTargetClasses(@NotNull DebugProcess $receiver, @NotNull ReferenceType outerClass, int lineAt) {
        return DebuggerClassNameProviderKt.findTargetClasses($receiver, outerClass, lineAt);
    }

    @NotNull
    public static final /* synthetic */ String access$toJdiName(@NotNull String $receiver) {
        return DebuggerClassNameProviderKt.toJdiName($receiver);
    }
}

