/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.FileAttributeProperty;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\b\u001a^\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b2\u001d\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000b\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014*\u00020\u0012\u001a4\u0010\u0015\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00122\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u0017\u001a\n\u0010\u0018\u001a\u00020\u0005*\u00020\u0012\u001a\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u00020\u0012\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011\u001a\u0018\u0010\u001d\u001a\u00020\u000f*\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001f\u001aB\u0010 \u001a\u00020\u000f\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u0001H\u00022\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010#\u001a\u0012\u0010$\u001a\u00020\u000f*\u00020\u001b2\u0006\u0010%\u001a\u00020\u0005\u001a\u0018\u0010&\u001a\u00020\u000f*\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001f\u00a8\u0006'"}, d2={"fileAttribute", "Lorg/jetbrains/kotlin/idea/core/util/FileAttributeProperty;", "T", "", "name", "", "version", "", "read", "Lkotlin/Function1;", "Ljava/io/DataInputStream;", "Lkotlin/ExtensionFunctionType;", "write", "Lkotlin/Function2;", "Ljava/io/DataOutputStream;", "", "readFile", "Ljava/io/File;", "Ljava/io/DataInput;", "readFileList", "", "readNullable", "readT", "(Ljava/io/DataInput;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readString", "readStringList", "writeFile", "Ljava/io/DataOutput;", "it", "writeFileList", "iterable", "", "writeNullable", "nullable", "writeT", "(Ljava/io/DataOutput;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "writeString", "string", "writeStringList", "idea-core"})
public final class FileAttributeUtilsKt {
    @NotNull
    public static final <T> FileAttributeProperty<T> fileAttribute(@NotNull String name2, int version, @NotNull Function1<? super DataInputStream, ? extends T> read2, @NotNull Function2<? super DataOutputStream, ? super T, Unit> write) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(read2, (String)"read");
        Intrinsics.checkParameterIsNotNull(write, (String)"write");
        return new FileAttributeProperty<T>(read2, write, name2, version, name2, version){
            final /* synthetic */ Function1 $read;
            final /* synthetic */ Function2 $write;
            final /* synthetic */ String $name;
            final /* synthetic */ int $version;

            @NotNull
            public T readValue(@NotNull DataInputStream input) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                return (T)this.$read.invoke((Object)input);
            }

            public void writeValue(@NotNull DataOutputStream output, @NotNull T value2) {
                Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
                Intrinsics.checkParameterIsNotNull(value2, (String)"value");
                this.$write.invoke((Object)output, value2);
            }
            {
                this.$read = $captured_local_variable$0;
                this.$write = $captured_local_variable$1;
                this.$name = $captured_local_variable$2;
                this.$version = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, null, 4, null);
            }
        };
    }

    @NotNull
    public static final List<String> readStringList(@NotNull DataInput $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List list2 = DataInputOutputUtil.readSeq((DataInput)$receiver, (ThrowableComputable)new ThrowableComputable<T, IOException>($receiver){
            final /* synthetic */ DataInput receiver$0;

            @NotNull
            public final String compute() {
                return FileAttributeUtilsKt.readString(this.receiver$0);
            }
            {
                this.receiver$0 = dataInput;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"readSeq(this) { readString() }");
        return list2;
    }

    @NotNull
    public static final List<File> readFileList(@NotNull DataInput $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List list2 = DataInputOutputUtil.readSeq((DataInput)$receiver, (ThrowableComputable)new ThrowableComputable<T, IOException>($receiver){
            final /* synthetic */ DataInput receiver$0;

            @NotNull
            public final File compute() {
                return FileAttributeUtilsKt.readFile(this.receiver$0);
            }
            {
                this.receiver$0 = dataInput;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"readSeq(this) { readFile() }");
        return list2;
    }

    @NotNull
    public static final String readString(@NotNull DataInput $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = IOUtil.readUTF((DataInput)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"readUTF(this)");
        return string;
    }

    @NotNull
    public static final File readFile(@NotNull DataInput $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String it = string = IOUtil.readUTF((DataInput)$receiver);
        return new File(it);
    }

    public static final void writeFileList(@NotNull DataOutput $receiver, @NotNull Iterable<? extends File> iterable) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        DataInputOutputUtil.writeSeq((DataOutput)$receiver, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)new ThrowableConsumer<T, IOException>($receiver){
            final /* synthetic */ DataOutput receiver$0;

            public final void consume(File it) {
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                FileAttributeUtilsKt.writeFile(this.receiver$0, file2);
            }
            {
                this.receiver$0 = dataOutput;
            }
        });
    }

    public static final void writeFile(@NotNull DataOutput $receiver, @NotNull File it) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        String string = it.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.canonicalPath");
        FileAttributeUtilsKt.writeString($receiver, string);
    }

    public static final void writeString(@NotNull DataOutput $receiver, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        IOUtil.writeUTF((DataOutput)$receiver, (String)string);
    }

    public static final void writeStringList(@NotNull DataOutput $receiver, @NotNull Iterable<String> iterable) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        DataInputOutputUtil.writeSeq((DataOutput)$receiver, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)new ThrowableConsumer<T, IOException>($receiver){
            final /* synthetic */ DataOutput receiver$0;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                FileAttributeUtilsKt.writeString(this.receiver$0, string);
            }
            {
                this.receiver$0 = dataOutput;
            }
        });
    }

    public static final <T> void writeNullable(@NotNull DataOutput $receiver, @Nullable T nullable, @NotNull Function2<? super DataOutput, ? super T, Unit> writeT) {
        block0: {
            T t;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(writeT, (String)"writeT");
            $receiver.writeBoolean(nullable != null);
            T t2 = nullable;
            if (t2 == null) break block0;
            T it = t = t2;
            writeT.invoke((Object)$receiver, it);
        }
    }

    @Nullable
    public static final <T> T readNullable(@NotNull DataInput $receiver, @NotNull Function1<? super DataInput, ? extends T> readT) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(readT, (String)"readT");
        boolean hasValue = $receiver.readBoolean();
        return (T)(hasValue ? readT.invoke((Object)$receiver) : null);
    }
}

