/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lcom/intellij/psi/impl/compiled/ClsCustomNavigationPolicyEx;", "()V", "getFileNavigationElement", "Lcom/intellij/psi/PsiClassOwner;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "getNavigationElement", "Lcom/intellij/psi/PsiClass;", "clsClass", "Lcom/intellij/psi/impl/compiled/ClsClassImpl;", "Lcom/intellij/psi/PsiElement;", "clsField", "Lcom/intellij/psi/impl/compiled/ClsFieldImpl;", "clsMethod", "Lcom/intellij/psi/impl/compiled/ClsMethodImpl;", "idea-core"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
extends ClsCustomNavigationPolicyEx {
    @Nullable
    public PsiClass getNavigationElement(@NotNull ClsClassImpl clsClass) {
        ClsClassImpl containingClass;
        Intrinsics.checkParameterIsNotNull((Object)clsClass, (String)"clsClass");
        PsiClass psiClass2 = clsClass.getContainingClass();
        if (!(psiClass2 instanceof ClsClassImpl)) {
            psiClass2 = null;
        }
        if ((containingClass = (ClsClassImpl)psiClass2) != null) {
            PsiClass psiClass3 = this.getNavigationElement(containingClass);
            return psiClass3 != null ? psiClass3.findInnerClassByName(clsClass.getName(), false) : null;
        }
        PsiFile psiFile = clsClass.getContainingFile();
        if (!(psiFile instanceof ClsFileImpl)) {
            psiFile = null;
        }
        ClsFileImpl clsFileImpl = (ClsFileImpl)psiFile;
        if (clsFileImpl == null) {
            return null;
        }
        ClsFileImpl clsFileImpl2 = clsFileImpl;
        Object[] objectArray = this.getFileNavigationElement(clsFileImpl2);
        return objectArray != null && (objectArray = objectArray.getClasses()) != null ? (PsiClass)ArraysKt.singleOrNull((Object[])objectArray) : null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsMethodImpl clsMethod) {
        PsiMethod psiMethod;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)clsMethod, (String)"clsMethod");
            PsiClass psiClass2 = clsMethod.getContainingClass();
            if (psiClass2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
            }
            PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
            if (psiClass3 == null) {
                return null;
            }
            PsiClass clsClass = psiClass3;
            PsiMethod[] psiMethodArray = clsClass.findMethodsByName(clsMethod.getName(), false);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"clsClass.findMethodsByName(clsMethod.name, false)");
            PsiMethod[] $receiver$iv = psiMethodArray;
            for (PsiMethod element$iv : $receiver$iv) {
                PsiMethod it = element$iv;
                if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)it, (PsiMethod)((PsiMethod)clsMethod))) continue;
                psiMethod = element$iv;
                break block3;
            }
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFieldImpl clsField) {
        Intrinsics.checkParameterIsNotNull((Object)clsField, (String)"clsField");
        PsiClass psiClass2 = clsField.getContainingClass();
        if (psiClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        PsiClass psiClass3 = this.getNavigationElement((ClsClassImpl)psiClass2);
        if (psiClass3 == null) {
            return null;
        }
        PsiClass srcClass = psiClass3;
        return (PsiElement)srcClass.findFieldByName(clsField.getName(), false);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiClassOwner getFileNavigationElement(@NotNull ClsFileImpl file2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        String packageName;
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile2 = file2.getVirtualFile();
        Project project2 = project = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ScriptDependenciesManager kotlinScriptConfigurationManager = ScriptDependenciesManager.Companion.getInstance(project2);
        if (!kotlinScriptConfigurationManager.getAllScriptsClasspathScope().contains(virtualFile2)) {
            return null;
        }
        Object[] objectArray = file2.getClasses();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"file.classes");
        Object object = ArraysKt.first((Object[])objectArray);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.compiled.ClsClassImpl");
        }
        String sourceFileName = ((ClsClassImpl)object).getSourceFileName();
        String string = packageName = file2.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName");
        CharSequence charSequence = string;
        String relativePath = charSequence.length() == 0 ? sourceFileName : StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + sourceFileName;
        Iterable iterable = $receiver$iv = (Iterable)kotlinScriptConfigurationManager.getAllLibrarySources();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (VirtualFile root : (List)destination$iv$iv) {
            PsiFile sourcePsi;
            VirtualFile sourceFile = root.findFileByRelativePath(relativePath);
            if (sourceFile == null || !sourceFile.isValid() || !((sourcePsi = file2.getManager().findFile(sourceFile)) instanceof PsiClassOwner)) continue;
            return (PsiClassOwner)sourcePsi;
        }
        return null;
    }
}

