/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.core.IterableTypesDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.util.ModifierChecksKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;", "", "project", "Lcom/intellij/openapi/project/Project;", "forLoopConventionsChecker", "Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "createDetector", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Companion", "Detector", "idea-core"})
public final class IterableTypesDetection {
    private final Project project;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;
    private static final Name iteratorName;
    public static final Companion Companion;

    @NotNull
    public final IterableTypesDetector createDetector(@NotNull LexicalScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return new Detector(scope2);
    }

    public IterableTypesDetection(@NotNull Project project, @NotNull ForLoopConventionsChecker forLoopConventionsChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)forLoopConventionsChecker, (String)"forLoopConventionsChecker");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.project = project;
        this.forLoopConventionsChecker = forLoopConventionsChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    static {
        Companion = new Companion(null);
        iteratorName = Name.identifier("iterator");
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\nH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector;", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "(Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;)V", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "typesWithExtensionIterator", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "canBeIterable", "", "type", "elementType", "elementTypeNoCache", "isIterable", "loopVarType", "idea-core"})
    private final class Detector
    implements IterableTypesDetector {
        private final HashMap<FuzzyType, FuzzyType> cache;
        private final Collection<KotlinType> typesWithExtensionIterator;
        private final LexicalScope scope;

        @Override
        public boolean isIterable(@NotNull FuzzyType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            FuzzyType fuzzyType = this.elementType(type2);
            if (fuzzyType == null) {
                return false;
            }
            FuzzyType elementType = fuzzyType;
            return loopVarType == null || elementType.checkIsSubtypeOf(loopVarType) != null;
        }

        @Override
        public boolean isIterable(@NotNull KotlinType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.isIterable(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()), loopVarType);
        }

        private final FuzzyType elementType(FuzzyType type2) {
            Object object;
            Map $receiver$iv = this.cache;
            if (!$receiver$iv.containsKey(type2)) {
                FuzzyType answer$iv = this.elementTypeNoCache(type2);
                $receiver$iv.put(type2, answer$iv);
                object = answer$iv;
            } else {
                object = $receiver$iv.get(type2);
            }
            return (FuzzyType)object;
        }

        @Override
        @Nullable
        public FuzzyType elementType(@NotNull KotlinType type2) {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            return this.elementType(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()));
        }

        private final FuzzyType elementTypeNoCache(FuzzyType type2) {
            FuzzyType fuzzyType;
            KotlinType elementType;
            if (!this.canBeIterable(type2)) {
                return null;
            }
            KtExpression expression2 = new KtPsiFactory(IterableTypesDetection.this.project, false, 2, null).createExpression("fake");
            ExpressionTypingContext context = ExpressionTypingContext.newContext(new BindingTraceContext(), this.scope, DataFlowInfo.Companion.getEMPTY(), TypeUtils.NO_EXPECTED_TYPE, IterableTypesDetection.this.languageVersionSettings, IterableTypesDetection.this.dataFlowValueFactory);
            KotlinType kotlinType = type2.getType();
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            BindingContext bindingContext2 = bindingTrace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
            ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(expression2, kotlinType, bindingContext2);
            KotlinType kotlinType2 = elementType = IterableTypesDetection.this.forLoopConventionsChecker.checkIterableConvention(expressionReceiver, context);
            if (kotlinType2 != null) {
                KotlinType kotlinType3;
                KotlinType it;
                KotlinType kotlinType4 = it = (kotlinType3 = kotlinType2);
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"it");
                fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType4, (Collection<? extends TypeParameterDescriptor>)type2.getFreeParameters());
            } else {
                fuzzyType = null;
            }
            return fuzzyType;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canBeIterable(FuzzyType type2) {
            boolean bl;
            MemberScope memberScope2 = type2.getType().getMemberScope();
            Name name2 = iteratorName;
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"iteratorName");
            Collection<SimpleFunctionDescriptor> collection = memberScope2.getContributedFunctions(name2, NoLookupLocation.FROM_IDE);
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            Iterable $receiver$iv = this.typesWithExtensionIterator;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KotlinType it = (KotlinType)element$iv;
                Iterable iterable = $receiver$iv2 = (Iterable)it.getArguments();
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    TypeParameterDescriptor typeParameterDescriptor;
                    Object element$iv$iv = element$iv$iv$iv;
                    TypeProjection it2 = (TypeProjection)element$iv$iv;
                    ClassifierDescriptor classifierDescriptor = it2.getType().getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                        classifierDescriptor = null;
                    }
                    if ((TypeParameterDescriptor)classifierDescriptor == null) continue;
                    TypeParameterDescriptor it$iv$iv = typeParameterDescriptor;
                    destination$iv$iv.add(it$iv$iv);
                }
                List freeParams = (List)destination$iv$iv;
                if (type2.checkIsSubtypeOf(FuzzyTypeUtils.toFuzzyType(it, freeParams)) != null) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public Detector(LexicalScope scope2) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            this.scope = scope2;
            this.cache = new HashMap();
            HierarchicalScope hierarchicalScope = this.scope;
            Name name2 = iteratorName;
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"iteratorName");
            Iterable iterable = ScopeUtilsKt.collectFunctions(hierarchicalScope, name2, NoLookupLocation.FROM_IDE);
            Detector detector2 = this;
            void var4_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                if (!ModifierChecksKt.isValidOperator(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)list2;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator2 = $receiver$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinType kotlinType;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                ReceiverParameterDescriptor receiverParameterDescriptor = it.getExtensionReceiverParameter();
                KotlinType kotlinType2 = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
                if (kotlinType2 == null) continue;
                KotlinType it$iv$iv = kotlinType = kotlinType2;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            detector2.typesWithExtensionIterator = list2;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Companion;", "", "()V", "iteratorName", "Lorg/jetbrains/kotlin/name/Name;", "idea-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

