/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JSLibraryType;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u001c\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryMatcher", "Lkotlin/Function2;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function2;", "libraryName", "getLibraryName", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "findAndFixBrokenKotlinLibrary", "module", "Lcom/intellij/openapi/module/Module;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "getLibraryJarDescriptors", "", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isConfigured", "Companion", "idea-jvm"})
public class KotlinJsModuleConfigurator
extends KotlinWithLibraryConfigurator {
    @NotNull
    private final Function2<Library, Project, Boolean> libraryMatcher = libraryMatcher.1.INSTANCE;
    @NotNull
    public static final String NAME = "js";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JsPlatform.INSTANCE;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "JavaScript";
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJsRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return JSLibraryStdDescription.Companion.getLIBRARY_NAME();
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JSLibraryStdDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        return JSLibraryStdDescription.Companion.getLIBRARY_CAPTION();
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JSLibraryStdDescription.Companion.getJAVA_SCRIPT_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk sdk) {
        return CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.JS_STDLIB_JAR, LibraryJarDescriptor.JS_STDLIB_SRC_JAR});
    }

    @Override
    @NotNull
    protected Function2<Library, Project, Boolean> getLibraryMatcher() {
        return this.libraryMatcher;
    }

    @Override
    @Nullable
    public LibraryType<DummyLibraryProperties> getLibraryType() {
        return JSLibraryType.Companion.getInstance();
    }

    @Override
    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        List allLibraries = new ArrayList();
        Library brokenStdlib = null;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
            LibraryEx library2;
            OrderEntry orderEntry2 = orderEntry;
            if (!(orderEntry2 instanceof LibraryOrderEntry)) {
                orderEntry2 = null;
            }
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if (!(object instanceof LibraryEx)) {
                object = null;
            }
            if ((LibraryEx)object == null) {
                continue;
            }
            allLibraries.add(library2);
            Library library3 = (Library)library2;
            Project project = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
            if (!JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar(library3, project, true) || library2.getKind() != null) continue;
            brokenStdlib = (Library)library2;
        }
        if (brokenStdlib != null) {
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(allLibraries){
                final /* synthetic */ List $allLibraries;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.$allLibraries;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        LibraryEx it = (LibraryEx)element$iv$iv;
                        if (!(it.getKind() == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    for (LibraryEx library2 : (List)destination$iv$iv) {
                        LibraryEx.ModifiableModelEx modifiableModelEx;
                        LibraryEx.ModifiableModelEx $receiver = modifiableModelEx = library2.getModifiableModel();
                        $receiver.setKind((PersistentLibraryKind)JSLibraryKind.INSTANCE);
                        $receiver.commit();
                    }
                }
                {
                    this.$allLibraries = list2;
                    super(0);
                }
            });
            collector2.addMessage("Updated JavaScript libraries in module " + module.getName());
        }
        return brokenStdlib;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator$Companion;", "", "()V", "NAME", "", "idea-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

