/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleProjectDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "idea-gradle"})
public final class KotlinGradleProjectDataService
extends AbstractProjectDataService<ModuleData, Void> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        return ProjectKeys.MODULE;
    }

    public void postProcess(@NotNull Collection<DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<ModuleData> moduleNode : toImport) {
            Module ideModule;
            Collection collection;
            Intrinsics.checkExpressionValueIsNotNull((Object)ExternalSystemApiUtil.getChildren(moduleNode, (Key)GradleSourceSetData.KEY), (String)"ExternalSystemApiUtil.ge\u2026 GradleSourceSetData.KEY)");
            if (!collection.isEmpty()) continue;
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            if (modelsProvider.findIdeModule(moduleData) == null) {
                continue;
            }
            Module module = ideModule;
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ideModule");
            if (KotlinGradleSourceSetDataServiceKt.access$configureFacetByGradleModule(moduleNode, null, module, modelsProvider) == null) {
                continue;
            }
            Iterable $receiver$iv = GradleProjectImportHandler.Companion.getInstances(project);
            for (Object element$iv : $receiver$iv) {
                KotlinFacet kotlinFacet;
                GradleProjectImportHandler it = (GradleProjectImportHandler)element$iv;
                it.importByModule(kotlinFacet, moduleNode);
            }
        }
    }
}

