/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkHideNonConfiguredNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "idea-jvm"})
public final class ConfigureKotlinNotificationManagerKt {
    private static final AtomicBoolean checkInProgress = new AtomicBoolean(false);
    private static final Logger LOG = Logger.getInstance(ConfigureKotlinNotificationManager.class);

    public static final void checkHideNonConfiguredNotifications(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (checkInProgress.get()) {
            return;
        }
        ConfigureKotlinNotification configureKotlinNotification = (ConfigureKotlinNotification)((Object)ArraysKt.firstOrNull((Object[])ConfigureKotlinNotificationManager.INSTANCE.getVisibleNotifications(project)));
        if (configureKotlinNotification == null) {
            return;
        }
        ConfigureKotlinNotification notification2 = configureKotlinNotification;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, notification2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ConfigureKotlinNotification $notification;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                boolean hideNotification2;
                boolean bl;
                if (!ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().compareAndSet(false, true)) {
                    return;
                }
                DumbService.getInstance((Project)this.$project).waitForSmartMode();
                ModuleSourceRootMap moduleSourceRootMap = new ModuleSourceRootMap(this.$project);
                if (Intrinsics.areEqual((Object)this.$notification.getNotificationState().getDebugProjectName(), (Object)this.$project.getName()) ^ true) {
                    ConfigureKotlinNotificationManagerKt.access$getLOG$p().error("Bad notification check for project: " + this.$project.getName() + '\n' + this.$notification.getNotificationState());
                }
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) {
                    boolean bl2;
                    try {
                        boolean bl3;
                        block13: {
                            Object element$iv$iv$iv;
                            Iterable $receiver$iv$iv;
                            Iterable $receiver$iv;
                            Iterable iterable = this.$notification.getNotificationState().getNotConfiguredModules();
                            Iterator<T> iterator2 = $receiver$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            Iterator<T> $receiver$iv$iv$iv = $receiver$iv$iv;
                            Iterator<T> iterator3 = $receiver$iv$iv$iv.iterator();
                            while (iterator3.hasNext()) {
                                Module module;
                                T element$iv$iv = element$iv$iv$iv = iterator3.next();
                                String it = (String)element$iv$iv;
                                if (ModuleManager.getInstance((Project)this.$project).findModuleByName(it) == null) continue;
                                Module it$iv$iv = module;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            $receiver$iv = (List)destination$iv$iv;
                            $receiver$iv$iv = $receiver$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (T item$iv$iv : $receiver$iv$iv) {
                                void it;
                                element$iv$iv$iv = (Module)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                void v1 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                                ModuleSourceRootGroup moduleSourceRootGroup = moduleSourceRootMap.getWholeModuleGroup((Module)v1);
                                collection.add(moduleSourceRootGroup);
                            }
                            List moduleSourceRootGroups = (List)destination$iv$iv;
                            $receiver$iv = moduleSourceRootGroups;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (T element$iv : $receiver$iv) {
                                    ModuleSourceRootGroup p1 = (ModuleSourceRootGroup)element$iv;
                                    if (!ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(p1)) continue;
                                    bl3 = false;
                                    break block13;
                                }
                                bl3 = true;
                            }
                        }
                        bl2 = bl3;
                    }
                    catch (IndexNotReadyException e) {
                        ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                            final /* synthetic */ checkHideNonConfiguredNotifications.1 this$0;

                            public final void run() {
                                ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(this.this$0.$project);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        return;
                    }
                    bl = bl2;
                } else {
                    bl = hideNotification2 = true;
                }
                if (hideNotification2) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ checkHideNonConfiguredNotifications.1 this$0;

                        public final void run() {
                            ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications(this.this$0.$project);
                            ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    ConfigureKotlinNotificationManagerKt.access$getCheckInProgress$p().set(false);
                }
            }
            {
                this.$project = project;
                this.$notification = configureKotlinNotification;
            }
        });
    }

    @NotNull
    public static final /* synthetic */ AtomicBoolean access$getCheckInProgress$p() {
        return checkInProgress;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

