/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.InsertHandlerProvider;
import org.jetbrains.kotlin.idea.completion.PackageDirectiveCompletion;
import org.jetbrains.kotlin.idea.core.ExpectedInfo;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R5\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/PackageDirectiveCompletion;", "", "()V", "ACTIVATION_PATTERN", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "getACTIVATION_PATTERN", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "DUMMY_IDENTIFIER", "", "getDUMMY_IDENTIFIER", "()Ljava/lang/String;", "perform", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "idea"})
public final class PackageDirectiveCompletion {
    @NotNull
    private static final String DUMMY_IDENTIFIER = "___package___";
    private static final PsiElementPattern.Capture<PsiElement> ACTIVATION_PATTERN;
    public static final PackageDirectiveCompletion INSTANCE;

    @NotNull
    public final String getDUMMY_IDENTIFIER() {
        return DUMMY_IDENTIFIER;
    }

    public final PsiElementPattern.Capture<PsiElement> getACTIVATION_PATTERN() {
        return ACTIVATION_PATTERN;
    }

    public final boolean perform(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        String string;
        String prefix;
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        PsiElement position2 = parameters2.getPosition();
        if (!ACTIVATION_PATTERN.accepts((Object)position2)) {
            return false;
        }
        PsiElement psiElement2 = position2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"position");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file2 = (KtFile)psiFile;
        PsiElement psiElement3 = file2.findElementAt(parameters2.getOffset());
        Object object = psiElement3 != null ? psiElement3.getParent() : null;
        if (!(object instanceof KtSimpleNameExpression)) {
            object = null;
        }
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)object;
        if (ktSimpleNameExpression == null) {
            return false;
        }
        KtSimpleNameExpression expression2 = ktSimpleNameExpression;
        int prefixLength = parameters2.getOffset() - expression2.getTextOffset();
        String string2 = expression2.getText();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = prefix = string2;
        int n = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, prefixLength);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string6 = string = string5;
        PlainPrefixMatcher prefixMatcher = new PlainPrefixMatcher(string6);
        CompletionResultSet result3 = result2.withPrefixMatcher((PrefixMatcher)prefixMatcher);
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(expression2);
        ModuleDescriptor moduleDescriptor = resolutionFacade.getModuleDescriptor();
        FqName fqName2 = file2.getPackageFqName().parent();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"file.packageFqName.parent()");
        MemberScope packageMemberScope = moduleDescriptor.getPackage(fqName2).getMemberScope();
        Collection<DeclarationDescriptor> variants = packageMemberScope.getContributedDescriptors(DescriptorKindFilter.PACKAGES, CompletionUtilsKt.asNameFilter((PrefixMatcher)prefixMatcher));
        BasicLookupElementFactory lookupElementFactory2 = new BasicLookupElementFactory(resolutionFacade.getProject(), new InsertHandlerProvider(CallType.PACKAGE_DIRECTIVE.INSTANCE, (Function0<? extends Collection<ExpectedInfo>>)((Function0)perform.lookupElementFactory.1.INSTANCE)));
        for (DeclarationDescriptor variant : variants) {
            LookupElement lookupElement2 = BasicLookupElementFactory.createLookupElement$default(lookupElementFactory2, variant, false, false, false, 14, null);
            String string7 = lookupElement2.getLookupString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"lookupElement.lookupString");
            if (StringsKt.contains$default((CharSequence)string7, (CharSequence)DUMMY_IDENTIFIER, (boolean)false, (int)2, null)) continue;
            result3.addElement(lookupElement2);
        }
        return true;
    }

    private PackageDirectiveCompletion() {
    }

    static {
        PackageDirectiveCompletion packageDirectiveCompletion;
        INSTANCE = packageDirectiveCompletion = new PackageDirectiveCompletion();
        DUMMY_IDENTIFIER = DUMMY_IDENTIFIER;
        ACTIVATION_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(KtPackageDirective.class);
    }
}

